/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.stats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.code.SwitchInstruction;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.DecHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.SwitchHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.SwitchExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.TextBuffer;

public final class SwitchStatement
extends Statement {
    private List<Statement> caseStatements;
    private List<List<StatEdge>> caseEdges;
    private List<List<@Nullable Exprent>> caseValues;
    private StatEdge defaultEdge;
    private Exprent headExprent;

    private SwitchStatement() {
        super(Statement.StatementType.SWITCH);
        this.caseStatements = new ArrayList<Statement>();
        this.caseEdges = new ArrayList<List<StatEdge>>();
        this.caseValues = new ArrayList<List<Exprent>>();
    }

    private SwitchStatement(@NotNull Statement head, @Nullable Statement postStatement) {
        if (head == null) {
            SwitchStatement.$$$reportNull$$$0(0);
        }
        this();
        this.first = head;
        this.stats.addWithKey(head, head.id);
        HashSet<Statement> regularSuccessors = new HashSet<Statement>(head.getNeighbours(StatEdge.EdgeType.REGULAR, StatEdge.EdgeDirection.FORWARD));
        if (postStatement != null) {
            this.post = postStatement;
            regularSuccessors.remove(this.post);
        }
        this.defaultEdge = head.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL).get(0);
        for (Statement successor : regularSuccessors) {
            this.stats.addWithKey(successor, successor.id);
        }
    }

    @Nullable
    public static Statement isHead(@NotNull Statement head) {
        ArrayList statements;
        if (head == null) {
            SwitchStatement.$$$reportNull$$$0(1);
        }
        if (head.type == Statement.StatementType.BASIC_BLOCK && head.getLastBasicType() == Statement.StatementType.SWITCH && DecHelper.isChoiceStatement(head, statements = new ArrayList())) {
            Statement post = (Statement)statements.remove(0);
            for (Statement statement : statements) {
                if (!statement.isMonitorEnter()) continue;
                return null;
            }
            if (DecHelper.checkStatementExceptions(statements)) {
                return new SwitchStatement(head, post);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public TextBuffer toJava(int indent, @NotNull BytecodeMappingTracer tracer) {
        if (tracer == null) {
            SwitchStatement.$$$reportNull$$$0(2);
        }
        SwitchHelper.simplifySwitchOnEnum(this);
        TextBuffer buf = new TextBuffer();
        buf.append(ExprProcessor.listToJava(this.varDefinitions, indent, tracer));
        buf.append(this.first.toJava(indent, tracer));
        if (this.isLabeled()) {
            buf.appendIndent(indent).append("label").append(Integer.toString(this.id)).append(":").appendLineSeparator();
            tracer.incrementCurrentSourceLine();
        }
        buf.appendIndent(indent).append(this.headExprent.toJava(indent, tracer)).append(" {").appendLineSeparator();
        tracer.incrementCurrentSourceLine();
        VarType switchType = this.headExprent.getExprType();
        for (int i = 0; i < this.caseStatements.size(); ++i) {
            Statement stat = this.caseStatements.get(i);
            List<StatEdge> edges = this.caseEdges.get(i);
            List<Exprent> values = this.caseValues.get(i);
            for (int j = 0; j < edges.size(); ++j) {
                if (edges.get(j) == this.defaultEdge) {
                    buf.appendIndent(indent + 1).append("default:").appendLineSeparator();
                } else {
                    buf.appendIndent(indent + 1).append("case ");
                    Exprent value = values.get(j);
                    if (value instanceof ConstExprent) {
                        value = value.copy();
                        ((ConstExprent)value).setConstType(switchType);
                    }
                    if (value instanceof FieldExprent && ((FieldExprent)value).isStatic()) {
                        buf.append(((FieldExprent)value).getName());
                    } else {
                        buf.append(value.toJava(indent, tracer));
                    }
                    buf.append(":").appendLineSeparator();
                }
                tracer.incrementCurrentSourceLine();
            }
            buf.append(ExprProcessor.jmpWrapper(stat, indent + 2, false, tracer));
        }
        buf.appendIndent(indent).append("}").appendLineSeparator();
        tracer.incrementCurrentSourceLine();
        TextBuffer textBuffer = buf;
        if (textBuffer == null) {
            SwitchStatement.$$$reportNull$$$0(3);
        }
        return textBuffer;
    }

    @Override
    public void initExprents() {
        SwitchExprent exprent = (SwitchExprent)this.first.getExprents().remove(this.first.getExprents().size() - 1);
        exprent.setCaseValues(this.caseValues);
        this.headExprent = exprent;
    }

    @Override
    @NotNull
    public List<Object> getSequentialObjects() {
        ArrayList<Object> result = new ArrayList<Object>(this.stats);
        result.add(1, this.headExprent);
        ArrayList<Object> arrayList = result;
        if (arrayList == null) {
            SwitchStatement.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    public void replaceExprent(Exprent oldExprent, Exprent newExprent) {
        if (this.headExprent == oldExprent) {
            this.headExprent = newExprent;
        }
    }

    @Override
    public void replaceStatement(Statement oldStatement, Statement newStatement) {
        for (int i = 0; i < this.caseStatements.size(); ++i) {
            if (this.caseStatements.get(i) != oldStatement) continue;
            this.caseStatements.set(i, newStatement);
        }
        super.replaceStatement(oldStatement, newStatement);
    }

    @Override
    @NotNull
    public Statement getSimpleCopy() {
        return new SwitchStatement();
    }

    @Override
    public void initSimpleCopy() {
        this.first = (Statement)this.stats.get(0);
        this.defaultEdge = this.first.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL).get(0);
        this.sortEdgesAndNodes();
    }

    public void sortEdgesAndNodes() {
        HashMap<StatEdge, Integer> edgeIndicesMapping = new HashMap<StatEdge, Integer>();
        List<StatEdge> firstSuccessors = this.first.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL);
        for (int i = 0; i < firstSuccessors.size(); ++i) {
            edgeIndicesMapping.put(firstSuccessors.get(i), i == 0 ? firstSuccessors.size() : i);
        }
        BasicBlockStatement firstBlock = (BasicBlockStatement)this.first;
        int[] values = ((SwitchInstruction)firstBlock.getBlock().getLastInstruction()).getValues();
        ArrayList<@Nullable Statement> caseStatements = new ArrayList<Statement>(this.stats.size() - 1);
        ArrayList<List<Integer>> edgeIndices = new ArrayList<List<Integer>>(this.stats.size() - 1);
        this.collectRegularEdgesIndices(edgeIndicesMapping, caseStatements, edgeIndices);
        this.collectExitEdgesIndices(edgeIndicesMapping, caseStatements, edgeIndices);
        this.sortEdges(caseStatements, edgeIndices);
        ArrayList<List<StatEdge>> caseEdges = new ArrayList<List<StatEdge>>(edgeIndices.size());
        ArrayList<List<@Nullable Exprent>> caseValues = new ArrayList<List<Exprent>>(edgeIndices.size());
        this.mapEdgeIndicesToEdges(values, edgeIndices, caseEdges, caseValues);
        this.replaceNullStatementsWithBasicBlocks(caseStatements, caseEdges);
        this.caseStatements = caseStatements;
        this.caseEdges = caseEdges;
        this.caseValues = caseValues;
    }

    private void mapEdgeIndicesToEdges(int[] values, @NotNull List<List<Integer>> edgeIndices, @NotNull List<List<StatEdge>> caseEdges, @NotNull List<List<@Nullable Exprent>> caseValues) {
        if (edgeIndices == null) {
            SwitchStatement.$$$reportNull$$$0(5);
        }
        if (caseEdges == null) {
            SwitchStatement.$$$reportNull$$$0(6);
        }
        if (caseValues == null) {
            SwitchStatement.$$$reportNull$$$0(7);
        }
        for (List<Integer> indices : edgeIndices) {
            ArrayList<StatEdge> edges = new ArrayList<StatEdge>(indices.size());
            ArrayList<ConstExprent> valueExprents = new ArrayList<ConstExprent>(indices.size());
            List<StatEdge> firstSuccessors = this.first.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL);
            for (Integer in : indices) {
                int index = in.intValue() == firstSuccessors.size() ? 0 : in;
                edges.add(firstSuccessors.get(index));
                valueExprents.add(index == 0 ? null : new ConstExprent(values[index - 1], false, null));
            }
            caseEdges.add(edges);
            caseValues.add(valueExprents);
        }
    }

    private void collectRegularEdgesIndices(@NotNull Map<StatEdge, Integer> edgeIndicesMapping, @NotNull List<@Nullable Statement> nodes, @NotNull List<List<Integer>> edgeIndices) {
        if (edgeIndicesMapping == null) {
            SwitchStatement.$$$reportNull$$$0(8);
        }
        if (nodes == null) {
            SwitchStatement.$$$reportNull$$$0(9);
        }
        if (edgeIndices == null) {
            SwitchStatement.$$$reportNull$$$0(10);
        }
        for (int i = 1; i < this.stats.size(); ++i) {
            Statement statement = (Statement)this.stats.get(i);
            ArrayList<Integer> regularEdgeIndices = new ArrayList<Integer>();
            for (StatEdge regularEdge : statement.getPredecessorEdges(StatEdge.EdgeType.REGULAR)) {
                if (regularEdge.getSource() != this.first) continue;
                regularEdgeIndices.add(edgeIndicesMapping.get(regularEdge));
            }
            Collections.sort(regularEdgeIndices);
            nodes.add(statement);
            edgeIndices.add(regularEdgeIndices);
        }
    }

    private void collectExitEdgesIndices(@NotNull Map<StatEdge, Integer> edgeIndicesMapping, @NotNull List<@Nullable Statement> nodes, @NotNull List<List<Integer>> edgeIndices) {
        if (edgeIndicesMapping == null) {
            SwitchStatement.$$$reportNull$$$0(11);
        }
        if (nodes == null) {
            SwitchStatement.$$$reportNull$$$0(12);
        }
        if (edgeIndices == null) {
            SwitchStatement.$$$reportNull$$$0(13);
        }
        List<StatEdge> firstExitEdges = this.first.getSuccessorEdges(StatEdge.EdgeType.BREAK.unite(StatEdge.EdgeType.CONTINUE));
        while (!firstExitEdges.isEmpty()) {
            StatEdge exitEdge = firstExitEdges.get(0);
            ArrayList<Integer> exitEdgeIndices = new ArrayList<Integer>();
            for (int i = firstExitEdges.size() - 1; i >= 0; --i) {
                StatEdge edgeTemp = firstExitEdges.get(i);
                if (edgeTemp.getDestination() != exitEdge.getDestination() || edgeTemp.getType() != exitEdge.getType()) continue;
                exitEdgeIndices.add(edgeIndicesMapping.get(edgeTemp));
                firstExitEdges.remove(i);
            }
            Collections.sort(exitEdgeIndices);
            nodes.add(null);
            edgeIndices.add(exitEdgeIndices);
        }
    }

    private void sortEdges(List<@Nullable Statement> nodes, @NotNull List<List<Integer>> edgeIndices) {
        if (edgeIndices == null) {
            SwitchStatement.$$$reportNull$$$0(14);
        }
        for (int i = 0; i < edgeIndices.size() - 1; ++i) {
            for (int j = edgeIndices.size() - 1; j > i; --j) {
                if (edgeIndices.get(j - 1).get(0) <= edgeIndices.get(j).get(0)) continue;
                edgeIndices.set(j, edgeIndices.set(j - 1, edgeIndices.get(j)));
                nodes.set(j, nodes.set(j - 1, nodes.get(j)));
            }
        }
        block2: for (int index = 0; index < nodes.size(); ++index) {
            Statement node = nodes.get(index);
            if (node == null) continue;
            HashSet<Statement> nodePredecessors = new HashSet<Statement>(node.getNeighbours(StatEdge.EdgeType.REGULAR, StatEdge.EdgeDirection.BACKWARD));
            nodePredecessors.remove(this.first);
            if (nodePredecessors.isEmpty()) continue;
            Statement predecessor = nodePredecessors.iterator().next();
            for (int j = 0; j < nodes.size(); ++j) {
                if (j == index - 1 || nodes.get(j) != predecessor) continue;
                nodes.add(j + 1, node);
                edgeIndices.add(j + 1, edgeIndices.get(index));
                if (j > index) {
                    nodes.remove(index);
                    edgeIndices.remove(index);
                    --index;
                    continue block2;
                }
                nodes.remove(index + 1);
                edgeIndices.remove(index + 1);
                continue block2;
            }
        }
    }

    private void replaceNullStatementsWithBasicBlocks(List<@Nullable Statement> statements, @NotNull List<List<StatEdge>> edges) {
        if (edges == null) {
            SwitchStatement.$$$reportNull$$$0(15);
        }
        for (int i = 0; i < statements.size(); ++i) {
            if (statements.get(i) != null) continue;
            BasicBlockStatement basicBlock = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
            StatEdge sampleEdge = edges.get(i).get(0);
            basicBlock.addSuccessor(new StatEdge(sampleEdge.getType(), basicBlock, sampleEdge.getDestination(), sampleEdge.closure));
            for (StatEdge edge : edges.get(i)) {
                edge.getSource().changeEdgeType(StatEdge.EdgeDirection.FORWARD, edge, StatEdge.EdgeType.REGULAR);
                edge.closure.getLabelEdges().remove(edge);
                edge.getDestination().removePredecessor(edge);
                edge.getSource().changeEdgeNode(StatEdge.EdgeDirection.FORWARD, edge, basicBlock);
                basicBlock.addPredecessor(edge);
            }
            statements.set(i, basicBlock);
            this.stats.addWithKey(basicBlock, basicBlock.id);
            basicBlock.setParent(this);
        }
    }

    @NotNull
    public List<Exprent> getHeadExprentList() {
        List<Exprent> list = Collections.singletonList(this.headExprent);
        if (list == null) {
            SwitchStatement.$$$reportNull$$$0(16);
        }
        return list;
    }

    @Nullable
    public Exprent getHeadExprent() {
        return this.headExprent;
    }

    @NotNull
    public List<List<StatEdge>> getCaseEdges() {
        List<List<StatEdge>> list = this.caseEdges;
        if (list == null) {
            SwitchStatement.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    public List<Statement> getCaseStatements() {
        List<Statement> list = this.caseStatements;
        if (list == null) {
            SwitchStatement.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public StatEdge getDefaultEdge() {
        StatEdge statEdge = this.defaultEdge;
        if (statEdge == null) {
            SwitchStatement.$$$reportNull$$$0(19);
        }
        return statEdge;
    }

    public @NotNull List<List<@Nullable Exprent>> getCaseValues() {
        List<List<Exprent>> list = this.caseValues;
        if (list == null) {
            SwitchStatement.$$$reportNull$$$0(20);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 16, 17, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "head";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracer";
                break;
            }
            case 3: 
            case 4: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/java/decompiler/modules/decompiler/stats/SwitchStatement";
                break;
            }
            case 5: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeIndices";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseEdges";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseValues";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeIndicesMapping";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/java/decompiler/modules/decompiler/stats/SwitchStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toJava";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSequentialObjects";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeadExprentList";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaseEdges";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaseStatements";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultEdge";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaseValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isHead";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toJava";
                break;
            }
            case 3: 
            case 4: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mapEdgeIndicesToEdges";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectRegularEdgesIndices";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectExitEdgesIndices";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sortEdges";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replaceNullStatementsWithBasicBlocks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 16, 17, 18, 19, 20 -> new IllegalStateException(string);
        };
    }
}

