/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Component;
import java.awt.Insets;
import java.util.Map;
import javax.swing.JSplitPane;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.util.Maps;

final class JSplitPaneLocationCalculator {
    private static Map<Integer, LocationFinder> FINDERS = Maps.newHashMap();

    private static void add(LocationFinder ... finders) {
        for (LocationFinder finder : finders) {
            FINDERS.put(finder.orientation(), finder);
        }
    }

    @RunsInEDT
    static int locationToMoveDividerTo(@Nonnull JSplitPane splitPane, int desiredLocation) {
        Integer result2 = GuiActionRunner.execute(() -> FINDERS.get(splitPane.getOrientation()).locationToMoveDividerTo(splitPane, desiredLocation));
        return Preconditions.checkNotNull(result2);
    }

    private JSplitPaneLocationCalculator() {
    }

    static {
        JSplitPaneLocationCalculator.add(new VerticalOrientationLocationFinder(), new HorizontalOrientationLocationFinder());
    }

    private static class HorizontalOrientationLocationFinder
    extends LocationFinder {
        private HorizontalOrientationLocationFinder() {
        }

        @Override
        @RunsInCurrentThread
        int locationToMoveDividerTo(@Nonnull JSplitPane splitPane, int desiredLocation) {
            int minimum = this.calculateMinimum(splitPane);
            int maximum = this.calculateMaximum(splitPane);
            if (maximum < minimum) {
                maximum = 0;
                minimum = 0;
            }
            return Math.min(maximum, Math.max(minimum, desiredLocation));
        }

        @RunsInCurrentThread
        private int calculateMinimum(@Nonnull JSplitPane splitPane) {
            Component left = splitPane.getLeftComponent();
            if (left == null || !left.isVisible()) {
                return 0;
            }
            int minimum = left.getMinimumSize().width;
            Insets insets = splitPane.getInsets();
            if (insets != null) {
                minimum += insets.left;
            }
            return minimum;
        }

        @RunsInCurrentThread
        private int calculateMaximum(@Nonnull JSplitPane splitPane) {
            Component rightComponent = splitPane.getRightComponent();
            if (splitPane.getLeftComponent() == null || rightComponent == null) {
                return -1;
            }
            Insets insets = splitPane.getInsets();
            int dividerSize = splitPane.getDividerSize();
            int right = insets != null ? insets.right : 0;
            int splitPaneWidth = splitPane.getSize().width;
            if (!rightComponent.isVisible()) {
                return Math.max(0, splitPaneWidth - (dividerSize + right));
            }
            return Math.max(0, splitPaneWidth - (dividerSize + right) - rightComponent.getMinimumSize().width);
        }

        @Override
        int orientation() {
            return 1;
        }
    }

    private static class VerticalOrientationLocationFinder
    extends LocationFinder {
        private VerticalOrientationLocationFinder() {
        }

        @Override
        @RunsInCurrentThread
        int locationToMoveDividerTo(@Nonnull JSplitPane splitPane, int desiredLocation) {
            int minimum = this.calculateMinimum(splitPane);
            int maximum = this.calculateMaximum(splitPane);
            if (maximum < minimum) {
                maximum = 0;
                minimum = 0;
            }
            return Math.min(maximum, Math.max(minimum, desiredLocation));
        }

        @RunsInCurrentThread
        private int calculateMinimum(@Nonnull JSplitPane splitPane) {
            Component left = splitPane.getLeftComponent();
            if (left == null || !left.isVisible()) {
                return 0;
            }
            int minimum = left.getMinimumSize().height;
            Insets insets = splitPane.getInsets();
            if (insets != null) {
                minimum += insets.top;
            }
            return minimum;
        }

        @RunsInCurrentThread
        private int calculateMaximum(@Nonnull JSplitPane splitPane) {
            Component rightComponent = splitPane.getRightComponent();
            if (splitPane.getLeftComponent() == null || rightComponent == null) {
                return -1;
            }
            Insets insets = splitPane.getInsets();
            int dividerSize = splitPane.getDividerSize();
            int bottom = insets != null ? insets.bottom : 0;
            int splitPaneHeight = splitPane.getSize().height;
            if (!rightComponent.isVisible()) {
                return Math.max(0, splitPaneHeight - (dividerSize + bottom));
            }
            return Math.max(0, splitPaneHeight - (dividerSize + bottom) - rightComponent.getMinimumSize().height);
        }

        @Override
        int orientation() {
            return 0;
        }
    }

    private static abstract class LocationFinder {
        private LocationFinder() {
        }

        abstract int locationToMoveDividerTo(@Nonnull JSplitPane var1, int var2);

        abstract int orientation();
    }
}

