/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.lang.LangManager;
import training.lang.LangSupportBean;
import training.ui.LearnToolWindow;
import training.util.UtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Ltraining/ui/LearnToolWindowFactory;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "anchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "getAnchor", "()Lcom/intellij/openapi/wm/ToolWindowAnchor;", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "init", "Companion", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nLearnToolWindowFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LearnToolWindowFactory.kt\ntraining/ui/LearnToolWindowFactory\n+ 2 startUpMeasurer.kt\ncom/intellij/diagnostic/StartUpMeasurerKt\n*L\n1#1,42:1\n7#2,4:43\n*S KotlinDebug\n*F\n+ 1 LearnToolWindowFactory.kt\ntraining/ui/LearnToolWindowFactory\n*L\n24#1:43,4\n*E\n"})
public final class LearnToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String LEARN_TOOL_WINDOW = "Learn";

    public void init(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Project project = toolWindow.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        toolWindow.setShowStripeButton(UtilsKt.findLanguageSupport(project) != null);
    }

    @Nullable
    public ToolWindowAnchor getAnchor() {
        String name$iv = "learn tool window anchor setting";
        boolean $i$f$runActivity = false;
        Activity activity$iv = StartUpMeasurer.isEnabled() ? StartUpMeasurer.startActivity((String)name$iv) : null;
        boolean bl = false;
        LangSupportBean langSupportBean = LangManager.Companion.getInstance().getLangSupportBean();
        return langSupportBean != null ? langSupportBean.getLearnToolWindowAnchor() : null;
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        String string = ApplicationInfo.getInstance().getBuild().asStringWithoutProductCodeAndSnapshot();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asStringWithoutProductCodeAndSnapshot(...)");
        String currentBuildStr = string;
        PropertiesComponent.getInstance().setValue("ift.learning.panel.opened.in", currentBuildStr);
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        Content content = contentManager2.getFactory().createContent((JComponent)((Object)new LearnToolWindow(project, toolWindow)), null, false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        content2.setCloseable(false);
        contentManager2.addContent(content2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ltraining/ui/LearnToolWindowFactory$Companion;", "", "()V", "LEARN_TOOL_WINDOW", "", "intellij.featuresTrainer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

