/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.XmlDomBundle;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenConsumerPomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J\b\u0010\u0012\u001a\u00020\rH\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/maven/dom/inspections/MavenParentMissedVersionInspection;", "Lcom/intellij/util/xml/highlighting/DomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "()V", "checkFileElement", "", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "getDefaultLevel", "Lcom/intellij/codeHighlighting/HighlightDisplayLevel;", "getGroupDisplayName", "", "getParentVersion", "currentFile", "Lcom/intellij/psi/xml/XmlFile;", "model", "getShortName", "AddVersionQuickFix", "intellij.maven"})
public final class MavenParentMissedVersionInspection
extends DomElementsInspection<MavenDomProjectModel> {
    public MavenParentMissedVersionInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    public void checkFileElement(@NotNull DomFileElement<MavenDomProjectModel> domFileElement, @NotNull DomElementAnnotationHolder holder) {
        Intrinsics.checkNotNullParameter(domFileElement, (String)"domFileElement");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        DomElement domElement = domFileElement.getRootElement();
        Intrinsics.checkNotNullExpressionValue((Object)domElement, (String)"getRootElement(...)");
        MavenDomProjectModel model = (MavenDomProjectModel)domElement;
        MavenDomParent mavenDomParent = model.getMavenParent();
        Intrinsics.checkNotNullExpressionValue((Object)mavenDomParent, (String)"getMavenParent(...)");
        MavenDomParent parent = mavenDomParent;
        if (!parent.exists()) {
            return;
        }
        if (!parent.getVersion().exists()) {
            VirtualFile virtualFile = domFileElement.getFile().getVirtualFile();
            Project project2 = domFileElement.getFile().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            if (!MavenConsumerPomUtil.isAutomaticVersionFeatureEnabled(virtualFile, project2)) {
                XmlFile xmlFile = domFileElement.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"getFile(...)");
                String version2 = this.getParentVersion(xmlFile, model);
                Object[] objectArray = new Object[]{"version"};
                String string = XmlDomBundle.message((String)"dom.inspections.child.tag.0.should.be.defined", (Object[])objectArray);
                objectArray = new LocalQuickFix[]{new AddVersionQuickFix(version2)};
                CollectionsKt.listOf((Object)holder.createProblem((DomElement)parent, HighlightSeverity.ERROR, string, (LocalQuickFix[])objectArray));
            }
        }
    }

    private final String getParentVersion(XmlFile currentFile, MavenDomProjectModel model) {
        PsiDirectory psiDirectory = currentFile.getParent();
        PsiFile psiFile = psiDirectory != null && (psiDirectory = psiDirectory.getParent()) != null ? psiDirectory.findFile("pom.xml") : null;
        XmlFile xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        if (xmlFile == null) {
            return "";
        }
        XmlFile xmlFileParent = xmlFile;
        MavenDomProjectModel mavenDomProjectModel = MavenDomUtil.getMavenDomModel((PsiFile)xmlFileParent, MavenDomProjectModel.class);
        if (mavenDomProjectModel == null) {
            return "";
        }
        MavenDomProjectModel parentModel = mavenDomProjectModel;
        MavenDomParent mavenDomParent = model.getMavenParent();
        Intrinsics.checkNotNullExpressionValue((Object)mavenDomParent, (String)"getMavenParent(...)");
        MavenDomParent parentElement = mavenDomParent;
        if (Intrinsics.areEqual((Object)parentModel.getArtifactId().getValue(), (Object)parentElement.getArtifactId().getValue()) && Intrinsics.areEqual((Object)parentModel.getGroupId().getValue(), (Object)parentElement.getGroupId().getValue())) {
            String string = (String)parentModel.getVersion().getValue();
            if (string == null) {
                string = "";
            }
            return string;
        }
        return "";
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = MavenDomBundle.message("inspection.group", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getShortName() {
        return "MavenParentMissedVersionInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.ERROR;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/maven/dom/inspections/MavenParentMissedVersionInspection$AddVersionQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "myVersion", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "intellij.maven"})
    private static final class AddVersionQuickFix
    implements LocalQuickFix {
        @NotNull
        private final String myVersion;

        public AddVersionQuickFix(@NotNull String myVersion) {
            Intrinsics.checkNotNullParameter((Object)myVersion, (String)"myVersion");
            this.myVersion = myVersion;
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{"version"};
            String string = XmlDomBundle.message((String)"dom.quickfix.insert.required.tag.text", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = XmlDomBundle.message((String)"dom.quickfix.insert.required.tag.family", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            block0: {
                XmlTag tag;
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                XmlTag xmlTag = tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getPsiElement(), XmlTag.class, (boolean)false);
                if (xmlTag == null) break block0;
                xmlTag.add((PsiElement)tag.createChildTag("version", tag.getNamespace(), this.myVersion, false));
            }
        }
    }
}

