/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.importing.MavenImportUtil;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenModuleType;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.importing.MavenWorkspaceConfigurator;
import org.jetbrains.idea.maven.importing.StandardMavenModuleType;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenResolveResultProblemProcessor;
import org.jetbrains.idea.maven.server.MavenArtifactResolveResult;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.java.impl.compiler.ProcessorConfigProfileImpl;
import org.jetbrains.jps.util.JpsPathUtil;

@ApiStatus.Internal
public class MavenAnnotationProcessorConfigurator
extends MavenImporter
implements MavenWorkspaceConfigurator {
    private static final String PROFILE_PREFIX = "Annotation profile for ";
    public static final String MAVEN_DEFAULT_ANNOTATION_PROFILE = "Maven default annotation processors profile";
    private static final String DEFAULT_ANNOTATION_PATH_OUTPUT = "target/generated-sources/annotations";
    private static final String DEFAULT_TEST_ANNOTATION_OUTPUT = "target/generated-test-sources/test-annotations";
    public static final String MAVEN_BSC_DEFAULT_ANNOTATION_PROFILE = MavenAnnotationProcessorConfigurator.getModuleProfileName("maven-processor-plugin default configuration");
    private static final String DEFAULT_BSC_ANNOTATION_PATH_OUTPUT = "target/generated-sources/apt";
    private static final String DEFAULT_BSC_TEST_ANNOTATION_OUTPUT = "target/generated-sources/apt-test";
    private static final Key<Map<MavenProject, List<String>>> ANNOTATION_PROCESSOR_MODULE_NAMES = Key.create((String)"ANNOTATION_PROCESSOR_MODULE_NAMES");

    public MavenAnnotationProcessorConfigurator() {
        super("org.apache.maven.plugins", "maven-compiler-plugin");
    }

    @Override
    public boolean isApplicable(MavenProject mavenProject2) {
        return true;
    }

    @Override
    public boolean isMigratedToConfigurator() {
        return true;
    }

    @Override
    public void beforeModelApplied(@NotNull MavenWorkspaceConfigurator.MutableModelContext context2) {
        if (context2 == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(0);
        }
        HashMap<MavenId, List> mavenProjectToModuleNamesCache = new HashMap<MavenId, List>();
        for (MavenWorkspaceConfigurator.MavenProjectWithModules each : SequencesKt.asIterable(context2.getMavenProjectsWithModules())) {
            List moduleNames = ContainerUtil.mapNotNull(each.getModules(), it -> it.getType().getContainsCode() ? ((ModuleEntity)it.getModule()).getName() : null);
            mavenProjectToModuleNamesCache.put(each.getMavenProject().getMavenId(), moduleNames);
        }
        Sequence changedOnlyProjects = SequencesKt.mapNotNull(context2.getMavenProjectsWithModules(), it -> it.getChanges().hasChanges() ? it.getMavenProject() : null);
        HashMap<MavenProject, List<String>> map = new HashMap<MavenProject, List<String>>();
        this.collectProcessorModuleNames(SequencesKt.asIterable((Sequence)changedOnlyProjects), moduleName -> (List)mavenProjectToModuleNamesCache.get(moduleName), map);
        ANNOTATION_PROCESSOR_MODULE_NAMES.set((UserDataHolder)context2, map);
    }

    @Override
    public void process(@NotNull IdeModifiableModelsProvider modifiableModelsProvider, @NotNull Module module2, @NotNull MavenRootModelAdapter rootModel, @NotNull MavenProjectsTree mavenModel, @NotNull MavenProject mavenProject2, @NotNull MavenProjectChanges changes, @NotNull Map<MavenProject, String> mavenProjectToModuleName, @NotNull List<MavenProjectsProcessorTask> postTasks) {
        Element config;
        if (modifiableModelsProvider == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(1);
        }
        if (module2 == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(2);
        }
        if (rootModel == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(3);
        }
        if (mavenModel == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(4);
        }
        if (mavenProject2 == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(5);
        }
        if (changes == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(6);
        }
        if (mavenProjectToModuleName == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(7);
        }
        if (postTasks == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(8);
        }
        if ((config = this.getConfig(mavenProject2, "annotationProcessorPaths")) == null) {
            return;
        }
        String annotationTargetDir = mavenProject2.getAnnotationProcessorDirectory(false);
        new File(rootModel.toPath(annotationTargetDir).getPath()).mkdirs();
        rootModel.addGeneratedJavaSourceFolder(annotationTargetDir, JavaSourceRootType.SOURCE, false);
        Map map = (Map)ANNOTATION_PROCESSOR_MODULE_NAMES.get((UserDataHolder)modifiableModelsProvider, new HashMap());
        this.collectProcessorModuleNames(List.of(mavenProject2), mavenId2 -> {
            MavenProject mavenArtifact = mavenModel.findProject((MavenId)mavenId2);
            if (mavenArtifact == null) {
                return null;
            }
            String moduleName = (String)mavenProjectToModuleName.get(mavenArtifact);
            if (moduleName == null) {
                return null;
            }
            return List.of(moduleName);
        }, map);
        ANNOTATION_PROCESSOR_MODULE_NAMES.set((UserDataHolder)modifiableModelsProvider, (Object)map);
    }

    private void collectProcessorModuleNames(Iterable<MavenProject> projects, Function<@NotNull MavenId, @Nullable List<String>> moduleNameByProjectId, Map<MavenProject, List<String>> result2) {
        for (MavenProject mavenProject2 : projects) {
            Element config;
            if (!MavenAnnotationProcessorConfigurator.shouldEnableAnnotationProcessors(mavenProject2) || (config = this.getConfig(mavenProject2, "annotationProcessorPaths")) == null) continue;
            for (MavenArtifactInfo info : MavenAnnotationProcessorConfigurator.getProcessorArtifactInfos(config)) {
                MavenId mavenId2 = new MavenId(info.getGroupId(), info.getArtifactId(), info.getVersion());
                List<String> processorModuleNames = moduleNameByProjectId.apply(mavenId2);
                if (processorModuleNames == null) continue;
                result2.computeIfAbsent(mavenProject2, __ -> new ArrayList()).addAll(processorModuleNames);
            }
        }
    }

    @Override
    public void afterModelApplied(@NotNull MavenWorkspaceConfigurator.AppliedModelContext context2) {
        if (context2 == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(9);
        }
        HashMap<String, Module> nameToModuleCache = new HashMap<String, Module>();
        for (MavenWorkspaceConfigurator.MavenProjectWithModules each : SequencesKt.asIterable(context2.getMavenProjectsWithModules())) {
            for (MavenWorkspaceConfigurator.ModuleWithType moduleWithType : each.getModules()) {
                Module module2 = (Module)moduleWithType.getModule();
                nameToModuleCache.put(module2.getName(), module2);
            }
        }
        Function<@NotNull String, @Nullable Module> moduleByName = moduleName -> (Module)nameToModuleCache.get(moduleName);
        Map perProjectProcessorModuleNames = (Map)ANNOTATION_PROCESSOR_MODULE_NAMES.get((UserDataHolder)context2, Map.of());
        Sequence changedOnly = SequencesKt.filter(context2.getMavenProjectsWithModules(), it -> it.getChanges().hasChanges());
        Sequence projectWithModules = SequencesKt.map((Sequence)changedOnly, it -> {
            List<String> processorModuleNames = perProjectProcessorModuleNames.getOrDefault(it.getMavenProject(), List.of());
            return new MavenProjectWithProcessorModules(it.getMavenProject(), it.getModules(), processorModuleNames);
        });
        MavenAnnotationProcessorConfigurator.configureProfiles(context2.getProject(), context2.getMavenProjectsTree(), SequencesKt.asIterable((Sequence)projectWithModules), moduleByName);
    }

    @Override
    public void postProcess(final Module module2, MavenProject mavenProject2, MavenProjectChanges changes, IdeModifiableModelsProvider modifiableModelsProvider) {
        List<String> processorModuleNames = ((Map)ANNOTATION_PROCESSOR_MODULE_NAMES.get((UserDataHolder)modifiableModelsProvider, Map.of())).getOrDefault(mavenProject2, List.of());
        MavenWorkspaceConfigurator.ModuleWithType<Module> moduleWithType = new MavenWorkspaceConfigurator.ModuleWithType<Module>(){

            @Override
            public Module getModule() {
                return module2;
            }

            @Override
            @NotNull
            public MavenModuleType getType() {
                StandardMavenModuleType standardMavenModuleType = StandardMavenModuleType.SINGLE_MODULE;
                if (standardMavenModuleType == null) {
                    1.$$$reportNull$$$0(0);
                }
                return standardMavenModuleType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/importing/MavenAnnotationProcessorConfigurator$1", "getType"));
            }
        };
        MavenProjectWithProcessorModules projectWithModules = new MavenProjectWithProcessorModules(mavenProject2, List.of(moduleWithType), processorModuleNames);
        MavenAnnotationProcessorConfigurator.configureProfiles(module2.getProject(), MavenProjectsManager.getInstance(module2.getProject()).getProjectsTree(), List.of(projectWithModules), moduleName -> modifiableModelsProvider.findIdeModule(moduleName));
    }

    private static void configureProfiles(Project project2, MavenProjectsTree tree, Iterable<MavenProjectWithProcessorModules> projectsWithModules, Function<@NotNull String, @Nullable Module> moduleByName) {
        CompilerConfigurationImpl compilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project2);
        for (MavenProjectWithProcessorModules it : projectsWithModules) {
            MavenProject rootProject = (MavenProject)ObjectUtils.notNull((Object)tree.findRootProject(it.mavenProject), (Object)it.mavenProject);
            for (MavenWorkspaceConfigurator.ModuleWithType<Module> moduleWithType : it.mavenProjectModules) {
                Module module2 = moduleWithType.getModule();
                MavenModuleType moduleType = moduleWithType.getType();
                if (!MavenAnnotationProcessorConfigurator.isLevelMoreThan6(module2)) continue;
                if (MavenAnnotationProcessorConfigurator.shouldEnableAnnotationProcessors(it.mavenProject) && moduleType.getContainsCode()) {
                    List processorModules = ContainerUtil.mapNotNull(it.processorModuleNames, eachName -> (Module)moduleByName.apply((String)eachName));
                    Pair<ProcessorConfigProfile, Boolean> profileIsDefault = MavenAnnotationProcessorConfigurator.createOrUpdateProfile(it.mavenProject, module2, processorModules, compilerConfiguration);
                    if (profileIsDefault == null) continue;
                    MavenAnnotationProcessorConfigurator.cleanAndMergeModuleProfiles(rootProject, compilerConfiguration, (ProcessorConfigProfile)profileIsDefault.first, (Boolean)profileIsDefault.second, module2);
                    continue;
                }
                MavenAnnotationProcessorConfigurator.cleanAndMergeModuleProfiles(rootProject, compilerConfiguration, null, false, module2);
            }
        }
    }

    private static @Nullable Pair<@NotNull ProcessorConfigProfile, @NotNull Boolean> createOrUpdateProfile(@NotNull MavenProject mavenProject2, @NotNull Module module2, @NotNull List<Module> processorModules, @NotNull CompilerConfigurationImpl compilerConfiguration) {
        boolean isDefault;
        String moduleProfileName;
        boolean isDefaultSettings;
        String testAnnotationProcessorDirectory;
        String annotationProcessorDirectory;
        boolean outputRelativeToContentRoot;
        if (mavenProject2 == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(10);
        }
        if (module2 == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(11);
        }
        if (processorModules == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(12);
        }
        if (compilerConfiguration == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(13);
        }
        List<String> processors = mavenProject2.getDeclaredAnnotationProcessors();
        Map<String, String> options = mavenProject2.getAnnotationProcessorOptions();
        if (MavenImportUtil.isMainOrTestSubmodule(module2.getName())) {
            outputRelativeToContentRoot = false;
            annotationProcessorDirectory = MavenAnnotationProcessorConfigurator.getAnnotationsDirectoryRelativeTo(mavenProject2, false, mavenProject2.getOutputDirectory());
            testAnnotationProcessorDirectory = MavenAnnotationProcessorConfigurator.getAnnotationsDirectoryRelativeTo(mavenProject2, true, mavenProject2.getTestOutputDirectory());
        } else {
            String mavenProjectDirectory = mavenProject2.getDirectory();
            outputRelativeToContentRoot = true;
            annotationProcessorDirectory = MavenAnnotationProcessorConfigurator.getAnnotationsDirectoryRelativeTo(mavenProject2, false, mavenProjectDirectory);
            testAnnotationProcessorDirectory = MavenAnnotationProcessorConfigurator.getAnnotationsDirectoryRelativeTo(mavenProject2, true, mavenProjectDirectory);
        }
        String annotationProcessorPath = MavenAnnotationProcessorConfigurator.getAnnotationProcessorPath(mavenProject2, processorModules);
        boolean bl = isDefaultSettings = ContainerUtil.isEmpty(processors) && options.isEmpty() && StringUtil.isEmpty((String)annotationProcessorPath);
        if (isDefaultSettings && DEFAULT_ANNOTATION_PATH_OUTPUT.equals(FileUtil.toSystemIndependentName((String)annotationProcessorDirectory)) && DEFAULT_TEST_ANNOTATION_OUTPUT.equals(FileUtil.toSystemIndependentName((String)testAnnotationProcessorDirectory))) {
            moduleProfileName = MAVEN_DEFAULT_ANNOTATION_PROFILE;
            isDefault = true;
        } else if (isDefaultSettings && DEFAULT_BSC_ANNOTATION_PATH_OUTPUT.equals(FileUtil.toSystemIndependentName((String)annotationProcessorDirectory)) && DEFAULT_BSC_TEST_ANNOTATION_OUTPUT.equals(FileUtil.toSystemIndependentName((String)testAnnotationProcessorDirectory))) {
            moduleProfileName = MAVEN_BSC_DEFAULT_ANNOTATION_PROFILE;
            isDefault = true;
        } else {
            moduleProfileName = MavenAnnotationProcessorConfigurator.getModuleProfileName(module2.getName());
            isDefault = false;
        }
        ProcessorConfigProfile moduleProfile = MavenAnnotationProcessorConfigurator.getModuleProfile(module2, mavenProject2, compilerConfiguration, moduleProfileName, outputRelativeToContentRoot, annotationProcessorDirectory, testAnnotationProcessorDirectory);
        if (moduleProfile == null) {
            return null;
        }
        if (StringUtil.isNotEmpty((String)annotationProcessorPath)) {
            moduleProfile.setObtainProcessorsFromClasspath(false);
            moduleProfile.setProcessorPath(annotationProcessorPath);
        }
        return Pair.pair((Object)moduleProfile, (Object)isDefault);
    }

    @NotNull
    public static String getModuleProfileName(@NotNull @NlsSafe String moduleName) {
        if (moduleName == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(14);
        }
        String string = PROFILE_PREFIX + moduleName;
        if (string == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    public void resolve(Project project2, MavenProject mavenProject2, NativeMavenProjectHolder nativeMavenProject, MavenEmbedderWrapper embedder) throws MavenProcessCanceledException {
        Element config = this.getConfig(mavenProject2, "annotationProcessorPaths");
        if (config == null) {
            return;
        }
        List<MavenArtifactInfo> artifactsInfo = MavenAnnotationProcessorConfigurator.getProcessorArtifactInfos(config);
        if (artifactsInfo.isEmpty()) {
            return;
        }
        ArrayList<MavenArtifactInfo> externalArtifacts = new ArrayList<MavenArtifactInfo>();
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project2);
        MavenProjectsTree tree = mavenProjectsManager.getProjectsTree();
        for (MavenArtifactInfo info : artifactsInfo) {
            MavenProject mavenArtifact = tree.findProject(new MavenId(info.getGroupId(), info.getArtifactId(), info.getVersion()));
            if (mavenArtifact != null) continue;
            externalArtifacts.add(info);
        }
        try {
            MavenArtifactResolveResult annotationProcessors = embedder.resolveArtifactTransitively(new ArrayList(externalArtifacts), new ArrayList<MavenRemoteRepository>(mavenProject2.getRemoteRepositories()));
            if (annotationProcessors.problem != null) {
                MavenResolveResultProblemProcessor.notifySyncForProblem(project2, annotationProcessors.problem);
            } else {
                mavenProject2.addAnnotationProcessors(annotationProcessors.mavenResolvedArtifacts);
            }
        }
        catch (Exception e) {
            String message = e.getMessage() != null ? e.getMessage() : ExceptionUtil.getThrowableText((Throwable)e);
            MavenProjectsManager.getInstance(project2).getSyncConsole().addWarning(SyncBundle.message("maven.sync.annotation.processor.problem", new Object[0]), message);
        }
    }

    @NotNull
    private static List<MavenArtifactInfo> getProcessorArtifactInfos(Element config) {
        ArrayList<MavenArtifactInfo> artifacts = new ArrayList<MavenArtifactInfo>();
        Consumer addToArtifacts = path2 -> {
            String groupId = path2.getChildTextTrim("groupId");
            String artifactId = path2.getChildTextTrim("artifactId");
            String version2 = path2.getChildTextTrim("version");
            String classifier = path2.getChildTextTrim("classifier");
            artifacts.add(new MavenArtifactInfo(groupId, artifactId, version2, "jar", classifier));
        };
        for (Element path3 : config.getChildren("path")) {
            addToArtifacts.consume((Object)path3);
        }
        for (Element dependency : config.getChildren("dependency")) {
            addToArtifacts.consume((Object)dependency);
        }
        for (Element annotationProcessorPath : config.getChildren("annotationProcessorPath")) {
            addToArtifacts.consume((Object)annotationProcessorPath);
        }
        ArrayList<MavenArtifactInfo> arrayList = artifacts;
        if (arrayList == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @Nullable
    private static ProcessorConfigProfile getModuleProfile(Module module2, MavenProject mavenProject2, CompilerConfigurationImpl compilerConfiguration, String moduleProfileName, boolean outputRelativeToContentRoot, String annotationProcessorDirectory, String testAnnotationProcessorDirectory) {
        ProcessorConfigProfile moduleProfile = compilerConfiguration.findModuleProcessorProfile(moduleProfileName);
        if (moduleProfile == null) {
            moduleProfile = new ProcessorConfigProfileImpl(moduleProfileName);
            moduleProfile.setEnabled(true);
            compilerConfiguration.addModuleProcessorProfile(moduleProfile);
        }
        if (!moduleProfile.isEnabled()) {
            return null;
        }
        moduleProfile.setObtainProcessorsFromClasspath(true);
        moduleProfile.setOutputRelativeToContentRoot(outputRelativeToContentRoot);
        moduleProfile.setGeneratedSourcesDirectoryName(annotationProcessorDirectory, false);
        moduleProfile.setGeneratedSourcesDirectoryName(testAnnotationProcessorDirectory, true);
        moduleProfile.clearProcessorOptions();
        for (Map.Entry<String, String> entry : mavenProject2.getAnnotationProcessorOptions().entrySet()) {
            moduleProfile.setOption(entry.getKey(), entry.getValue());
        }
        moduleProfile.clearProcessors();
        List<String> processors = mavenProject2.getDeclaredAnnotationProcessors();
        if (processors != null) {
            for (String processor : processors) {
                moduleProfile.addProcessor(processor);
            }
        }
        moduleProfile.addModuleName(module2.getName());
        return moduleProfile;
    }

    private static boolean isLevelMoreThan6(Module module2) {
        String versionString;
        LanguageLevel languageLevel;
        Sdk sdk = (Sdk)ReadAction.compute(() -> ModuleRootManager.getInstance((Module)module2).getSdk());
        return sdk == null || (languageLevel = LanguageLevel.parse((String)(versionString = sdk.getVersionString()))) == null || !languageLevel.isLessThan(LanguageLevel.JDK_1_6);
    }

    @NotNull
    private static String getAnnotationProcessorPath(@NotNull MavenProject mavenProject2, @NotNull List<Module> processorModules) {
        if (mavenProject2 == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(17);
        }
        if (processorModules == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(18);
        }
        StringJoiner annotationProcessorPath = new StringJoiner(File.pathSeparator);
        Consumer resultAppender = path2 -> annotationProcessorPath.add(FileUtil.toSystemDependentName((String)path2));
        for (MavenArtifact artifact : mavenProject2.getExternalAnnotationProcessors()) {
            resultAppender.consume((Object)artifact.getPath());
        }
        for (Module module2 : processorModules) {
            OrderEnumerator enumerator = OrderEnumerator.orderEntries((Module)module2).withoutSdk().productionOnly().runtimeOnly().recursively();
            for (String url : enumerator.classes().getUrls()) {
                resultAppender.consume((Object)JpsPathUtil.urlToPath((String)url));
            }
        }
        String string = annotationProcessorPath.toString();
        if (string == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static void cleanAndMergeModuleProfiles(@NotNull MavenProject rootProject, @NotNull CompilerConfigurationImpl compilerConfiguration, @Nullable ProcessorConfigProfile moduleProfile, boolean isDefault, @NotNull Module module2) {
        if (rootProject == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(20);
        }
        if (compilerConfiguration == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(21);
        }
        if (module2 == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(22);
        }
        ArrayList profiles2 = new ArrayList(compilerConfiguration.getModuleProcessorProfiles());
        for (ProcessorConfigProfile p : profiles2) {
            if (p != moduleProfile) {
                p.removeModuleName(module2.getName());
                if (p.getModuleNames().isEmpty() && p.getName().startsWith(PROFILE_PREFIX)) {
                    compilerConfiguration.removeModuleProcessorProfile(p);
                }
            }
            if (isDefault || moduleProfile == null || !MavenAnnotationProcessorConfigurator.isSimilarProfiles(p, moduleProfile)) continue;
            moduleProfile.setEnabled(p.isEnabled());
            String mavenProjectRootProfileName = MavenAnnotationProcessorConfigurator.getModuleProfileName(rootProject.getDisplayName());
            ProcessorConfigProfile mergedProfile = compilerConfiguration.findModuleProcessorProfile(mavenProjectRootProfileName);
            if (mergedProfile == null) {
                mergedProfile = new ProcessorConfigProfileImpl(moduleProfile);
                mergedProfile.setName(mavenProjectRootProfileName);
                compilerConfiguration.addModuleProcessorProfile(mergedProfile);
                mergedProfile.addModuleNames((Collection)p.getModuleNames());
                p.clearModuleNames();
                compilerConfiguration.removeModuleProcessorProfile(p);
                moduleProfile.clearModuleNames();
                compilerConfiguration.removeModuleProcessorProfile(moduleProfile);
                continue;
            }
            if (p != mergedProfile && !MavenAnnotationProcessorConfigurator.isSimilarProfiles(mergedProfile, moduleProfile)) continue;
            if (moduleProfile != mergedProfile) {
                mergedProfile.addModuleNames((Collection)moduleProfile.getModuleNames());
                moduleProfile.clearModuleNames();
                compilerConfiguration.removeModuleProcessorProfile(moduleProfile);
            }
            if (p == mergedProfile) continue;
            mergedProfile.addModuleNames((Collection)p.getModuleNames());
            p.clearModuleNames();
            compilerConfiguration.removeModuleProcessorProfile(p);
        }
    }

    private static boolean isSimilarProfiles(@Nullable ProcessorConfigProfile profile1, @Nullable ProcessorConfigProfile profile2) {
        if (profile1 == null || profile2 == null) {
            return false;
        }
        ProcessorConfigProfileImpl p1 = new ProcessorConfigProfileImpl(profile1);
        p1.setName("tmp");
        p1.setEnabled(true);
        p1.clearModuleNames();
        ProcessorConfigProfileImpl p2 = new ProcessorConfigProfileImpl(profile2);
        p2.setName("tmp");
        p2.setEnabled(true);
        p2.clearModuleNames();
        return p1.equals((Object)p2);
    }

    @NotNull
    private static String getAnnotationsDirectoryRelativeTo(MavenProject mavenProject2, boolean isTest, String relativeTo) {
        String string;
        String annotationProcessorDirectory = mavenProject2.getAnnotationProcessorDirectory(isTest);
        Path path2 = Path.of(annotationProcessorDirectory, new String[0]);
        if (!path2.isAbsolute()) {
            String string2 = annotationProcessorDirectory;
            if (string2 == null) {
                MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(23);
            }
            return string2;
        }
        try {
            string = Path.of(relativeTo, new String[0]).relativize(path2).toString();
        }
        catch (IllegalArgumentException e) {
            return isTest ? DEFAULT_TEST_ANNOTATION_OUTPUT : DEFAULT_ANNOTATION_PATH_OUTPUT;
        }
        if (string == null) {
            MavenAnnotationProcessorConfigurator.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static boolean shouldEnableAnnotationProcessors(MavenProject mavenProject2) {
        if ("pom".equals(mavenProject2.getPackaging())) {
            return false;
        }
        return mavenProject2.getProcMode() != MavenProject.ProcMode.NONE || mavenProject2.findPlugin("org.bsc.maven", "maven-processor-plugin") != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 16, 19, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableModelsProvider";
                break;
            }
            case 2: 
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenModel";
                break;
            }
            case 5: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProjectToModuleName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postTasks";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processorModules";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerConfiguration";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 15: 
            case 16: 
            case 19: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/MavenAnnotationProcessorConfigurator";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/MavenAnnotationProcessorConfigurator";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleProfileName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessorArtifactInfos";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationProcessorPath";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationsDirectoryRelativeTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeModelApplied";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "afterModelApplied";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createOrUpdateProfile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getModuleProfileName";
                break;
            }
            case 15: 
            case 16: 
            case 19: 
            case 23: 
            case 24: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationProcessorPath";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "cleanAndMergeModuleProfiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 16, 19, 23, 24 -> new IllegalStateException(string);
        };
    }

    private static class MavenProjectWithProcessorModules {
        private final MavenProject mavenProject;
        private final List<MavenWorkspaceConfigurator.ModuleWithType<Module>> mavenProjectModules;
        private final List<String> processorModuleNames;

        private MavenProjectWithProcessorModules(MavenProject mavenProject2, List<MavenWorkspaceConfigurator.ModuleWithType<Module>> mavenProjectModules, List<String> processorModuleNames) {
            this.mavenProject = mavenProject2;
            this.mavenProjectModules = mavenProjectModules;
            this.processorModuleNames = processorModuleNames;
        }
    }
}

