/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenImportStats;
import org.jetbrains.idea.maven.importing.MavenLegacyFoldersImporter;
import org.jetbrains.idea.maven.importing.MavenProjectLegacyImporter;
import org.jetbrains.idea.maven.importing.workspaceModel.WorkspaceProjectImporter;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.statistics.MavenImportCollector;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bg\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&J\u0010\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenProjectImporter;", "", "createdModules", "", "Lcom/intellij/openapi/module/Module;", "importProject", "Lorg/jetbrains/idea/maven/project/MavenProjectsProcessorTask;", "Companion", "intellij.maven"})
@ApiStatus.Internal
public interface MavenProjectImporter {
    @NotNull
    public static final Companion Companion = org.jetbrains.idea.maven.importing.MavenProjectImporter$Companion.$$INSTANCE;

    @Nullable
    public List<MavenProjectsProcessorTask> importProject();

    @NotNull
    public List<Module> createdModules();

    @JvmStatic
    @NotNull
    public static MavenProjectImporter createImporter(@NotNull Project project2, @NotNull MavenProjectsTree projectsTree, @NotNull Map<MavenProject, ? extends MavenProjectChanges> projectsToImportWithChanges, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull MavenImportingSettings importingSettings, @Nullable Module previewModule, @NotNull StructuredIdeActivity parentImportingActivity) {
        return Companion.createImporter(project2, projectsTree, projectsToImportWithChanges, modelsProvider, importingSettings, previewModule, parentImportingActivity);
    }

    @JvmStatic
    public static void tryUpdateTargetFolders(@NotNull Project project2) {
        Companion.tryUpdateTargetFolders(project2);
    }

    @JvmStatic
    public static boolean isImportingInProgress() {
        return Companion.isImportingInProgress();
    }

    @JvmStatic
    public static boolean isImportToWorkspaceModelEnabled(@Nullable Project project2) {
        return Companion.isImportToWorkspaceModelEnabled(project2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002JN\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\b\u0010\u0019\u001a\u00020\u0018H\u0007J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenProjectImporter$Companion;", "", "()V", "importingInProgress", "Ljava/util/concurrent/atomic/AtomicInteger;", "createImporter", "Lorg/jetbrains/idea/maven/importing/MavenProjectImporter;", "project", "Lcom/intellij/openapi/project/Project;", "projectsTree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "projectsToImportWithChanges", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "Lorg/jetbrains/idea/maven/project/MavenProjectChanges;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "importingSettings", "Lorg/jetbrains/idea/maven/project/MavenImportingSettings;", "previewModule", "Lcom/intellij/openapi/module/Module;", "parentImportingActivity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "isImportToWorkspaceModelEnabled", "", "isImportingInProgress", "tryUpdateTargetFolders", "", "PostImportingTaskMarker", "intellij.maven"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final AtomicInteger importingInProgress;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MavenProjectImporter createImporter(@NotNull Project project2, @NotNull MavenProjectsTree projectsTree, @NotNull Map<MavenProject, ? extends MavenProjectChanges> projectsToImportWithChanges, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull MavenImportingSettings importingSettings, @Nullable Module previewModule, @NotNull StructuredIdeActivity parentImportingActivity) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)projectsTree, (String)"projectsTree");
            Intrinsics.checkNotNullParameter(projectsToImportWithChanges, (String)"projectsToImportWithChanges");
            Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
            Intrinsics.checkNotNullParameter((Object)importingSettings, (String)"importingSettings");
            Intrinsics.checkNotNullParameter((Object)parentImportingActivity, (String)"parentImportingActivity");
            MavenProjectImporter importer = this.createImporter(project2, projectsTree, projectsToImportWithChanges, modelsProvider, importingSettings, previewModule);
            return new MavenProjectImporter(project2, parentImportingActivity, importer){
                final /* synthetic */ Project $project;
                final /* synthetic */ StructuredIdeActivity $parentImportingActivity;
                final /* synthetic */ MavenProjectImporter $importer;
                {
                    this.$project = $project;
                    this.$parentImportingActivity = $parentImportingActivity;
                    this.$importer = $importer;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @NotNull
                public List<MavenProjectsProcessorTask> importProject() {
                    StructuredIdeActivity activity = MavenImportStats.INSTANCE.startApplyingModelsActivity(this.$project, this.$parentImportingActivity);
                    long startTime = System.currentTimeMillis();
                    try {
                        org.jetbrains.idea.maven.importing.MavenProjectImporter$Companion.access$getImportingInProgress$p().incrementAndGet();
                        List<MavenProjectsProcessorTask> list = this.$importer.importProject();
                        Intrinsics.checkNotNull(list);
                        List<MavenProjectsProcessorTask> postImportTasks = list;
                        PostImportingTaskMarker statsMarker = new PostImportingTaskMarker(this.$parentImportingActivity);
                        List[] listArray = new List[]{CollectionsKt.listOf((Object)statsMarker.createStartedTask()), postImportTasks, CollectionsKt.listOf((Object)statsMarker.createFinishedTask())};
                        List list2 = ContainerUtil.concat((List[])listArray);
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"concat(...)");
                        List list3 = list2;
                        return list3;
                    }
                    finally {
                        org.jetbrains.idea.maven.importing.MavenProjectImporter$Companion.access$getImportingInProgress$p().decrementAndGet();
                        StructuredIdeActivity.finished$default((StructuredIdeActivity)activity, null, (int)1, null);
                        MavenLog.LOG.info("[maven import] applying models to workspace model took " + (System.currentTimeMillis() - startTime) + "ms");
                    }
                }

                @NotNull
                public List<Module> createdModules() {
                    return this.$importer.createdModules();
                }
            };
        }

        private final MavenProjectImporter createImporter(Project project2, MavenProjectsTree projectsTree, Map<MavenProject, ? extends MavenProjectChanges> projectsToImportWithChanges, IdeModifiableModelsProvider modelsProvider, MavenImportingSettings importingSettings, Module previewModule) {
            if (this.isImportToWorkspaceModelEnabled(project2)) {
                return new WorkspaceProjectImporter(projectsTree, projectsToImportWithChanges, importingSettings, modelsProvider, project2);
            }
            return new MavenProjectLegacyImporter(project2, projectsTree, projectsToImportWithChanges, modelsProvider, importingSettings, previewModule);
        }

        @JvmStatic
        public final void tryUpdateTargetFolders(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            if (this.isImportToWorkspaceModelEnabled(project2)) {
                WorkspaceProjectImporter.Companion.updateTargetFolders(project2);
            } else {
                MavenLegacyFoldersImporter.updateProjectFolders(project2, true);
            }
        }

        @JvmStatic
        public final boolean isImportingInProgress() {
            return importingInProgress.get() > 0;
        }

        @JvmStatic
        public final boolean isImportToWorkspaceModelEnabled(@Nullable Project project2) {
            String property = System.getProperty("maven.import.to.workspace.model");
            if (Intrinsics.areEqual((Object)"true", (Object)property)) {
                return true;
            }
            if (Intrinsics.areEqual((Object)"false", (Object)property)) {
                return false;
            }
            if (project2 == null) {
                return false;
            }
            return MavenProjectsManager.getInstance(project2).getImportingSettings().isWorkspaceImportEnabled();
        }

        public static final /* synthetic */ AtomicInteger access$getImportingInProgress$p() {
            return importingInProgress;
        }

        static {
            $$INSTANCE = new Companion();
            importingInProgress = new AtomicInteger();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenProjectImporter$Companion$PostImportingTaskMarker;", "", "importingActivity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "(Lcom/intellij/internal/statistic/StructuredIdeActivity;)V", "activityId", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "startedNano", "", "createFinishedTask", "Lorg/jetbrains/idea/maven/project/MavenProjectsProcessorTask;", "createStartedTask", "intellij.maven"})
        public static final class PostImportingTaskMarker {
            @NotNull
            private final StructuredIdeActivity importingActivity;
            @NotNull
            private final EventPair<StructuredIdeActivity> activityId;
            private long startedNano;

            public PostImportingTaskMarker(@NotNull StructuredIdeActivity importingActivity) {
                Intrinsics.checkNotNullParameter((Object)importingActivity, (String)"importingActivity");
                this.importingActivity = importingActivity;
                this.activityId = MavenImportCollector.ACTIVITY_ID.with((Object)this.importingActivity);
            }

            @NotNull
            public final MavenProjectsProcessorTask createStartedTask() {
                return (arg_0, arg_1, arg_2, arg_3) -> PostImportingTaskMarker.createStartedTask$lambda$0(this, arg_0, arg_1, arg_2, arg_3);
            }

            @NotNull
            public final MavenProjectsProcessorTask createFinishedTask() {
                return (arg_0, arg_1, arg_2, arg_3) -> PostImportingTaskMarker.createFinishedTask$lambda$1(this, arg_0, arg_1, arg_2, arg_3);
            }

            private static final void createStartedTask$lambda$0(PostImportingTaskMarker this$0, Project project2, MavenEmbeddersManager mavenEmbeddersManager, MavenConsole mavenConsole, MavenProgressIndicator mavenProgressIndicator) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                this$0.startedNano = System.nanoTime();
            }

            private static final void createFinishedTask$lambda$1(PostImportingTaskMarker this$0, Project project2, MavenEmbeddersManager mavenEmbeddersManager, MavenConsole mavenConsole, MavenProgressIndicator mavenProgressIndicator) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                if (this$0.startedNano == 0L) {
                    MavenLog.LOG.error("'Finished' post import task called before 'started' task");
                } else {
                    long totalNano = System.nanoTime() - this$0.startedNano;
                    MavenImportCollector.POST_IMPORT_TASKS_RUN.log(project2, this$0.activityId.getData(), (Object)TimeUnit.NANOSECONDS.toMillis(totalNano));
                }
            }
        }
    }
}

