/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.MavenIndices;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenIndexId;
import org.jetbrains.idea.maven.server.AddArtifactResponse;
import org.jetbrains.idea.maven.server.MavenIndicesProcessor;
import org.jetbrains.idea.maven.server.MavenRemoteObjectWrapper;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerIndexerException;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.RemoteObjectWrapper;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public abstract class MavenIndexerWrapper
extends MavenRemoteObjectWrapper<MavenServerIndexer> {
    public MavenIndexerWrapper(@Nullable RemoteObjectWrapper<?> parent) {
        super(parent);
    }

    public void releaseIndex(MavenIndexId mavenIndexId) throws MavenServerIndexerException {
        MavenLog.LOG.debug("releaseIndex " + mavenIndexId.indexId);
        MavenServerIndexer w = (MavenServerIndexer)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.releaseIndex(mavenIndexId, ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
    }

    public boolean indexExists(File dir2) {
        try {
            return ((MavenServerIndexer)this.getOrCreateWrappee()).indexExists(dir2, ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
            return false;
        }
    }

    public int getIndexCount() {
        return this.perform(() -> ((MavenServerIndexer)this.getOrCreateWrappee()).getIndexCount(ourToken));
    }

    public void updateIndex(@NotNull MavenIndexId mavenIndexId, @NotNull MavenProgressIndicator indicator, boolean multithreaded) throws MavenProcessCanceledException, MavenServerIndexerException {
        if (mavenIndexId == null) {
            MavenIndexerWrapper.$$$reportNull$$$0(0);
        }
        if (indicator == null) {
            MavenIndexerWrapper.$$$reportNull$$$0(1);
        }
        this.performCancelable(() -> {
            MavenServerProgressIndicator indicatorWrapper = MavenIndexerWrapper.wrapAndExport(indicator);
            try {
                ((MavenServerIndexer)this.getOrCreateWrappee()).updateIndex(mavenIndexId, indicatorWrapper, multithreaded, ourToken);
            }
            finally {
                UnicastRemoteObject.unexportObject((Remote)indicatorWrapper, true);
            }
            return null;
        });
    }

    public void processArtifacts(MavenIndexId mavenIndexId, MavenIndicesProcessor processor, MavenProgressIndicator progress) throws MavenServerIndexerException {
        this.perform(() -> {
            try {
                ArrayList list;
                int start = 0;
                do {
                    if (progress.isCanceled()) {
                        return null;
                    }
                    MavenLog.LOG.debug("process artifacts: " + start);
                    list = ((MavenServerIndexer)this.getOrCreateWrappee()).processArtifacts(mavenIndexId, start, ourToken);
                    if (list == null) continue;
                    processor.processArtifacts(list);
                    start += list.size();
                } while (list != null);
                return null;
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    @NotNull
    public List<AddArtifactResponse> addArtifacts(MavenIndexId mavenIndexId, Collection<File> artifactFiles) {
        List list = this.perform(() -> {
            try {
                return ((MavenServerIndexer)this.getOrCreateWrappee()).addArtifacts(mavenIndexId, new ArrayList(artifactFiles), ourToken);
            }
            catch (Throwable ignore) {
                return ContainerUtil.map((Collection)artifactFiles, file -> new AddArtifactResponse(file, null));
            }
        });
        if (list == null) {
            MavenIndexerWrapper.$$$reportNull$$$0(2);
        }
        return list;
    }

    public Set<MavenArtifactInfo> search(MavenIndexId mavenIndexId, String pattern, int maxResult) throws MavenServerIndexerException {
        return this.perform(() -> ((MavenServerIndexer)this.getOrCreateWrappee()).search(mavenIndexId, pattern, maxResult, ourToken));
    }

    @ApiStatus.Internal
    public MavenIndices getOrCreateIndices(Project project2) {
        return this.createMavenIndices(project2);
    }

    protected abstract MavenIndices createMavenIndices(Project var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenIndexId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenIndexerWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenIndexerWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "addArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateIndex";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

