/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.LocalMavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenRemoteProcessSupportFactory;
import org.jetbrains.idea.maven.server.WslMavenDistribution;
import org.jetbrains.idea.maven.server.wsl.WslMavenServerRemoteProcessSupport;
import org.jetbrains.idea.maven.statistics.MavenActionsUsagesCollector;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenWslUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J9\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/maven/server/wsl/WslMavenRemoteProcessSupportFactory;", "Lorg/jetbrains/idea/maven/server/MavenRemoteProcessSupportFactory;", "()V", "create", "Lorg/jetbrains/idea/maven/server/MavenRemoteProcessSupportFactory$MavenRemoteProcessSupport;", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "vmOptions", "", "mavenDistribution", "Lorg/jetbrains/idea/maven/server/MavenDistribution;", "project", "Lcom/intellij/openapi/project/Project;", "debugPort", "", "(Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Lorg/jetbrains/idea/maven/server/MavenDistribution;Lcom/intellij/openapi/project/Project;Ljava/lang/Integer;)Lorg/jetbrains/idea/maven/server/MavenRemoteProcessSupportFactory$MavenRemoteProcessSupport;", "isApplicable", "", "toWslMavenDistribution", "Lorg/jetbrains/idea/maven/server/WslMavenDistribution;", "wslDistribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nWslMavenRemoteProcessSupportFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WslMavenRemoteProcessSupportFactory.kt\norg/jetbrains/idea/maven/server/wsl/WslMavenRemoteProcessSupportFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class WslMavenRemoteProcessSupportFactory
implements MavenRemoteProcessSupportFactory {
    @Override
    @NotNull
    public MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport create(@NotNull Sdk jdk2, @Nullable String vmOptions, @NotNull MavenDistribution mavenDistribution, @NotNull Project project2, @Nullable Integer debugPort) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)jdk2, (String)"jdk");
                Intrinsics.checkNotNullParameter((Object)mavenDistribution, (String)"mavenDistribution");
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                string = project2.getBasePath();
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                WSLDistribution wSLDistribution = WslPath.Companion.getDistributionByWindowsUncPath(it);
                string = wSLDistribution;
                if (wSLDistribution != null) break block3;
            }
            throw new IllegalArgumentException("Project " + project2 + " is not WSL based!");
        }
        String wslDistribution = string;
        MavenLog.LOG.info("Use WSL maven distribution at " + mavenDistribution);
        MavenActionsUsagesCollector.Companion.trigger(project2, MavenActionsUsagesCollector.START_WSL_MAVEN_SERVER);
        WslMavenDistribution wslMavenDistribution = this.toWslMavenDistribution(mavenDistribution, (WSLDistribution)wslDistribution);
        return new WslMavenServerRemoteProcessSupport((WSLDistribution)wslDistribution, jdk2, vmOptions, wslMavenDistribution, project2, debugPort);
    }

    private final WslMavenDistribution toWslMavenDistribution(MavenDistribution mavenDistribution, WSLDistribution wslDistribution) {
        if (mavenDistribution instanceof WslMavenDistribution) {
            return (WslMavenDistribution)mavenDistribution;
        }
        if (mavenDistribution instanceof LocalMavenDistribution) {
            String string = wslDistribution.getWslPath(((Object)mavenDistribution.getMavenHome().toAbsolutePath()).toString());
            if (string == null) {
                throw new IllegalArgumentException("Cannot use mavenDistribution " + mavenDistribution);
            }
            String it = string;
            boolean bl = false;
            return new WslMavenDistribution(wslDistribution, it, it);
        }
        throw new IllegalArgumentException("Cannot use mavenDistribution " + mavenDistribution);
    }

    @Override
    public boolean isApplicable(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return MavenWslUtil.useWslMaven(project2);
    }
}

