/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.BackDependencyIndex;
import org.jetbrains.jps.dependency.Delta;
import org.jetbrains.jps.dependency.DependencyGraph;
import org.jetbrains.jps.dependency.DifferentiateContext;
import org.jetbrains.jps.dependency.DifferentiateResult;
import org.jetbrains.jps.dependency.DifferentiateStrategy;
import org.jetbrains.jps.dependency.Graph;
import org.jetbrains.jps.dependency.MapletFactory;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.dependency.Usage;
import org.jetbrains.jps.dependency.diff.DiffCapable;
import org.jetbrains.jps.dependency.impl.Containers;
import org.jetbrains.jps.dependency.impl.DeltaImpl;
import org.jetbrains.jps.dependency.impl.GraphImpl;
import org.jetbrains.jps.dependency.java.JavaDifferentiateStrategy;
import org.jetbrains.jps.dependency.java.SubclassesIndex;
import org.jetbrains.jps.javac.Iterators;

public final class DependencyGraphImpl
extends GraphImpl
implements DependencyGraph {
    private static final List<DifferentiateStrategy> ourDifferentiateStrategies = List.of(new JavaDifferentiateStrategy());

    public DependencyGraphImpl(MapletFactory containerFactory) {
        super(containerFactory);
        this.addIndex(new SubclassesIndex(containerFactory));
    }

    @Override
    public Delta createDelta(Iterable<NodeSource> compiledSources, Iterable<NodeSource> deletedSources) {
        return new DeltaImpl(this.completeSourceSet(compiledSources, deletedSources), deletedSources);
    }

    @Override
    public DifferentiateResult differentiate(final Delta delta, boolean calculateAffected) {
        final Iterable<NodeSource> deltaSources = delta.getSources();
        Set allProcessedSources = (Set)Iterators.collect((Iterable)Iterators.flat(Arrays.asList(delta.getBaseSources(), deltaSources, delta.getDeletedSources())), new HashSet());
        Set nodesBefore = (Set)Iterators.collect((Iterable)Iterators.flat((Iterable)Iterators.map((Iterable)allProcessedSources, s -> this.getNodes((NodeSource)s))), Containers.createCustomPolicySet(DiffCapable::isSame, DiffCapable::diffHashCode));
        Set nodesAfter = (Set)Iterators.collect((Iterable)Iterators.flat((Iterable)Iterators.map(deltaSources, s -> delta.getNodes((NodeSource)s))), Containers.createCustomPolicySet(DiffCapable::isSame, DiffCapable::diffHashCode));
        final List deletedNodes = (List)Iterators.collect((Iterable)Iterators.filter((Iterable)nodesBefore, n -> !nodesAfter.contains(n)), new ArrayList());
        if (!calculateAffected) {
            return new DifferentiateResult(){

                @Override
                public Delta getDelta() {
                    return delta;
                }

                @Override
                public Iterable<Node<?, ?>> getDeletedNodes() {
                    return deletedNodes;
                }

                @Override
                public Iterable<NodeSource> getAffectedSources() {
                    return Collections.emptyList();
                }
            };
        }
        var diffContext = new DifferentiateContext(){
            private final Predicate<Node<?, ?>> ANY_CONSTRAINT = node -> true;
            final Set<NodeSource> compiledSources = deltaSources instanceof Set ? (Set)deltaSources : (Set)Iterators.collect((Iterable)deltaSources, new HashSet());
            final Map<Usage, Predicate<Node<?, ?>>> affectedUsages = new HashMap();
            final Set<BiPredicate<Node<?, ?>, Usage>> usageQueries = new HashSet();
            final Set<NodeSource> affectedSources = new HashSet<NodeSource>();

            @Override
            @NotNull
            public Graph getGraph() {
                DependencyGraphImpl dependencyGraphImpl = DependencyGraphImpl.this;
                if (dependencyGraphImpl == null) {
                    2.$$$reportNull$$$0(0);
                }
                return dependencyGraphImpl;
            }

            @Override
            @NotNull
            public Delta getDelta() {
                Delta delta2 = delta;
                if (delta2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return delta2;
            }

            @Override
            public boolean isCompiled(NodeSource src) {
                return this.compiledSources.contains(src);
            }

            @Override
            public void affectUsage(@NotNull Usage usage) {
                if (usage == null) {
                    2.$$$reportNull$$$0(2);
                }
                this.affectedUsages.put(usage, this.ANY_CONSTRAINT);
            }

            @Override
            public void affectUsage(@NotNull Usage usage, @NotNull Predicate<Node<?, ?>> constraint) {
                Predicate<Node<?, ?>> prevConstraint;
                if (usage == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (constraint == null) {
                    2.$$$reportNull$$$0(4);
                }
                if ((prevConstraint = this.affectedUsages.put(usage, constraint)) != null) {
                    this.affectedUsages.put(usage, prevConstraint == this.ANY_CONSTRAINT ? this.ANY_CONSTRAINT : prevConstraint.or(constraint));
                }
            }

            @Override
            public void affectUsage(@NotNull BiPredicate<Node<?, ?>, Usage> usageQuery) {
                if (usageQuery == null) {
                    2.$$$reportNull$$$0(5);
                }
                this.usageQueries.add(usageQuery);
            }

            @Override
            public void affectNodeSource(@NotNull NodeSource source) {
                if (source == null) {
                    2.$$$reportNull$$$0(6);
                }
                this.affectedSources.add(source);
            }

            boolean isNodeAffected(Node<?, ?> node) {
                for (Usage usage : node.getUsages()) {
                    Predicate<Node<?, ?>> constraint = this.affectedUsages.get(usage);
                    if (constraint != null && constraint.test(node)) {
                        return true;
                    }
                    for (BiPredicate<Node<?, ?>, Usage> query : this.usageQueries) {
                        if (!query.test(node, usage)) continue;
                        return true;
                    }
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/jps/dependency/impl/DependencyGraphImpl$2";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "usage";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "constraint";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "usageQuery";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getGraph";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDelta";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/jps/dependency/impl/DependencyGraphImpl$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "affectUsage";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "affectNodeSource";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        boolean incremental = true;
        for (DifferentiateStrategy diffStrategy : ourDifferentiateStrategies) {
            if (diffStrategy.differentiate(diffContext, nodesBefore, nodesAfter)) continue;
            incremental = false;
            break;
        }
        if (!incremental) {
            return DifferentiateResult.createNonIncremental(delta, deletedNodes);
        }
        final HashSet<NodeSource> affectedSources = new HashSet<NodeSource>();
        Set dependingOnDeleted = (Set)Iterators.collect((Iterable)Iterators.flat((Iterable)Iterators.map((Iterable)deletedNodes, n -> this.getDependingNodes(n.getReferenceID()))), new HashSet());
        for (ReferenceID dep : dependingOnDeleted) {
            for (NodeSource src : this.getSources(dep)) {
                affectedSources.add(src);
            }
        }
        Iterable changedScopeNodes = Iterators.unique((Iterable)Iterators.flat((Iterable)Iterators.map((Iterable)nodesAfter, n -> n.getReferenceID()), (Iterable)Iterators.map(diffContext.affectedUsages.keySet(), u -> u.getElementOwner())));
        for (ReferenceID dependent : Iterators.unique((Iterable)Iterators.filter((Iterable)Iterators.flat((Iterable)Iterators.map((Iterable)changedScopeNodes, id -> this.getDependingNodes((ReferenceID)id))), id -> !dependingOnDeleted.contains(id)))) {
            for (NodeSource depSrc : this.getSources(dependent)) {
                if (affectedSources.contains(depSrc)) continue;
                boolean affectSource = false;
                for (Node depNode : this.getNodes(depSrc)) {
                    if (!diffContext.isNodeAffected(depNode)) continue;
                    affectSource = true;
                    for (DifferentiateStrategy strategy : ourDifferentiateStrategies) {
                        if (strategy.isIncremental(diffContext, depNode)) continue;
                        return DifferentiateResult.createNonIncremental(delta, deletedNodes);
                    }
                }
                if (!affectSource) continue;
                affectedSources.add(depSrc);
            }
        }
        affectedSources.removeAll(allProcessedSources);
        affectedSources.addAll(diffContext.affectedSources);
        return new DifferentiateResult(){

            @Override
            public Delta getDelta() {
                return delta;
            }

            @Override
            public Iterable<Node<?, ?>> getDeletedNodes() {
                return deletedNodes;
            }

            @Override
            public Iterable<NodeSource> getAffectedSources() {
                return affectedSources;
            }
        };
    }

    @Override
    public void integrate(@NotNull DifferentiateResult diffResult) {
        if (diffResult == null) {
            DependencyGraphImpl.$$$reportNull$$$0(0);
        }
        Delta delta = diffResult.getDelta();
        HashSet<ReferenceID> deletedNodeIDs = new HashSet<ReferenceID>();
        for (Node<?, ?> node2 : diffResult.getDeletedNodes()) {
            this.myNodeToSourcesMap.remove(node2.getReferenceID());
            deletedNodeIDs.add(node2.getReferenceID());
        }
        for (NodeSource deletedSource : delta.getDeletedSources()) {
            for (Node node3 : this.getNodes(deletedSource)) {
                if (deletedNodeIDs.contains(node3.getReferenceID())) continue;
                this.myNodeToSourcesMap.removeValue(node3.getReferenceID(), deletedSource);
            }
            this.mySourceToNodesMap.remove(deletedSource);
        }
        Set deltaNodes = (Set)Iterators.collect((Iterable)Iterators.map((Iterable)Iterators.flat((Iterable)Iterators.map(delta.getSources(), s -> delta.getNodes((NodeSource)s))), node -> node.getReferenceID()), new HashSet());
        HashSet updatedNodes = (HashSet)Iterators.collect((Iterable)Iterators.flat((Iterable)Iterators.map(delta.getSources(), s -> this.getNodes((NodeSource)s))), new HashSet());
        for (BackDependencyIndex index : this.getIndices()) {
            BackDependencyIndex deltaIndex = delta.getIndex(index.getName());
            assert (deltaIndex != null);
            index.integrate(diffResult.getDeletedNodes(), updatedNodes, Iterators.map((Iterable)deltaNodes, id -> Pair.create((Object)id, deltaIndex.getDependencies((ReferenceID)id))));
        }
        for (ReferenceID nodeID : deltaNodes) {
            Set sources = (Set)Iterators.collect(this.myNodeToSourcesMap.get(nodeID), new HashSet());
            sources.removeAll(delta.getBaseSources());
            Iterators.collect(delta.getSources(nodeID), (Collection)sources);
            this.myNodeToSourcesMap.put(nodeID, sources);
        }
        for (NodeSource src : delta.getSources()) {
            this.mySourceToNodesMap.put(src, delta.getNodes(src));
        }
    }

    private Set<NodeSource> completeSourceSet(Iterable<NodeSource> sources, Iterable<NodeSource> deletedSources) {
        Set result = (Set)Iterators.collect(sources, new HashSet());
        Set deleted = (Set)Iterators.collect(deletedSources, new HashSet());
        Set affectedNodes = (Set)Iterators.collect((Iterable)Iterators.flat((Iterable)Iterators.map((Iterable)Iterators.flat((Iterable)result, (Iterable)deleted), s -> this.getNodes((NodeSource)s))), new HashSet());
        for (Node node : affectedNodes) {
            Iterators.collect((Iterable)Iterators.filter((Iterable)this.getSources(node.getReferenceID()), s -> {
                if (result.contains(s)) return false;
                if (deleted.contains(s)) return false;
                if (!Iterators.filter(this.getNodes((NodeSource)s).iterator(), affectedNodes::contains).hasNext()) return false;
                return true;
            }), (Collection)result);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffResult", "org/jetbrains/jps/dependency/impl/DependencyGraphImpl", "integrate"));
    }
}

