/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.AffectionScopeMetaUsage;
import org.jetbrains.jps.dependency.DifferentiateContext;
import org.jetbrains.jps.dependency.DifferentiateStrategy;
import org.jetbrains.jps.dependency.Graph;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.dependency.SerializableGraphElement;
import org.jetbrains.jps.dependency.diff.DiffCapable;
import org.jetbrains.jps.dependency.diff.Difference;
import org.jetbrains.jps.dependency.java.AnnotationUsage;
import org.jetbrains.jps.dependency.java.ClassAsGenericBoundUsage;
import org.jetbrains.jps.dependency.java.ClassNewUsage;
import org.jetbrains.jps.dependency.java.ClassUsage;
import org.jetbrains.jps.dependency.java.ElemType;
import org.jetbrains.jps.dependency.java.ImportStaticMemberUsage;
import org.jetbrains.jps.dependency.java.ImportStaticOnDemandUsage;
import org.jetbrains.jps.dependency.java.InheritanceConstraint;
import org.jetbrains.jps.dependency.java.JVMFlags;
import org.jetbrains.jps.dependency.java.JvmClass;
import org.jetbrains.jps.dependency.java.JvmField;
import org.jetbrains.jps.dependency.java.JvmMethod;
import org.jetbrains.jps.dependency.java.JvmModule;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.PackageConstraint;
import org.jetbrains.jps.dependency.java.Proto;
import org.jetbrains.jps.dependency.java.TypeRepr;
import org.jetbrains.jps.dependency.java.Utils;
import org.jetbrains.jps.javac.Iterators;

public final class JavaDifferentiateStrategy
implements DifferentiateStrategy {
    @Override
    public boolean isIncremental(DifferentiateContext context, Node<?, ?> affectedNode) {
        if (affectedNode instanceof JvmClass && ((JvmClass)affectedNode).getFlags().isGenerated()) {
            this.debug("Turning non-incremental for the BuildTarget because dependent class is annotation-processor generated: " + affectedNode.getReferenceID());
            return false;
        }
        return true;
    }

    @Override
    public boolean differentiate(DifferentiateContext context, Iterable<Node<?, ?>> nodesBefore, Iterable<Node<?, ?>> nodesAfter) {
        Utils future = new Utils(context.getGraph(), context.getDelta());
        Utils present = new Utils(context.getGraph(), null);
        Difference.Specifier classesDiff = Difference.deepDiff(Graph.getNodesOfType(nodesBefore, JvmClass.class), Graph.getNodesOfType(nodesAfter, JvmClass.class));
        for (JvmClass jvmClass : classesDiff.removed()) {
            if (this.processRemovedClass(context, jvmClass, future, present)) continue;
            return false;
        }
        for (JvmClass jvmClass : classesDiff.added()) {
            if (this.processAddedClass(context, jvmClass, future, present)) continue;
            return false;
        }
        for (Difference.Change change : classesDiff.changed()) {
            if (this.processChangedClass(context, change, future, present)) continue;
            return false;
        }
        Difference.Specifier modulesDiff = Difference.deepDiff(Graph.getNodesOfType(nodesBefore, JvmModule.class), Graph.getNodesOfType(nodesAfter, JvmModule.class));
        for (JvmModule jvmModule : modulesDiff.removed()) {
            if (JavaDifferentiateStrategy.processRemovedModule(context, jvmModule, future, present)) continue;
            return false;
        }
        for (JvmModule jvmModule : modulesDiff.added()) {
            if (JavaDifferentiateStrategy.processAddedModule(context, jvmModule, future, present)) continue;
            return false;
        }
        for (Difference.Change<JvmModule, JvmModule.Diff> change : modulesDiff.changed()) {
            if (this.processChangedModule(context, change, future, present)) continue;
            return false;
        }
        return true;
    }

    public boolean processRemovedClass(DifferentiateContext context, JvmClass removedClass, Utils future, Utils present) {
        return true;
    }

    public boolean processAddedClass(DifferentiateContext context, JvmClass addedClass, Utils future, Utils present) {
        return true;
    }

    private boolean processChangedClass(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, Utils future, Utils present) {
        JVMFlags addedFlags;
        JvmClass changedClass = change.getPast();
        JvmClass.Diff classDiff = change.getDiff();
        if (classDiff.superClassChanged() || classDiff.signatureChanged() || !classDiff.interfaces().unchanged()) {
            boolean extendsChanged = classDiff.superClassChanged() && !classDiff.extendsAdded();
            boolean affectUsages = classDiff.signatureChanged() || extendsChanged || !Iterators.isEmpty(classDiff.interfaces().removed());
            this.affectSubclasses(context, future, change.getNow().getReferenceID(), affectUsages);
            if (extendsChanged) {
                TypeRepr.ClassType exClass = new TypeRepr.ClassType(changedClass.getName());
                for (JvmClass depClass : Iterators.flat((Iterable)Iterators.map(context.getGraph().getDependingNodes(changedClass.getReferenceID()), dep -> present.getNodes((ReferenceID)dep, JvmClass.class)))) {
                    for (JvmMethod method : depClass.getMethods()) {
                        if (!method.getExceptions().contains(exClass)) continue;
                        context.affectUsage(method.createUsage(depClass.getName()));
                        this.debug("Affecting usages of methods throwing " + exClass.getJvmName() + " exception; class " + depClass.getName());
                    }
                }
            }
            if (!changedClass.isAnonymous()) {
                Set parents = (Set)Iterators.collect(present.allSupertypes(changedClass.getReferenceID()), new HashSet());
                parents.removeAll(Iterators.collect(future.allSupertypes(changedClass.getReferenceID()), new HashSet()));
                for (JvmNodeReferenceID parent : parents) {
                    this.debug("Affecting usages in generic type parameter bounds of class: " + parent);
                    context.affectUsage(new ClassAsGenericBoundUsage(parent.getNodeName()));
                }
            }
        }
        if ((addedFlags = classDiff.getAddedFlags()).isInterface() || classDiff.getRemovedFlags().isInterface()) {
            this.debug("Class-to-interface or interface-to-class conversion detected, added class usage to affected usages");
            context.affectUsage(new ClassUsage(changedClass.getName()));
        }
        if (changedClass.isAnnotation() && changedClass.getRetentionPolicy() == RetentionPolicy.SOURCE) {
            this.debug("Annotation, retention policy = SOURCE => a switch to non-incremental mode requested");
            return false;
        }
        if (addedFlags.isProtected()) {
            this.debug("Introduction of 'protected' modifier detected, adding class usage + inheritance constraint to affected usages");
            context.affectUsage(new ClassUsage(changedClass.getName()), new InheritanceConstraint(future, changedClass));
        }
        if (!changedClass.getFlags().isPackageLocal() && change.getNow().getFlags().isPackageLocal()) {
            this.debug("Introduction of 'package-private' access detected, adding class usage + package constraint to affected usages");
            context.affectUsage(new ClassUsage(changedClass.getName()), new PackageConstraint(changedClass.getPackageName()));
        }
        if (addedFlags.isFinal() || addedFlags.isPrivate()) {
            this.debug("Introduction of 'private' or 'final' modifier(s) detected, adding class usage to affected usages");
            context.affectUsage(new ClassUsage(changedClass.getName()));
        }
        if (addedFlags.isAbstract() || addedFlags.isStatic()) {
            this.debug("Introduction of 'abstract' or 'static' modifier(s) detected, adding class new usage to affected usages");
            context.affectUsage(new ClassNewUsage(changedClass.getName()));
        }
        if (!changedClass.isAnonymous() && !changedClass.isPrivate() && classDiff.flagsChanged() && changedClass.isInnerClass()) {
            this.debug("Some modifiers (access flags) were changed for non-private inner class, adding class usage to affected usages");
            context.affectUsage(new ClassUsage(changedClass.getName()));
        }
        if (changedClass.isAnnotation()) {
            this.debug("Class is annotation, performing annotation-specific analysis");
            if (classDiff.retentionPolicyChanged()) {
                this.debug("Retention policy change detected, adding class usage to affected usages");
                context.affectUsage(new ClassUsage(changedClass.getName()));
            } else if (classDiff.targetAttributeCategoryMightChange()) {
                this.debug("Annotation's attribute category in bytecode might be affected because of TYPE_USE or RECORD_COMPONENT target, adding class usage to affected usages");
                context.affectUsage(new ClassUsage(changedClass.getName()));
            } else {
                Difference.Specifier<ElemType, ?> targetsDiff = classDiff.annotationTargets();
                Set removedTargets = (Set)Iterators.collect(targetsDiff.removed(), EnumSet.noneOf(ElemType.class));
                if (removedTargets.contains((Object)ElemType.LOCAL_VARIABLE)) {
                    this.debug("Removed target contains LOCAL_VARIABLE => a switch to non-incremental mode requested");
                    if (!present.incrementalDecision(context, changedClass, null)) {
                        this.debug("End of Differentiate, returning false");
                        return false;
                    }
                }
                if (!removedTargets.isEmpty()) {
                    this.debug("Removed some annotation targets, adding annotation query");
                    TypeRepr.ClassType classType = new TypeRepr.ClassType(changedClass.getName());
                    context.affectUsage((node, usage) -> {
                        AnnotationUsage annotUsage;
                        if (usage instanceof AnnotationUsage && classType.equals((annotUsage = (AnnotationUsage)usage).getClassType())) {
                            for (ElemType target : annotUsage.getTargets()) {
                                if (!removedTargets.contains((Object)target)) continue;
                                return true;
                            }
                        }
                        return false;
                    });
                }
                for (JvmMethod m : classDiff.methods().added()) {
                    if (m.getValue() != null) continue;
                    this.debug("Added method with no default value: " + m.getName());
                    this.debug("Adding class usage to affected usages");
                    context.affectUsage(new ClassUsage(changedClass.getName()));
                    break;
                }
            }
            this.debug("End of annotation-specific analysis");
        }
        if (!this.processMethodChanges(context, change, future, present)) {
            return false;
        }
        return this.processFieldChanges(context, change, future, present);
    }

    private <T> boolean processMethodChanges(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> classChange, Utils future, Utils present) {
        JvmClass changedClass = classChange.getPast();
        if (changedClass.isAnnotation()) {
            this.debug("Class is annotation, skipping method analysis");
            return true;
        }
        Difference.Specifier<JvmMethod, JvmMethod.Diff> methodsDiff = classChange.getDiff().methods();
        this.processAddedMethods(context, changedClass, methodsDiff.added(), future, present);
        this.processRemovedMethods(context, changedClass, methodsDiff.removed(), future, present);
        this.processChangedMethods(context, changedClass, methodsDiff.changed(), future, present);
        return true;
    }

    private void processChangedMethods(DifferentiateContext context, JvmClass changedClass, Iterable<Difference.Change<JvmMethod, JvmMethod.Diff>> changed, Utils future, Utils present) {
        Iterator<Difference.Change<JvmMethod, JvmMethod.Diff>> iterator;
        this.debug("Processing changed methods: ");
        if (changedClass.isInterface() && (iterator = Iterators.filter(changed, ch -> ((JvmMethod.Diff)ch.getDiff()).getRemovedFlags().isAbstract()).iterator()).hasNext()) {
            Difference.Change<JvmMethod, JvmMethod.Diff> change = iterator.next();
            this.debug("Method became non-abstract: " + change.getPast().getName());
            this.affectLambdaInstantiations(context, present, changedClass.getReferenceID());
        }
        for (Difference.Change<JvmMethod, JvmMethod.Diff> change : changed) {
            JvmMethod changedMethod = change.getPast();
            JvmMethod.Diff diff = change.getDiff();
            this.debug("Method: " + changedMethod.getName());
            if (changedClass.isAnnotation()) {
                if (!diff.valueRemoved()) continue;
                this.debug("Class is annotation, default value is removed => adding annotation query");
                String argName = changedMethod.getName();
                TypeRepr.ClassType annotType = new TypeRepr.ClassType(changedClass.getName());
                context.affectUsage((node, usage) -> {
                    if (!(usage instanceof AnnotationUsage)) return false;
                    AnnotationUsage au = (AnnotationUsage)usage;
                    if (!annotType.equals(au.getClassType())) return false;
                    if (!Iterators.isEmpty((Iterable)Iterators.filter(au.getUsedArgNames(), argName::equals))) return false;
                    return true;
                });
                continue;
            }
            Iterable propagated = Iterators.lazy(() -> future.collectSubclassesWithoutMethod(changedClass.getReferenceID(), changedMethod));
            if (diff.becamePackageLocal()) {
                this.debug("Method became package-private, affecting method usages outside the package");
                this.affectMethodUsages(context, changedClass.getReferenceID(), changedMethod, propagated, new PackageConstraint(changedClass.getPackageName()));
            }
            if (diff.typeChanged() || diff.signatureChanged() || !diff.exceptions().unchanged()) {
                this.debug("Return type, throws list or signature changed --- affecting method usages");
                this.affectMethodUsages(context, changedClass.getReferenceID(), changedMethod, propagated);
                for (JvmNodeReferenceID subClass : Iterators.unique((Iterable)Iterators.map(future.getOverridingMethods(changedClass, changedMethod, changedMethod::isSameByJavaRules), p -> ((JvmClass)p.getFirst()).getReferenceID()))) {
                    for (NodeSource source : context.getGraph().getSources(subClass)) {
                        if (context.isCompiled(source)) continue;
                        context.affectNodeSource(source);
                    }
                }
                continue;
            }
            if (!diff.flagsChanged()) continue;
            JVMFlags addedFlags = diff.getAddedFlags();
            JVMFlags removedFlags = diff.getRemovedFlags();
            if (addedFlags.isStatic() || addedFlags.isPrivate() || addedFlags.isSynthetic() || addedFlags.isBridge() || removedFlags.isStatic()) {
                this.debug("Added {static | private | synthetic | bridge} specifier or removed static specifier --- affecting method usages");
                this.affectMethodUsages(context, changedClass.getReferenceID(), changedMethod, propagated);
                if (addedFlags.isStatic()) {
                    this.debug("Added static specifier --- affecting subclasses");
                    this.affectSubclasses(context, future, changedClass.getReferenceID(), false);
                    if (changedMethod.isPrivate()) continue;
                    this.debug("Added static modifier --- affecting static member on-demand import usages");
                    this.affectStaticMemberOnDemandUsages(context, changedClass.getReferenceID(), propagated);
                    continue;
                }
                if (!removedFlags.isStatic() || changedMethod.isPrivate()) continue;
                this.debug("Removed static modifier --- affecting static method import usages");
                this.affectStaticMemberImportUsages(context, changedClass.getReferenceID(), changedMethod.getName(), propagated);
                continue;
            }
            if (addedFlags.isFinal() || addedFlags.isPublic() || addedFlags.isAbstract()) {
                this.debug("Added final, public or abstract specifier --- affecting subclasses");
                this.affectSubclasses(context, future, changedClass.getReferenceID(), false);
                if (changedClass.isInterface() && addedFlags.isAbstract()) {
                    this.affectLambdaInstantiations(context, present, changedClass.getReferenceID());
                }
            }
            if (!addedFlags.isProtected() || removedFlags.isPrivate()) continue;
            this.debug("Added public or package-private method became protected --- affect method usages with protected constraint");
            this.affectMethodUsages(context, changedClass.getReferenceID(), changedMethod, propagated, new InheritanceConstraint(future, changedClass));
        }
        Collection moreAccessible = Iterators.collect((Iterable)Iterators.filter(changed, ch -> ((JvmMethod.Diff)ch.getDiff()).accessExpanded()), (Collection)new SmartList());
        if (!Iterators.isEmpty((Iterable)moreAccessible)) {
            Iterable<OverloadDescriptor> overloaded = JavaDifferentiateStrategy.findAllOverloads(future, changedClass, method -> {
                JVMFlags mostAccessible = null;
                for (Difference.Change change : moreAccessible) {
                    JvmMethod m = (JvmMethod)change.getNow();
                    if (!Objects.equals(m.getName(), method.getName()) || m.isSame((DiffCapable<?, ?>)method) || mostAccessible != null && !mostAccessible.isWeakerAccess(m.getFlags())) continue;
                    mostAccessible = m.getFlags();
                }
                return mostAccessible;
            });
            for (OverloadDescriptor descr : overloaded) {
                this.debug("Method became more accessible --- affect usages of overloading methods: " + descr.overloadMethod.getName());
                Predicate<Node<?, ?>> constr = descr.accessScope.isPackageLocal() ? new PackageConstraint(changedClass.getPackageName()).negate() : (descr.accessScope.isProtected() ? new InheritanceConstraint(future, changedClass).negate() : null);
                this.affectMethodUsages(context, descr.owner, descr.overloadMethod, future.collectSubclassesWithoutMethod(descr.owner, descr.overloadMethod), constr);
            }
        }
        this.debug("End of changed methods processing");
    }

    private static Iterable<OverloadDescriptor> findAllOverloads(Utils utils, JvmClass cls, Function<? super JvmMethod, JVMFlags> correspondenceFinder) {
        Function<JvmClass, Iterable> mapper = c -> Iterators.filter((Iterable)Iterators.map(c.getMethods(), m -> {
            JVMFlags accessScope = (JVMFlags)correspondenceFinder.apply((JvmMethod)m);
            return accessScope != null ? new OverloadDescriptor(accessScope, (JvmMethod)m, c.getReferenceID()) : null;
        }), (Iterators.BooleanFunction)Iterators.notNullFilter());
        return Iterators.flat((Iterable)Iterators.flat((Iterable)Iterators.map((Iterable)Iterators.recurse((Object)cls, cl -> Iterators.flat((Iterable)Iterators.map(cl.getSuperTypes(), st -> utils.getClassesByName((String)st))), (boolean)true), cl -> (Iterable)mapper.apply((JvmClass)cl))), (Iterable)Iterators.flat((Iterable)Iterators.map(utils.allSubclasses(cls.getReferenceID()), id -> Iterators.flat((Iterable)Iterators.map(utils.getNodes((ReferenceID)id, JvmClass.class), cl1 -> (Iterable)mapper.apply((JvmClass)cl1))))));
    }

    private void processRemovedMethods(DifferentiateContext context, JvmClass changedClass, Iterable<JvmMethod> removed, Utils future, Utils present) {
        this.debug("Processing removed methods: ");
        boolean extendsLibraryClass = future.inheritsFromLibraryClass(changedClass);
        for (JvmMethod removedMethod : removed) {
            boolean isClearlyOverridden;
            this.debug("Method " + removedMethod.getName());
            Iterable propagated = Iterators.lazy(() -> future.collectSubclassesWithoutMethod(changedClass.getReferenceID(), removedMethod));
            if (!removedMethod.isPrivate() && removedMethod.isStatic()) {
                this.debug("The method was static --- affecting static method import usages");
                this.affectStaticMemberImportUsages(context, changedClass.getReferenceID(), removedMethod.getName(), propagated);
            }
            Iterable overridden = Iterators.lazy(() -> removedMethod.isConstructor() ? Collections.emptyList() : future.getOverriddenMethods(changedClass, removedMethod::isSameByJavaRules));
            boolean bl = isClearlyOverridden = removedMethod.getSignature().isEmpty() && !extendsLibraryClass && !Iterators.isEmpty((Iterable)overridden) && Iterators.isEmpty((Iterable)Iterators.filter((Iterable)overridden, p -> !((JvmMethod)p.getSecond()).getType().equals(removedMethod.getType()) || !((JvmMethod)p.getSecond()).getSignature().isEmpty() || removedMethod.isMoreAccessibleThan((Proto)p.getSecond())));
            if (!isClearlyOverridden) {
                this.debug("No overridden methods found, affecting method usages");
                this.affectMethodUsages(context, changedClass.getReferenceID(), removedMethod, propagated);
            }
            for (Pair<JvmClass, JvmMethod> overriding : future.getOverridingMethods(changedClass, removedMethod, removedMethod::isSameByJavaRules)) {
                for (NodeSource source : context.getGraph().getSources(((JvmClass)overriding.getFirst()).getReferenceID())) {
                    if (context.isCompiled(source)) continue;
                    context.affectNodeSource(source);
                    this.debug("Affecting file by overriding: " + source.getPath());
                }
            }
            if (removedMethod.isConstructor() || removedMethod.isAbstract() || removedMethod.isStatic()) continue;
            for (JvmNodeReferenceID id : propagated) {
                boolean allOverriddenAbstract;
                Iterator<SerializableGraphElement> iterator = future.getNodes(id, JvmClass.class).iterator();
                if (!iterator.hasNext()) continue;
                JvmClass subClass = (JvmClass)iterator.next();
                Iterable overriddenForSubclass = Iterators.filter(future.getOverriddenMethods(subClass, removedMethod::isSameByJavaRules), p -> ((JvmMethod)p.getSecond()).isAbstract() || removedMethod.isSame((DiffCapable)p.getSecond()));
                boolean bl2 = allOverriddenAbstract = !Iterators.isEmpty((Iterable)overriddenForSubclass) && Iterators.isEmpty((Iterable)Iterators.filter((Iterable)overriddenForSubclass, p -> !((JvmMethod)p.getSecond()).isAbstract()));
                if (!allOverriddenAbstract && !future.inheritsFromLibraryClass(subClass)) continue;
                this.debug("Removed method is not abstract & overrides some abstract method which is not then over-overridden in subclass " + subClass.getName());
                for (NodeSource source : context.getGraph().getSources(subClass.getReferenceID())) {
                    if (context.isCompiled(source)) continue;
                    context.affectNodeSource(source);
                    this.debug("Affecting subclass source file: " + source.getPath());
                }
            }
        }
        this.debug("End of removed methods processing");
    }

    private void processAddedMethods(DifferentiateContext context, JvmClass changedClass, Iterable<JvmMethod> added, Utils future, Utils present) {
        this.debug("Processing added methods: ");
        for (JvmMethod addedMethod : added) {
            if (addedMethod.isPrivate() || !changedClass.isInterface() && !changedClass.isAbstract() && !addedMethod.isAbstract()) continue;
            this.debug("Method: " + addedMethod.getName());
            this.debug("Class is abstract, or is interface, or added non-private method is abstract => affecting all subclasses");
            this.affectSubclasses(context, future, changedClass.getReferenceID(), false);
            break;
        }
        if (changedClass.isInterface()) {
            for (JvmMethod addedMethod : added) {
                if (addedMethod.isPrivate() || !addedMethod.isAbstract()) continue;
                this.debug("Added non-private abstract method: " + addedMethod.getName());
                this.affectLambdaInstantiations(context, present, changedClass.getReferenceID());
                break;
            }
        }
        for (JvmMethod addedMethod : added) {
            JvmClass cls;
            this.debug("Method: " + addedMethod.getName());
            if (addedMethod.isPrivate()) continue;
            Iterable propagated = Iterators.lazy(() -> future.collectSubclassesWithoutMethod(changedClass.getReferenceID(), addedMethod));
            if (!Iterators.isEmpty(addedMethod.getArgTypes()) && !present.hasOverriddenMethods(changedClass, addedMethod)) {
                this.debug("Conservative case on overriding methods, affecting method usages");
                context.affectUsage(addedMethod.createUsageQuery(changedClass.getName()));
                if (!addedMethod.isConstructor()) {
                    for (JvmNodeReferenceID id : propagated) {
                        context.affectUsage(new AffectionScopeMetaUsage(id));
                        context.affectUsage(addedMethod.createUsageQuery(id.getNodeName()));
                    }
                }
            }
            if (addedMethod.isStatic()) {
                this.affectStaticMemberOnDemandUsages(context, changedClass.getReferenceID(), propagated);
            }
            Predicate<JvmMethod> lessSpecificCond = future.lessSpecific(addedMethod);
            for (JvmMethod jvmMethod : Iterators.filter(changedClass.getMethods(), lessSpecificCond::test)) {
                this.debug("Found less specific method, affecting method usages; " + jvmMethod.getName() + jvmMethod.getDescriptor());
                this.affectMethodUsages(context, changedClass.getReferenceID(), jvmMethod, present.collectSubclassesWithoutMethod(changedClass.getReferenceID(), jvmMethod));
            }
            this.debug("Processing affected by specificity methods");
            for (Pair pair : future.getOverriddenMethods(changedClass, lessSpecificCond)) {
                cls = (JvmClass)pair.getFirst();
                JvmMethod overriddenMethod = (JvmMethod)pair.getSecond();
                this.debug("Method: " + overriddenMethod.getName());
                this.debug("Class : " + cls.getName());
                this.debug("Affecting method usages for that found");
                this.affectMethodUsages(context, changedClass.getReferenceID(), overriddenMethod, present.collectSubclassesWithoutMethod(changedClass.getReferenceID(), overriddenMethod));
            }
            for (Pair pair : future.getOverridingMethods(changedClass, addedMethod, lessSpecificCond)) {
                cls = (JvmClass)pair.getFirst();
                JvmMethod overridingMethod = (JvmMethod)pair.getSecond();
                this.debug("Method: " + overridingMethod.getName());
                this.debug("Class : " + cls.getName());
                if (overridingMethod.isSameByJavaRules(addedMethod)) {
                    this.debug("Current method overrides the added method");
                    for (NodeSource source : context.getGraph().getSources(cls.getReferenceID())) {
                        if (context.isCompiled(source)) continue;
                        this.debug("Affecting source " + source.getPath());
                        context.affectNodeSource(source);
                    }
                    continue;
                }
                this.debug("Current method does not override the added method");
                this.debug("Affecting method usages for the method");
                this.affectMethodUsages(context, cls.getReferenceID(), overridingMethod, present.collectSubclassesWithoutMethod(cls.getReferenceID(), overridingMethod));
            }
            for (ReferenceID referenceID : future.allSubclasses(changedClass.getReferenceID())) {
                Iterable<NodeSource> sources = context.getGraph().getSources(referenceID);
                if (Iterators.isEmpty((Iterable)Iterators.filter(sources, s -> !context.isCompiled((NodeSource)s)))) continue;
                for (JvmClass outerClass : Iterators.flat((Iterable)Iterators.map(future.getNodes(referenceID, JvmClass.class), cl -> future.getNodes(new JvmNodeReferenceID(cl.getOuterFqName()), JvmClass.class)))) {
                    if (!future.isMethodVisible(outerClass, addedMethod) && !future.inheritsFromLibraryClass(outerClass)) continue;
                    for (NodeSource source : sources) {
                        this.debug("Affecting file due to local overriding: " + source.getPath());
                        context.affectNodeSource(source);
                    }
                }
            }
        }
        this.debug("End of added methods processing");
    }

    private static boolean processRemovedModule(DifferentiateContext context, JvmModule removedModule, Utils future, Utils present) {
        return true;
    }

    private static boolean processAddedModule(DifferentiateContext context, JvmModule addedModule, Utils future, Utils present) {
        return true;
    }

    private boolean processChangedModule(DifferentiateContext context, Difference.Change<JvmModule, JvmModule.Diff> change, Utils future, Utils present) {
        JvmModule.Diff moduleDiff = change.getDiff();
        return true;
    }

    private void affectMethodUsages(DifferentiateContext context, JvmNodeReferenceID clsId, JvmMethod method, Iterable<JvmNodeReferenceID> propagated) {
        this.affectMethodUsages(context, clsId, method, propagated, null);
    }

    private void affectMethodUsages(DifferentiateContext context, JvmNodeReferenceID clsId, JvmMethod method, Iterable<JvmNodeReferenceID> propagated, @Nullable Predicate<Node<?, ?>> constraint) {
        for (JvmNodeReferenceID id : Iterators.flat((Iterable)Iterators.asIterable((Object)clsId), propagated)) {
            if (constraint != null) {
                context.affectUsage(method.createUsage(id.getNodeName()), constraint);
            } else {
                context.affectUsage(method.createUsage(id.getNodeName()));
            }
            this.debug("Affect method usage referenced of class " + id.getNodeName());
        }
    }

    private void affectStaticMemberOnDemandUsages(DifferentiateContext context, JvmNodeReferenceID clsId, Iterable<JvmNodeReferenceID> propagated) {
        for (JvmNodeReferenceID id : Iterators.flat((Iterable)Iterators.asIterable((Object)clsId), propagated)) {
            this.debug("Affect static member on-demand import usage referenced of class " + id.getNodeName());
            context.affectUsage(new ImportStaticOnDemandUsage(id.getNodeName()));
        }
    }

    private void affectStaticMemberImportUsages(DifferentiateContext context, JvmNodeReferenceID clsId, String memberName, Iterable<JvmNodeReferenceID> propagated) {
        for (JvmNodeReferenceID id : Iterators.flat((Iterable)Iterators.asIterable((Object)clsId), propagated)) {
            this.debug("Affect static member import usage referenced of class " + id.getNodeName());
            context.affectUsage(new ImportStaticMemberUsage(id.getNodeName(), memberName));
        }
    }

    private boolean processFieldChanges(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> classChange, Utils future, Utils present) {
        JvmClass changedClass = classChange.getPast();
        Difference.Specifier<JvmField, JvmField.Diff> fields = classChange.getDiff().fields();
        return true;
    }

    private void affectSubclasses(DifferentiateContext context, Utils utils, ReferenceID fromClass, boolean affectUsages) {
        this.debug("Affecting subclasses of class: " + fromClass + "; with usages affection: " + affectUsages);
        Graph graph = context.getGraph();
        for (ReferenceID cl : utils.withAllSubclasses(fromClass)) {
            String nodeName;
            for (NodeSource source : graph.getSources(cl)) {
                if (context.isCompiled(source)) continue;
                context.affectNodeSource(source);
            }
            if (!affectUsages || (nodeName = utils.getNodeName(cl)) == null) continue;
            context.affectUsage(new ClassUsage(nodeName));
        }
    }

    private void affectLambdaInstantiations(DifferentiateContext context, Utils utils, ReferenceID fromClass) {
        for (ReferenceID id : utils.withAllSubclasses(fromClass)) {
            String clsName;
            if (!utils.isLambdaTarget(id) || (clsName = utils.getNodeName(id)) == null) continue;
            this.debug("The interface could be not a SAM interface anymore or lambda target method name has changed => affecting lambda instantiations for " + clsName);
            context.affectUsage(new ClassNewUsage(clsName));
        }
    }

    private void debug(String message) {
    }

    private static final class OverloadDescriptor {
        final JVMFlags accessScope;
        final JvmMethod overloadMethod;
        final JvmNodeReferenceID owner;

        OverloadDescriptor(JVMFlags accessScope, JvmMethod overloadMethod, JvmNodeReferenceID owner) {
            this.accessScope = accessScope;
            this.overloadMethod = overloadMethod;
            this.owner = owner;
        }
    }
}

