/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.artifacts.ArtifactBasedBuildTarget;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTargetType;
import org.jetbrains.jps.incremental.artifacts.builders.LayoutElementBuildersRegistry;
import org.jetbrains.jps.incremental.artifacts.impl.JpsArtifactUtil;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactInstructionsBuilderContext;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactInstructionsBuilderContextImpl;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactInstructionsBuilderImpl;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.CopyToDirectoryInstructionCreator;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactOutputPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;

public final class ArtifactBuildTarget
extends ArtifactBasedBuildTarget {
    public ArtifactBuildTarget(@NotNull JpsArtifact artifact) {
        if (artifact == null) {
            ArtifactBuildTarget.$$$reportNull$$$0(0);
        }
        super(ArtifactBuildTargetType.INSTANCE, artifact);
    }

    @Override
    @NotNull
    public Collection<BuildTarget<?>> computeDependencies(@NotNull BuildTargetRegistry targetRegistry, @NotNull TargetOutputIndex outputIndex) {
        if (targetRegistry == null) {
            ArtifactBuildTarget.$$$reportNull$$$0(1);
        }
        if (outputIndex == null) {
            ArtifactBuildTarget.$$$reportNull$$$0(2);
        }
        LinkedHashSet dependencies = new LinkedHashSet();
        JpsArtifact artifact = this.getArtifact();
        JpsArtifactUtil.processPackagingElements((JpsPackagingElement)artifact.getRootElement(), (Processor<? super JpsPackagingElement>)((Processor)element -> {
            JpsArtifact included;
            if (element instanceof JpsArtifactOutputPackagingElement && (included = (JpsArtifact)((JpsArtifactOutputPackagingElement)element).getArtifactReference().resolve()) != null && !included.equals(artifact) && !StringUtil.isEmpty((String)included.getOutputPath())) {
                dependencies.add(new ArtifactBuildTarget(included));
                return false;
            }
            dependencies.addAll(LayoutElementBuildersRegistry.getInstance().getDependencies((JpsPackagingElement)element, outputIndex));
            return true;
        }));
        if (!dependencies.isEmpty()) {
            SmartList additional = new SmartList();
            for (BuildTarget buildTarget : dependencies) {
                if (!(buildTarget instanceof ModuleBasedTarget)) continue;
                ModuleBasedTarget target = (ModuleBasedTarget)buildTarget;
                additional.addAll(targetRegistry.getModuleBasedTargets(target.getModule(), target.isTests() ? BuildTargetRegistry.ModuleTargetSelector.TEST : BuildTargetRegistry.ModuleTargetSelector.PRODUCTION));
            }
            dependencies.addAll((Collection<BuildTarget<?>>)additional);
        }
        LinkedHashSet linkedHashSet = dependencies;
        if (linkedHashSet == null) {
            ArtifactBuildTarget.$$$reportNull$$$0(3);
        }
        return linkedHashSet;
    }

    @Override
    public void writeConfiguration(@NotNull ProjectDescriptor pd, @NotNull PrintWriter out) {
        if (pd == null) {
            ArtifactBuildTarget.$$$reportNull$$$0(4);
        }
        if (out == null) {
            ArtifactBuildTarget.$$$reportNull$$$0(5);
        }
        PathRelativizerService relativizer = pd.dataManager.getRelativizer();
        String outputPath = this.getArtifact().getOutputPath();
        out.println(StringUtil.isNotEmpty((String)outputPath) ? relativizer.toRelative(outputPath) : "");
        BuildRootIndex rootIndex = pd.getBuildRootIndex();
        for (ArtifactRootDescriptor descriptor : rootIndex.getTargetRoots(this, null)) {
            descriptor.writeConfiguration(out, relativizer);
        }
    }

    @Override
    @NotNull
    public List<ArtifactRootDescriptor> computeRootDescriptors(@NotNull JpsModel model, @NotNull ModuleExcludeIndex index, @NotNull IgnoredFileIndex ignoredFileIndex, @NotNull BuildDataPaths dataPaths) {
        if (model == null) {
            ArtifactBuildTarget.$$$reportNull$$$0(6);
        }
        if (index == null) {
            ArtifactBuildTarget.$$$reportNull$$$0(7);
        }
        if (ignoredFileIndex == null) {
            ArtifactBuildTarget.$$$reportNull$$$0(8);
        }
        if (dataPaths == null) {
            ArtifactBuildTarget.$$$reportNull$$$0(9);
        }
        ArtifactInstructionsBuilderImpl builder = new ArtifactInstructionsBuilderImpl(index, ignoredFileIndex, this, model, dataPaths);
        ArtifactInstructionsBuilderContextImpl context = new ArtifactInstructionsBuilderContextImpl(model, dataPaths);
        JpsArtifact artifact = this.getArtifact();
        String outputPath = StringUtil.notNullize((String)artifact.getOutputPath());
        CopyToDirectoryInstructionCreator instructionCreator = new CopyToDirectoryInstructionCreator(builder, outputPath);
        LayoutElementBuildersRegistry.getInstance().generateInstructions(artifact, instructionCreator, (ArtifactInstructionsBuilderContext)context);
        List<ArtifactRootDescriptor> list = builder.getDescriptors();
        if (list == null) {
            ArtifactBuildTarget.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    public ArtifactRootDescriptor findRootDescriptor(@NotNull String rootId, @NotNull BuildRootIndex rootIndex) {
        if (rootId == null) {
            ArtifactBuildTarget.$$$reportNull$$$0(11);
        }
        if (rootIndex == null) {
            ArtifactBuildTarget.$$$reportNull$$$0(12);
        }
        return rootIndex.getTargetRoots(this, null).get(Integer.parseInt(rootId));
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = "Artifact '" + this.getArtifact().getName() + "'";
        if (string == null) {
            ArtifactBuildTarget.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    @NotNull
    public Collection<File> getOutputRoots(@NotNull CompileContext context) {
        String outputFilePath;
        if (context == null) {
            ArtifactBuildTarget.$$$reportNull$$$0(14);
        }
        Collection<File> collection = (outputFilePath = this.getArtifact().getOutputFilePath()) != null && !StringUtil.isEmpty((String)outputFilePath) ? Collections.singleton(new File(FileUtil.toSystemDependentName((String)outputFilePath))) : Collections.emptyList();
        if (collection == null) {
            ArtifactBuildTarget.$$$reportNull$$$0(15);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRegistry";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputIndex";
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/artifacts/ArtifactBuildTarget";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pd";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredFileIndex";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPaths";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootId";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootIndex";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/artifacts/ArtifactBuildTarget";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDependencies";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRootDescriptors";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeDependencies";
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 15: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeConfiguration";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeRootDescriptors";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findRootDescriptor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getOutputRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

