/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.client;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.UnmarshalException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CompilerSystemProperties;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.daemon.client.BasicCompilerServicesWithResultsFacadeServer;
import org.jetbrains.kotlin.daemon.client.CompileServiceSession;
import org.jetbrains.kotlin.daemon.client.DaemonReportingTargets;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClient;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClient$ClientOptions$mappers$1;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClientKt;
import org.jetbrains.kotlin.daemon.client.NativePlatformUtilKt;
import org.jetbrains.kotlin.daemon.common.BoolPropMapper;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.CompilerMode;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptionsMemoryComparator;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DaemonWithMetadata;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.FileAgeComparator;
import org.jetbrains.kotlin.daemon.common.NetworkUtilsKt;
import org.jetbrains.kotlin.daemon.common.OptionsGroup;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.PropMapper;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001MB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0087\u0001\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\"\b\u0002\u0010\u001a\u001a\u001c\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001d\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001b2\b\b\u0002\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\u00042\b\b\u0002\u0010$\u001a\u00020%\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020(H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0002JL\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\f2\u0006\u00106\u001a\u00020\f2\n\b\u0002\u00107\u001a\u0004\u0018\u00010\u001cJ<\u00108\u001a\u0004\u0018\u0001H9\"\u0004\b\u0000\u001092\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\f2\u0014\u0010:\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u0001H90;H\u0082\b\u00a2\u0006\u0002\u0010<J:\u0010=\u001a\u0004\u0018\u00010\u00112\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u00020\fJ<\u0010=\u001a\u0004\u0018\u00010\u00112\u0006\u0010,\u001a\u00020-2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u00020\f2\b\b\u0002\u0010>\u001a\u00020\fJ\u000e\u0010?\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u001dJ\u000e\u0010@\u001a\u00020\u001c2\u0006\u00101\u001a\u000202J\u0018\u0010A\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010B\u001a\u0004\u0018\u00010\u0017J!\u0010C\u001a\u00020\u001e2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017H\u0007\u00a2\u0006\u0002\u0010DJ\u0016\u0010E\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010F\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-J\u0016\u0010F\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-2\u0006\u00101\u001a\u000202J(\u0010G\u001a\u00020\f2\u0006\u0010,\u001a\u00020-2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002JH\u0010H\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u0002000I2\u0006\u0010J\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-2\u0006\u0010/\u001a\u0002002\u0018\u0010K\u001a\u0014\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001e0\u001bH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006N"}, d2={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient;", "", "()V", "DAEMON_CONNECT_CYCLE_ATTEMPTS", "", "getDAEMON_CONNECT_CYCLE_ATTEMPTS", "()I", "DAEMON_DEFAULT_STARTUP_TIMEOUT_MS", "", "getDAEMON_DEFAULT_STARTUP_TIMEOUT_MS", "()J", "verboseReporting", "", "getVerboseReporting", "()Z", "compile", "compilerService", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "sessionId", "targetPlatform", "Lorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;", "args", "", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "outputsCollector", "Lkotlin/Function2;", "Ljava/io/File;", "", "", "compilerMode", "Lorg/jetbrains/kotlin/daemon/common/CompilerMode;", "reportSeverity", "Lorg/jetbrains/kotlin/daemon/common/ReportSeverity;", "port", "profiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lkotlin/jvm/functions/Function2;Lorg/jetbrains/kotlin/daemon/common/CompilerMode;Lorg/jetbrains/kotlin/daemon/common/ReportSeverity;ILorg/jetbrains/kotlin/daemon/common/Profiler;)I", "configureClientOptions", "Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$ClientOptions;", "opts", "connectAndLease", "Lorg/jetbrains/kotlin/daemon/client/CompileServiceSession;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "clientAliveFlagFile", "daemonJVMOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "reportingTargets", "Lorg/jetbrains/kotlin/daemon/client/DaemonReportingTargets;", "autostart", "leaseSession", "sessionAliveFlagFile", "connectLoop", "R", "body", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/daemon/client/DaemonReportingTargets;ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "connectToCompileService", "checkId", "detectCompilerClasspath", "getOrCreateClientFlagFile", "leaseCompileSession", "aliveFlagPath", "main", "([Ljava/lang/String;)V", "releaseCompileSession", "shutdownCompileService", "startDaemon", "tryFindSuitableDaemonOrNewOpts", "Lkotlin/Pair;", "registryDir", "report", "Lorg/jetbrains/kotlin/daemon/common/DaemonReportCategory;", "ClientOptions", "kotlin-daemon-client"})
@SourceDebugExtension(value={"SMAP\nKotlinCompilerClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCompilerClient.kt\norg/jetbrains/kotlin/daemon/client/KotlinCompilerClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 PerfUtils.kt\norg/jetbrains/kotlin/daemon/common/PerfUtilsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,489:1\n303#1,30:491\n1#2:490\n1#2:543\n44#3,4:521\n37#4,2:525\n1549#5:527\n1620#5,3:528\n1603#5,9:531\n1855#5:540\n1856#5:544\n1612#5:545\n1789#5,3:546\n1360#5:549\n1446#5,5:550\n1360#5:555\n1446#5,5:556\n1360#5:561\n1446#5,5:562\n179#6,2:541\n*E\n*S KotlinDebug\n*F\n+ 1 KotlinCompilerClient.kt\norg/jetbrains/kotlin/daemon/client/KotlinCompilerClient\n*L\n100#1,30:491\n292#1:543\n158#1,4:521\n267#1,2:525\n290#1:527\n290#1,3:528\n292#1,9:531\n292#1:540\n292#1:544\n292#1:545\n353#1,3:546\n372#1:549\n372#1,5:550\n375#1:555\n375#1,5:556\n376#1:561\n376#1,5:562\n294#1,2:541\n*E\n"})
public final class KotlinCompilerClient {
    private static final long DAEMON_DEFAULT_STARTUP_TIMEOUT_MS;
    private static final int DAEMON_CONNECT_CYCLE_ATTEMPTS;
    private static final boolean verboseReporting;
    @NotNull
    public static final KotlinCompilerClient INSTANCE;

    public final long getDAEMON_DEFAULT_STARTUP_TIMEOUT_MS() {
        return DAEMON_DEFAULT_STARTUP_TIMEOUT_MS;
    }

    public final int getDAEMON_CONNECT_CYCLE_ATTEMPTS() {
        return DAEMON_CONNECT_CYCLE_ATTEMPTS;
    }

    public final boolean getVerboseReporting() {
        return verboseReporting;
    }

    @NotNull
    public final File getOrCreateClientFlagFile(@NotNull DaemonOptions daemonOptions) {
        Object object;
        block3: {
            block2: {
                Object object2;
                Intrinsics.checkNotNullParameter((Object)daemonOptions, (String)"daemonOptions");
                object = CompilerSystemProperties.COMPILE_DAEMON_CLIENT_ALIVE_PATH_PROPERTY.getValue();
                if (object == null) break block2;
                Object p1 = object2 = object;
                boolean bl = false;
                object = DaemonParamsKt.trimQuotes((String)p1);
                if (object == null) break block2;
                p1 = object2 = object;
                boolean bl2 = false;
                object = !StringsKt.isBlank((CharSequence)((CharSequence)p1)) ? object2 : null;
                if (object == null) break block2;
                p1 = object2 = object;
                boolean bl3 = false;
                p1 = object2 = new File((String)p1);
                boolean bl4 = false;
                object = ((File)p1).exists() ? object2 : null;
                if (object != null) break block3;
            }
            object = ClientUtilsKt.makeAutodeletingFlagFile$default(null, new File(DaemonParamsKt.getRunFilesPathOrDefault(daemonOptions)), 1, null);
        }
        return object;
    }

    @Nullable
    public final CompileService connectToCompileService(@NotNull CompilerId compilerId, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart, boolean checkId) {
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkNotNullParameter((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkNotNullParameter((Object)reportingTargets, (String)"reportingTargets");
        File flagFile = this.getOrCreateClientFlagFile(daemonOptions);
        return this.connectToCompileService(compilerId, flagFile, daemonJVMOptions, daemonOptions, reportingTargets, autostart);
    }

    public static /* synthetic */ CompileService connectToCompileService$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        return kotlinCompilerClient.connectToCompileService(compilerId, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl, bl2);
    }

    @Nullable
    public final CompileService connectToCompileService(@NotNull CompilerId compilerId, @NotNull File clientAliveFlagFile, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart) {
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter((Object)clientAliveFlagFile, (String)"clientAliveFlagFile");
        Intrinsics.checkNotNullParameter((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkNotNullParameter((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkNotNullParameter((Object)reportingTargets, (String)"reportingTargets");
        CompileServiceSession compileServiceSession = this.connectAndLease(compilerId, clientAliveFlagFile, daemonJVMOptions, daemonOptions, reportingTargets, autostart, false, null);
        return compileServiceSession != null ? compileServiceSession.getCompileService() : null;
    }

    public static /* synthetic */ CompileService connectToCompileService$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, File file2, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        return kotlinCompilerClient.connectToCompileService(compilerId, file2, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final CompileServiceSession connectAndLease(@NotNull CompilerId compilerId, @NotNull File clientAliveFlagFile, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart, boolean leaseSession, @Nullable File sessionAliveFlagFile) {
        KotlinCompilerClient kotlinCompilerClient;
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter((Object)clientAliveFlagFile, (String)"clientAliveFlagFile");
        Intrinsics.checkNotNullParameter((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkNotNullParameter((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkNotNullParameter((Object)reportingTargets, (String)"reportingTargets");
        KotlinCompilerClient this_$iv = this;
        boolean $i$f$connectLoop = false;
        KotlinCompilerClient kotlinCompilerClient2 = kotlinCompilerClient = this_$iv;
        synchronized (kotlinCompilerClient2) {
            Object v1;
            boolean bl = false;
            try {
                int attempts$iv = 1;
                do {
                    void res$iv;
                    Pair pair;
                    try {
                        CompileServiceSession compileServiceSession;
                        void service;
                        boolean isLastAttempt = attempts$iv >= INSTANCE.getDAEMON_CONNECT_CYCLE_ATTEMPTS();
                        boolean bl2 = false;
                        Function1<CompileService, CompileServiceSession> $fun$leaseImpl$1 = new Function1<CompileService, CompileServiceSession>(clientAliveFlagFile, reportingTargets, leaseSession, sessionAliveFlagFile, daemonOptions, compilerId, daemonJVMOptions, autostart){
                            final /* synthetic */ File $clientAliveFlagFile$inlined;
                            final /* synthetic */ DaemonReportingTargets $reportingTargets$inlined;
                            final /* synthetic */ boolean $leaseSession$inlined;
                            final /* synthetic */ File $sessionAliveFlagFile$inlined;
                            final /* synthetic */ DaemonOptions $daemonOptions$inlined;
                            final /* synthetic */ CompilerId $compilerId$inlined;
                            final /* synthetic */ DaemonJVMOptions $daemonJVMOptions$inlined;
                            final /* synthetic */ boolean $autostart$inlined;
                            {
                                this.$clientAliveFlagFile$inlined = file2;
                                this.$reportingTargets$inlined = daemonReportingTargets;
                                this.$leaseSession$inlined = bl;
                                this.$sessionAliveFlagFile$inlined = file3;
                                this.$daemonOptions$inlined = daemonOptions;
                                this.$compilerId$inlined = compilerId;
                                this.$daemonJVMOptions$inlined = daemonJVMOptions;
                                this.$autostart$inlined = bl2;
                                super(1);
                            }

                            @Nullable
                            public final CompileServiceSession invoke(@NotNull CompileService $this$leaseImpl) {
                                CompileServiceSession compileServiceSession;
                                CompileService.CallResult<Integer> callResult;
                                Intrinsics.checkNotNullParameter((Object)$this$leaseImpl, (String)"$this$leaseImpl");
                                $this$leaseImpl.registerClient(this.$clientAliveFlagFile$inlined.getAbsolutePath());
                                KotlinCompilerClientKt.report$default(this.$reportingTargets$inlined, DaemonReportCategory.DEBUG, "connected to the daemon", null, 4, null);
                                if (!this.$leaseSession$inlined) {
                                    return new CompileServiceSession($this$leaseImpl, CompileService.Companion.getNO_SESSION());
                                }
                                File file2 = this.$sessionAliveFlagFile$inlined;
                                CompileService.CallResult<Integer> it = callResult = $this$leaseImpl.leaseCompileSession(file2 != null ? file2.getAbsolutePath() : null);
                                boolean bl = false;
                                CompileService.CallResult<Integer> callResult2 = !(it instanceof CompileService.CallResult.Dying) ? callResult : null;
                                if (callResult2 != null) {
                                    it = callResult = callResult2;
                                    boolean bl2 = false;
                                    compileServiceSession = new CompileServiceSession($this$leaseImpl, ((Number)it.get()).intValue());
                                } else {
                                    compileServiceSession = null;
                                }
                                return compileServiceSession;
                            }
                        };
                        NetworkUtilsKt.ensureServerHostnameIsSetUp();
                        Pair<CompileService, DaemonJVMOptions> pair2 = INSTANCE.tryFindSuitableDaemonOrNewOpts(new File(daemonOptions.getRunFilesPath()), compilerId, daemonJVMOptions, (Function2<? super DaemonReportCategory, ? super String, Unit>)((Function2)new Function2<DaemonReportCategory, String, Unit>(clientAliveFlagFile, reportingTargets, leaseSession, sessionAliveFlagFile, daemonOptions, compilerId, daemonJVMOptions, autostart){
                            final /* synthetic */ File $clientAliveFlagFile$inlined;
                            final /* synthetic */ DaemonReportingTargets $reportingTargets$inlined;
                            final /* synthetic */ boolean $leaseSession$inlined;
                            final /* synthetic */ File $sessionAliveFlagFile$inlined;
                            final /* synthetic */ DaemonOptions $daemonOptions$inlined;
                            final /* synthetic */ CompilerId $compilerId$inlined;
                            final /* synthetic */ DaemonJVMOptions $daemonJVMOptions$inlined;
                            final /* synthetic */ boolean $autostart$inlined;
                            {
                                this.$clientAliveFlagFile$inlined = file2;
                                this.$reportingTargets$inlined = daemonReportingTargets;
                                this.$leaseSession$inlined = bl;
                                this.$sessionAliveFlagFile$inlined = file3;
                                this.$daemonOptions$inlined = daemonOptions;
                                this.$compilerId$inlined = compilerId;
                                this.$daemonJVMOptions$inlined = daemonJVMOptions;
                                this.$autostart$inlined = bl2;
                                super(2);
                            }

                            public final void invoke(@NotNull DaemonReportCategory cat, @NotNull String msg) {
                                Intrinsics.checkNotNullParameter((Object)((Object)cat), (String)"cat");
                                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                                KotlinCompilerClientKt.report$default(this.$reportingTargets$inlined, cat, msg, null, 4, null);
                            }
                        }));
                        CompileService compileService = (CompileService)pair2.component1();
                        DaemonJVMOptions newJVMOptions = (DaemonJVMOptions)pair2.component2();
                        if (service != null) {
                            compileServiceSession = $fun$leaseImpl$1.invoke((CompileService)service);
                        } else {
                            if (!isLastAttempt && autostart && INSTANCE.startDaemon(compilerId, newJVMOptions, daemonOptions, reportingTargets)) {
                                KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.DEBUG, "new daemon started, trying to find it", null, 4, null);
                            }
                            compileServiceSession = null;
                        }
                        pair = TuplesKt.to((Object)compileServiceSession, null);
                    }
                    catch (SocketException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    catch (ConnectException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    catch (ConnectIOException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    catch (UnmarshalException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    catch (RuntimeException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    Pair pair3 = pair;
                    Object object = pair3.component1();
                    Exception err$iv = (Exception)pair3.component2();
                    if (res$iv != null) {
                        void var15_17 = res$iv;
                        // MONITOREXIT @DISABLED, blocks:[1, 3, 10, 11] lbl53 : MonitorExitStatement: MONITOREXIT : var12_12
                        v1 = var15_17;
                        return v1;
                    }
                    if (err$iv == null) continue;
                    KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.INFO, (attempts$iv >= INSTANCE.getDAEMON_CONNECT_CYCLE_ATTEMPTS() || !autostart ? "no more retries on: " : "retrying(" + attempts$iv + ") on: ") + err$iv.toString(), null, 4, null);
                } while (attempts$iv++ <= INSTANCE.getDAEMON_CONNECT_CYCLE_ATTEMPTS() && autostart);
                Object var26_33 = null;
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl60 : MonitorExitStatement: MONITOREXIT : var12_12
                v1 = var26_33;
                return v1;
            }
            catch (Throwable e$iv) {
                KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.EXCEPTION, e$iv.toString(), null, 4, null);
                Object var27_34 = null;
                // MONITOREXIT @DISABLED, blocks:[3, 9] lbl66 : MonitorExitStatement: MONITOREXIT : var12_12
                v1 = var27_34;
                return v1;
            }
        }
    }

    public static /* synthetic */ CompileServiceSession connectAndLease$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, File file2, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, boolean bl2, File file3, int n, Object object) {
        if ((n & 0x80) != 0) {
            file3 = null;
        }
        return kotlinCompilerClient.connectAndLease(compilerId, file2, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl, bl2, file3);
    }

    public final void shutdownCompileService(@NotNull CompilerId compilerId, @NotNull DaemonOptions daemonOptions) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
            Intrinsics.checkNotNullParameter((Object)daemonOptions, (String)"daemonOptions");
            CompileService compileService = this.connectToCompileService(compilerId, new DaemonJVMOptions(null, null, null, null, 15, null), daemonOptions, new DaemonReportingTargets(System.out, null, null, null, 14, null), false, false);
            if (compileService == null) break block0;
            compileService.shutdown();
        }
    }

    public final void shutdownCompileService(@NotNull CompilerId compilerId) {
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        this.shutdownCompileService(compilerId, new DaemonOptions(null, 0L, 0, 0, 0L, 0L, false, false, 255, null));
    }

    public final int leaseCompileSession(@NotNull CompileService compilerService, @Nullable String aliveFlagPath) {
        Intrinsics.checkNotNullParameter((Object)compilerService, (String)"compilerService");
        return ((Number)compilerService.leaseCompileSession(aliveFlagPath).get()).intValue();
    }

    public final void releaseCompileSession(@NotNull CompileService compilerService, int sessionId) {
        Intrinsics.checkNotNullParameter((Object)compilerService, (String)"compilerService");
        compilerService.releaseCompileSession(sessionId);
    }

    /*
     * WARNING - void declaration
     */
    public final int compile(@NotNull CompileService compilerService, int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull MessageCollector messageCollector2, @Nullable Function2<? super File, ? super List<? extends File>, Unit> outputsCollector2, @NotNull CompilerMode compilerMode, @NotNull ReportSeverity reportSeverity, int port, @NotNull Profiler profiler) {
        void $this$withMeasure$iv;
        Intrinsics.checkNotNullParameter((Object)compilerService, (String)"compilerService");
        Intrinsics.checkNotNullParameter((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)messageCollector2, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)compilerMode, (String)"compilerMode");
        Intrinsics.checkNotNullParameter((Object)((Object)reportSeverity), (String)"reportSeverity");
        Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
        Profiler profiler2 = profiler;
        KotlinCompilerClient obj$iv = this;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(obj$iv);
        boolean bl = false;
        BasicCompilerServicesWithResultsFacadeServer services = new BasicCompilerServicesWithResultsFacadeServer(messageCollector2, outputsCollector2, port);
        int res$iv = ((Number)compilerService.compile(sessionId, args, new CompilationOptions(compilerMode, targetPlatform, new Integer[]{ReportCategory.COMPILER_MESSAGE.getCode(), ReportCategory.DAEMON_MESSAGE.getCode(), ReportCategory.EXCEPTION.getCode(), ReportCategory.OUTPUT_MESSAGE.getCode()}, reportSeverity.getCode(), new Integer[0], null, 32, null), services, null).get()).intValue();
        $this$withMeasure$iv.endMeasure(obj$iv, startState$iv);
        return res$iv;
    }

    public static /* synthetic */ int compile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, int n, CompileService.TargetPlatform targetPlatform, String[] stringArray, MessageCollector messageCollector2, Function2 function2, CompilerMode compilerMode, ReportSeverity reportSeverity, int n2, Profiler profiler, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            function2 = null;
        }
        if ((n3 & 0x40) != 0) {
            compilerMode = CompilerMode.NON_INCREMENTAL_COMPILER;
        }
        if ((n3 & 0x80) != 0) {
            reportSeverity = ReportSeverity.INFO;
        }
        if ((n3 & 0x100) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x200) != 0) {
            profiler = new DummyProfiler();
        }
        return kotlinCompilerClient.compile(compileService, n, targetPlatform, stringArray, messageCollector2, (Function2<? super File, ? super List<? extends File>, Unit>)function2, compilerMode, reportSeverity, n2, profiler);
    }

    private final ClientOptions configureClientOptions(ClientOptions opts) {
        String string2 = CompilerSystemProperties.COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY.getValue();
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            Iterable unrecognized = DaemonParamsKt.filterExtractProps$default(StringsKt.split$default((CharSequence)DaemonParamsKt.trimQuotes(it), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null), opts.getMappers(), "", null, 4, null);
            if (CollectionsKt.any((Iterable)unrecognized)) {
                throw (Throwable)new IllegalArgumentException("Unrecognized client options passed via property " + CompilerSystemProperties.COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY.getProperty() + ": " + CollectionsKt.joinToString$default((Iterable)unrecognized, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "\nSupported options: " + CollectionsKt.joinToString$default((Iterable)opts.getMappers(), (CharSequence)", ", null, null, (int)0, null, (Function1)configureClientOptions.1.1.INSTANCE, (int)30, null));
            }
        }
        return opts;
    }

    private final ClientOptions configureClientOptions() {
        return this.configureClientOptions(new ClientOptions(false, 1, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final void main(String ... args) {
        CompileService daemon;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        CompilerId compilerId = new CompilerId(null, null, 3, null);
        DaemonOptions daemonOptions = DaemonParamsKt.configureDaemonOptions();
        String[] stringArray = new String[]{};
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        DaemonJVMOptions daemonLaunchingOptions = DaemonParamsKt.configureDaemonJVMOptions(stringArray, bl3, bl2, bl);
        ClientOptions clientOptions = INSTANCE.configureClientOptions();
        Iterable<String> filteredArgs = DaemonParamsKt.filterExtractProps(ArraysKt.asIterable((Object[])args), new OptionsGroup[]{compilerId, daemonOptions, daemonLaunchingOptions, clientOptions}, "--daemon-");
        if (!clientOptions.getStop()) {
            if (CollectionsKt.none((Iterable)compilerId.getCompilerClasspath())) {
                System.err.println("compiler wasn't explicitly specified, attempt to find appropriate jar");
                List<String> list = INSTANCE.detectCompilerClasspath();
                if (list != null) {
                    List<String> list2;
                    List<String> it = list2 = list;
                    boolean bl4 = false;
                    compilerId.setCompilerClasspath(it);
                }
            }
            if (CollectionsKt.none((Iterable)compilerId.getCompilerClasspath())) {
                throw (Throwable)new IllegalArgumentException("Cannot find compiler jar");
            }
            StringBuilder stringBuilder = new StringBuilder().append("desired compiler classpath: ");
            Iterable iterable = compilerId.getCompilerClasspath();
            String string2 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"File.pathSeparator");
            String string3 = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null)).toString();
            System.out.println((Object)string3);
        }
        if ((daemon = INSTANCE.connectToCompileService(compilerId, daemonLaunchingOptions, daemonOptions, new DaemonReportingTargets(System.out, null, null, null, 14, null), !clientOptions.getStop(), !clientOptions.getStop())) == null) {
            if (!clientOptions.getStop()) throw (Throwable)new Exception("Unable to connect to daemon");
            System.err.println("No daemon found to shut down");
            return;
        }
        if (clientOptions.getStop()) {
            String it = "Shutdown the daemon";
            System.out.println((Object)it);
            daemon.shutdown();
            it = "Daemon shut down successfully";
            System.out.println((Object)it);
            return;
        }
        if (CollectionsKt.none(filteredArgs)) {
            String it = "Warning: empty arguments list, only daemon check is performed: checkCompilerId() returns " + daemon.checkCompilerId(compilerId);
            System.out.println((Object)it);
            return;
        }
        String it = "Executing daemon compilation with args: " + CollectionsKt.joinToString$default(filteredArgs, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        System.out.println((Object)it);
        MessageCollector messageCollector2 = new MessageCollector(){
            private boolean hasErrors;

            public final boolean getHasErrors() {
                return this.hasErrors;
            }

            public final void setHasErrors(boolean bl) {
                this.hasErrors = bl;
            }

            public void clear() {
            }

            public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageSourceLocation location) {
                Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                if (severity.isError()) {
                    this.hasErrors = true;
                }
                StringBuilder stringBuilder = new StringBuilder().append(severity.name()).append('\t');
                Object object = location;
                if (object == null || (object = object.getPath()) == null) {
                    object = "";
                }
                CompilerMessageSourceLocation compilerMessageSourceLocation = location;
                String string2 = stringBuilder.append((String)object).append(':').append(compilerMessageSourceLocation != null ? Integer.valueOf(compilerMessageSourceLocation.getLine()) : "").append(" \t").append(message).toString();
                System.out.println((Object)string2);
            }

            public boolean hasErrors() {
                return this.hasErrors;
            }
        };
        Function2 outputsCollector2 = main.outputsCollector.1.INSTANCE;
        BasicCompilerServicesWithResultsFacadeServer servicesFacade = new BasicCompilerServicesWithResultsFacadeServer(messageCollector2, outputsCollector2, 0, 4, null);
        try {
            long memBefore = ((Number)CompileService.getUsedMemory$default(daemon, false, 1, null).get()).longValue() / (long)1024;
            long startTime = System.nanoTime();
            CompilationOptions compilationOptions = new CompilationOptions(CompilerMode.NON_INCREMENTAL_COMPILER, CompileService.TargetPlatform.JVM, new Integer[]{ReportCategory.COMPILER_MESSAGE.getCode(), ReportCategory.DAEMON_MESSAGE.getCode(), ReportCategory.EXCEPTION.getCode(), ReportCategory.OUTPUT_MESSAGE.getCode()}, ReportSeverity.INFO.getCode(), new Integer[0], null, 32, null);
            Collection $this$toTypedArray$iv = CollectionsKt.toList(filteredArgs);
            boolean $i$f$toTypedArray = false;
            Object thisCollection$iv = $this$toTypedArray$iv;
            CompileService.CallResult<Integer> res2 = daemon.compile(CompileService.Companion.getNO_SESSION(), thisCollection$iv.toArray(new String[0]), compilationOptions, servicesFacade, null);
            long endTime = System.nanoTime();
            thisCollection$iv = "Compilation " + (res2.isGood() ? "succeeded" : "failed") + ", result code: " + ((Number)res2.get()).intValue();
            System.out.println(thisCollection$iv);
            long memAfter = ((Number)CompileService.getUsedMemory$default(daemon, false, 1, null).get()).longValue() / (long)1024;
            String string4 = "Compilation time: " + TimeUnit.NANOSECONDS.toMillis(endTime - startTime) + " ms";
            System.out.println((Object)string4);
            StringBuilder stringBuilder = new StringBuilder().append("Used memory ").append(memAfter).append(" (");
            string4 = "%+d";
            Object[] objectArray = new Object[]{memAfter - memBefore};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(this, *args)");
            string4 = stringBuilder.append(string5).append(" kb)").toString();
            System.out.println((Object)string4);
            return;
        }
        finally {
            UnicastRemoteObject.unexportObject(servicesFacade, true);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final List<String> detectCompilerClasspath() {
        Object object;
        void $this$mapNotNullTo$iv$iv;
        Object object2;
        Iterable $this$mapTo$iv$iv;
        String string2 = CompilerSystemProperties.JAVA_CLASS_PATH.getValue();
        Object object3 = string2;
        if (string2 == null) return null;
        CharSequence charSequence = (CharSequence)object3;
        String[] stringArray = new String[1];
        String string3 = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"File.pathSeparator");
        stringArray[0] = string3;
        List list = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        object3 = list;
        if (list == null) return null;
        Iterable $this$map$iv = (Iterable)object3;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file2 = new File((String)it).getParentFile();
            collection.add(file2);
        }
        List list2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        object3 = list2;
        if (list2 == null) return null;
        Iterable $this$mapNotNull$iv = (Iterable)object3;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object2 = $this$forEach$iv$iv$iv.iterator();
        while (object2.hasNext()) {
            File file3;
            File file4;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object2.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            File file5 = it;
            if (file5 != null && (file5 = FilesKt.walk$default((File)file5, null, (int)1, null)) != null) {
                Object v8;
                block5: {
                    void $this$firstOrNull$iv;
                    Sequence sequence2 = (Sequence)file5;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        File it2 = (File)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.equals((String)it2.getName(), (String)"kotlin-compiler.jar", (boolean)true)) continue;
                        v8 = element$iv;
                        break block5;
                    }
                    v8 = null;
                }
                file4 = v8;
            } else {
                file4 = null;
            }
            if (file4 == null) continue;
            File it$iv$iv = file3 = file4;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        File file6 = (File)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        object3 = file6;
        if (file6 == null) return null;
        Object it = object = object3;
        boolean bl = false;
        List list3 = CollectionsKt.listOf((Object)((File)it).getAbsolutePath());
        return list3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final <R> R connectLoop(DaemonReportingTargets reportingTargets, boolean autostart, Function1<? super Boolean, ? extends R> body2) {
        KotlinCompilerClient kotlinCompilerClient;
        int $i$f$connectLoop = 0;
        KotlinCompilerClient kotlinCompilerClient2 = kotlinCompilerClient = this;
        synchronized (kotlinCompilerClient2) {
            try {
                void var16_21;
                Exception err;
                boolean bl = false;
                int attempts = 1;
                while (true) {
                    void res2;
                    Pair pair;
                    try {
                        pair = TuplesKt.to((Object)body2.invoke((Object)(attempts >= INSTANCE.getDAEMON_CONNECT_CYCLE_ATTEMPTS() ? 1 : 0)), null);
                    }
                    catch (SocketException e) {
                        pair = TuplesKt.to(null, (Object)e);
                    }
                    catch (ConnectException e) {
                        pair = TuplesKt.to(null, (Object)e);
                    }
                    catch (ConnectIOException e) {
                        pair = TuplesKt.to(null, (Object)e);
                    }
                    catch (UnmarshalException e) {
                        pair = TuplesKt.to(null, (Object)e);
                    }
                    catch (RuntimeException e) {
                        pair = TuplesKt.to(null, (Object)e);
                    }
                    Pair pair2 = pair;
                    Object object = pair2.component1();
                    err = (Exception)pair2.component2();
                    if (res2 == null) break block16;
                    var16_21 = res2;
                    break;
                }
                {
                    catch (Throwable e) {
                        KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.EXCEPTION, e.toString(), null, 4, null);
                        R r = null;
                        InlineMarker.finallyStart((int)2);
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 6, 12] lbl55 : MonitorExitStatement: MONITOREXIT : var6_6
                        InlineMarker.finallyEnd((int)2);
                        return r;
                    }
                }
                {
                    block17: {
                        block16: {
                            InlineMarker.finallyStart((int)4);
                            // MONITOREXIT @DISABLED, blocks:[0, 6, 14] lbl36 : MonitorExitStatement: MONITOREXIT : var6_6
                            InlineMarker.finallyEnd((int)4);
                            return var16_21;
                        }
                        if (err != null) {
                            KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.INFO, (attempts >= INSTANCE.getDAEMON_CONNECT_CYCLE_ATTEMPTS() || !autostart ? "no more retries on: " : "retrying(" + attempts + ") on: ") + err.toString(), null, 4, null);
                        }
                        if (attempts++ <= INSTANCE.getDAEMON_CONNECT_CYCLE_ATTEMPTS() && autostart) break block17;
                        R r = null;
                        InlineMarker.finallyStart((int)3);
                        // MONITOREXIT @DISABLED, blocks:[0, 6, 14] lbl45 : MonitorExitStatement: MONITOREXIT : var6_6
                        InlineMarker.finallyEnd((int)3);
                        return r;
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                InlineMarker.finallyStart((int)1);
                // MONITOREXIT @DISABLED, blocks:[6, 13] lbl60 : MonitorExitStatement: MONITOREXIT : var6_6
                InlineMarker.finallyEnd((int)1);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Pair<CompileService, DaemonJVMOptions> tryFindSuitableDaemonOrNewOpts(File registryDir, CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, Function2<? super DaemonReportCategory, ? super String, Unit> report2) {
        void $this$fold$iv;
        Pair pair;
        List list;
        registryDir.mkdirs();
        File timestampMarker = Files.createTempFile(registryDir.toPath(), "kotlin-daemon-client-tsmarker", null, new FileAttribute[0]).toFile();
        try {
            File file2 = timestampMarker;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"timestampMarker");
            list = SequencesKt.toList((Sequence)ClientUtilsKt.walkDaemons$default(registryDir, compilerId, file2, null, report2, 8, null));
        }
        finally {
            timestampMarker.delete();
        }
        List aliveWithMetadata = list;
        Comparator comparator = new DaemonJVMOptionsMemoryComparator();
        comparator = new Comparator(comparator){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                DaemonWithMetadata it;
                Comparator comparator = this.$comparator;
                DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)a;
                Comparator comparator2 = comparator;
                boolean bl = false;
                DaemonJVMOptions daemonJVMOptions = it.getJvmOptions();
                it = (DaemonWithMetadata)b;
                bl = false;
                DaemonJVMOptions daemonJVMOptions2 = it.getJvmOptions();
                return comparator2.compare(daemonJVMOptions, daemonJVMOptions2);
            }
        };
        Object object = new FileAgeComparator();
        Comparator comparator2 = new Comparator(comparator, (Comparator)object){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ Comparator $comparator;
            {
                this.$this_thenBy = $receiver;
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    DaemonWithMetadata it;
                    Comparator comparator = this.$comparator;
                    DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)a;
                    Comparator comparator2 = comparator;
                    boolean bl = false;
                    File file2 = it.getRunFile();
                    it = (DaemonWithMetadata)b;
                    bl = false;
                    File file3 = it.getRunFile();
                    n = comparator2.compare(file2, file3);
                }
                return n;
            }
        };
        DaemonJVMOptions optsCopy = DaemonJVMOptions.copy$default(daemonJVMOptions, null, null, null, null, 15, null);
        Object object2 = (DaemonWithMetadata)CollectionsKt.maxWith((Iterable)aliveWithMetadata, (Comparator)comparator2);
        if (object2 != null) {
            Object it = object = object2;
            boolean bl = false;
            object2 = DaemonParamsKt.memorywiseFitsInto(daemonJVMOptions, ((DaemonWithMetadata)it).getJvmOptions()) ? object : null;
            if (object2 != null) {
                it = object = object2;
                boolean bl2 = false;
                pair = new Pair((Object)((DaemonWithMetadata)it).getDaemon(), (Object)DaemonParamsKt.updateMemoryUpperBounds(optsCopy, ((DaemonWithMetadata)it).getJvmOptions()));
                return pair;
            }
        }
        object = aliveWithMetadata;
        Object var17_15 = null;
        boolean $i$f$fold = false;
        DaemonJVMOptions accumulator$iv = optsCopy;
        Iterator iterator2 = $this$fold$iv.iterator();
        while (true) {
            void d;
            if (!iterator2.hasNext()) {
                DaemonJVMOptions daemonJVMOptions2;
                DaemonJVMOptions daemonJVMOptions3 = daemonJVMOptions2 = accumulator$iv;
                Object var20_23 = var17_15;
                pair = new Pair(var20_23, (Object)daemonJVMOptions3);
                return pair;
            }
            Object element$iv = iterator2.next();
            DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)element$iv;
            DaemonJVMOptions opts = accumulator$iv;
            boolean bl = false;
            accumulator$iv = DaemonParamsKt.updateMemoryUpperBounds(opts, d.getJvmOptions());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final boolean startDaemon(CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets reportingTargets) {
        javaExecutable = new File(new File(CompilerSystemProperties.JAVA_HOME.getSafeValue(), "bin"), "java");
        v0 = CompilerSystemProperties.JAVA_RMI_SERVER_HOSTNAME.getValue();
        if (v0 == null) {
            var7_6 = CompilerSystemProperties.JAVA_RMI_SERVER_HOSTNAME.getProperty() + " is not set!";
            throw new IllegalStateException(var7_6.toString());
        }
        serverHostname = v0;
        platformSpecificOptions = CollectionsKt.listOf((Object[])new String[]{"-Djava.awt.headless=true", "-D$" + CompilerSystemProperties.JAVA_RMI_SERVER_HOSTNAME.getProperty() + '=' + serverHostname});
        v1 = CompilerSystemProperties.JAVA_VERSION.getValue();
        javaVersion = v1 != null ? StringsKt.toIntOrNull((String)v1) : null;
        javaIllegalAccessWorkaround = javaVersion != null && javaVersion >= 16 ? CollectionsKt.listOf((Object[])new String[]{"--add-exports", "java.base/sun.nio.ch=ALL-UNNAMED"}) : CollectionsKt.emptyList();
        v2 = new String[3];
        v2[0] = javaExecutable.getAbsolutePath();
        v2[1] = "-cp";
        v3 = compilerId.getCompilerClasspath();
        v4 = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"File.pathSeparator");
        v2[2] = CollectionsKt.joinToString$default((Iterable)v3, (CharSequence)v4, null, null, (int)0, null, null, (int)62, null);
        var11_11 = daemonJVMOptions.getMappers();
        var23_12 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])v2), (Iterable)platformSpecificOptions);
        $i$f$flatMap = false;
        var13_15 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        var16_19 = $this$flatMapTo$iv$iv.iterator();
        while (var16_19.hasNext()) {
            element$iv$iv = var16_19.next();
            it = (PropMapper)element$iv$iv;
            $i$a$-flatMap-KotlinCompilerClient$startDaemon$args$1 = false;
            list$iv$iv = it.toArgs("-");
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        var24_29 = (List)destination$iv$iv;
        $this$flatMap$iv = daemonOptions.getMappers();
        var23_12 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)var23_12, (Iterable)var24_29), (Iterable)javaIllegalAccessWorkaround), (Object)"org.jetbrains.kotlin.daemon.KotlinCompileDaemon");
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        var16_19 = $this$flatMapTo$iv$iv.iterator();
        while (var16_19.hasNext()) {
            element$iv$iv = var16_19.next();
            it = (PropMapper)element$iv$iv;
            $i$a$-flatMap-KotlinCompilerClient$startDaemon$args$2 = false;
            list$iv$iv = it.toArgs("--daemon-");
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        var24_29 = (List)destination$iv$iv;
        $this$flatMap$iv = compilerId.getMappers();
        var23_12 = CollectionsKt.plus((Collection)var23_12, (Iterable)var24_29);
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        var16_19 = $this$flatMapTo$iv$iv.iterator();
        while (var16_19.hasNext()) {
            element$iv$iv = var16_19.next();
            it = (PropMapper)element$iv$iv;
            $i$a$-flatMap-KotlinCompilerClient$startDaemon$args$3 = false;
            list$iv$iv = it.toArgs("--daemon-");
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        var24_29 = (List)destination$iv$iv;
        args = CollectionsKt.plus((Collection)var23_12, (Iterable)var24_29);
        KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.DEBUG, "starting the daemon as: " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), null, 4, null);
        processBuilder = new ProcessBuilder(args);
        processBuilder.redirectErrorStream(true);
        $this$apply = $this$flatMapTo$iv$iv = new File(daemonOptions.getRunFilesPath());
        $i$a$-apply-KotlinCompilerClient$startDaemon$workingDir$1 = false;
        $this$apply.mkdirs();
        workingDir = $this$flatMapTo$iv$iv;
        processBuilder.directory((File)workingDir);
        daemon = NativePlatformUtilKt.launchProcessWithFallback(processBuilder, reportingTargets, "daemon client");
        isEchoRead = new Semaphore(1);
        isEchoRead.acquire();
        stdoutThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(daemon, reportingTargets, isEchoRead){
            final /* synthetic */ Process $daemon;
            final /* synthetic */ DaemonReportingTargets $reportingTargets;
            final /* synthetic */ Semaphore $isEchoRead;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    InputStream inputStream = this.$daemon.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"daemon.inputStream");
                    InputStream inputStream2 = inputStream;
                    Charset charset = Charsets.UTF_8;
                    TextStreamsKt.forEachLine((Reader)new InputStreamReader(inputStream2, charset), (Function1)((Function1)new Function1<String, Unit>(this){
                        final /* synthetic */ startDaemon.stdoutThread.1 this$0;

                        public final void invoke(@NotNull String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            Thread thread = Thread.currentThread();
                            Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"Thread.currentThread()");
                            if (thread.isInterrupted()) {
                                return;
                            }
                            if (Intrinsics.areEqual((Object)it, (Object)"Kotlin compile daemon is ready")) {
                                KotlinCompilerClientKt.report$default(this.this$0.$reportingTargets, DaemonReportCategory.DEBUG, "Received the message signalling that the daemon is ready", null, 4, null);
                                this.this$0.$isEchoRead.release();
                                return;
                            }
                            KotlinCompilerClientKt.report(this.this$0.$reportingTargets, DaemonReportCategory.INFO, it, "daemon");
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }));
                }
                catch (Throwable throwable) {
                }
                finally {
                    this.$daemon.getInputStream().close();
                    this.$daemon.getOutputStream().close();
                    this.$daemon.getErrorStream().close();
                    this.$isEchoRead.release();
                }
            }
            {
                this.$daemon = process;
                this.$reportingTargets = daemonReportingTargets;
                this.$isEchoRead = semaphore;
                super(0);
            }
        }), (int)31, null);
        try {
            v5 = CompilerSystemProperties.COMPILE_DAEMON_STARTUP_TIMEOUT_PROPERTY.getValue();
            if (v5 == null) ** GOTO lbl-1000
            it = list$iv$iv = v5;
            $i$a$-let-KotlinCompilerClient$startDaemon$daemonStartupTimeout$1 = false;
            try {
                var21_32 = it;
                var21_32 = Long.parseLong((String)var21_32);
            }
            catch (Exception e) {
                KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.INFO, "unable to interpret " + CompilerSystemProperties.COMPILE_DAEMON_STARTUP_TIMEOUT_PROPERTY.getProperty() + " property ('" + (String)it + "'); using default timeout " + KotlinCompilerClient.DAEMON_DEFAULT_STARTUP_TIMEOUT_MS + " ms", null, 4, null);
                var21_32 = null;
            }
            if ((v5 = var21_32) != null) {
                v6 = v5.longValue();
            } else lbl-1000:
            // 2 sources

            {
                v6 = KotlinCompilerClient.DAEMON_DEFAULT_STARTUP_TIMEOUT_MS;
            }
            daemonStartupTimeout = v6;
            list$iv$iv = daemonOptions.getRunFilesPath();
            if (list$iv$iv.length() > 0) {
                succeeded = isEchoRead.tryAcquire(daemonStartupTimeout, TimeUnit.MILLISECONDS);
                if (!KotlinCompilerClientKt.isProcessAlive(daemon)) {
                    KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.INFO, "Daemon terminated unexpectedly with error code: " + daemon.exitValue(), null, 4, null);
                    v7 = false;
                } else if (!succeeded) {
                    KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.INFO, "Unable to get response from daemon in " + daemonStartupTimeout + " ms", null, 4, null);
                    v7 = false;
                } else {
                    v7 = true;
                }
                var19_28 = v7;
                return var19_28;
            }
            Thread.sleep(daemonStartupTimeout);
            var18_25 = true;
            return var18_25;
        }
        finally {
            block18: {
                if (stdoutThread.isAlive()) {
                    stdoutThread.interrupt();
                }
                v8 = reportingTargets.getOut();
                if (v8 == null) break block18;
                v8.flush();
            }
        }
    }

    private KotlinCompilerClient() {
    }

    static {
        KotlinCompilerClient kotlinCompilerClient;
        INSTANCE = kotlinCompilerClient = new KotlinCompilerClient();
        DAEMON_DEFAULT_STARTUP_TIMEOUT_MS = 10000L;
        DAEMON_CONNECT_CYCLE_ATTEMPTS = 3;
        verboseReporting = CompilerSystemProperties.COMPILE_DAEMON_VERBOSE_REPORT_PROPERTY.getValue() != null;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R&\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0004\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$ClientOptions;", "Lorg/jetbrains/kotlin/daemon/common/OptionsGroup;", "stop", "", "(Z)V", "mappers", "", "Lorg/jetbrains/kotlin/daemon/common/PropMapper;", "getMappers", "()Ljava/util/List;", "getStop", "()Z", "setStop", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "kotlin-daemon-client"})
    public static final class ClientOptions
    implements OptionsGroup {
        private boolean stop;

        @Override
        @NotNull
        public List<PropMapper<?, ?, ?>> getMappers() {
            return CollectionsKt.listOf(new BoolPropMapper(this, KotlinCompilerClient$ClientOptions$mappers$1.INSTANCE, null, 4, null));
        }

        public final boolean getStop() {
            return this.stop;
        }

        public final void setStop(boolean bl) {
            this.stop = bl;
        }

        public ClientOptions(boolean stop) {
            this.stop = stop;
        }

        public /* synthetic */ ClientOptions(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public ClientOptions() {
            this(false, 1, null);
        }

        public final boolean component1() {
            return this.stop;
        }

        @NotNull
        public final ClientOptions copy(boolean stop) {
            return new ClientOptions(stop);
        }

        public static /* synthetic */ ClientOptions copy$default(ClientOptions clientOptions, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = clientOptions.stop;
            }
            return clientOptions.copy(bl);
        }

        @NotNull
        public String toString() {
            return "ClientOptions(stop=" + this.stop + ")";
        }

        public int hashCode() {
            int n = this.stop ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return n;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ClientOptions)) break block3;
                    ClientOptions clientOptions = (ClientOptions)object;
                    if (this.stop != clientOptions.stop) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

