/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.util.artifact;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.artifact.ArtifactType;
import org.sonatype.aether.util.artifact.AbstractArtifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultArtifact
extends AbstractArtifact {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;
    private final String extension;
    private final File file;
    private final Map<String, String> properties;
    private String baseVersion;

    public DefaultArtifact(String coords) {
        this(coords, Collections.emptyMap());
    }

    public DefaultArtifact(String coords, Map<String, String> properties) {
        Pattern p = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?:([^: ]+)");
        Matcher m = p.matcher(coords);
        if (!m.matches()) {
            throw new IllegalArgumentException("Bad artifact coordinates, expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]]:<version>");
        }
        this.groupId = m.group(1);
        this.artifactId = m.group(2);
        this.extension = DefaultArtifact.get(m.group(4), "jar");
        this.classifier = DefaultArtifact.get(m.group(6), "");
        this.version = m.group(7);
        this.file = null;
        this.properties = properties != null && !properties.isEmpty() ? new HashMap<String, String>(properties) : Collections.emptyMap();
    }

    private static String get(String value, String defaultValue) {
        return value == null || value.length() <= 0 ? defaultValue : value;
    }

    public DefaultArtifact(String groupId, String artifactId, String extension, String version) {
        this(groupId, artifactId, "", extension, version);
    }

    public DefaultArtifact(String groupId, String artifactId, String classifier, String extension, String version) {
        this(groupId, artifactId, classifier, extension, version, null, (File)null);
    }

    public DefaultArtifact(String groupId, String artifactId, String classifier, String extension, String version, ArtifactType type) {
        this(groupId, artifactId, classifier, extension, version, null, type);
    }

    public DefaultArtifact(String groupId, String artifactId, String classifier, String extension, String version, Map<String, String> properties, ArtifactType type) {
        this.groupId = DefaultArtifact.emptify(groupId);
        this.artifactId = DefaultArtifact.emptify(artifactId);
        this.classifier = classifier != null || type == null ? DefaultArtifact.emptify(classifier) : DefaultArtifact.emptify(type.getClassifier());
        this.extension = extension != null || type == null ? DefaultArtifact.emptify(extension) : DefaultArtifact.emptify(type.getExtension());
        this.version = DefaultArtifact.emptify(version);
        this.file = null;
        this.properties = DefaultArtifact.merge(properties, type != null ? type.getProperties() : null);
    }

    private static Map<String, String> merge(Map<String, String> dominant, Map<String, String> recessive) {
        Map<String, String> properties;
        if ((dominant == null || dominant.isEmpty()) && (recessive == null || recessive.isEmpty())) {
            properties = Collections.emptyMap();
        } else {
            properties = new HashMap();
            if (recessive != null) {
                properties.putAll(recessive);
            }
            if (dominant != null) {
                properties.putAll(dominant);
            }
        }
        return properties;
    }

    public DefaultArtifact(String groupId, String artifactId, String classifier, String extension, String version, Map<String, String> properties, File file) {
        this.groupId = DefaultArtifact.emptify(groupId);
        this.artifactId = DefaultArtifact.emptify(artifactId);
        this.classifier = DefaultArtifact.emptify(classifier);
        this.extension = DefaultArtifact.emptify(extension);
        this.version = DefaultArtifact.emptify(version);
        this.file = file;
        this.properties = properties != null && !properties.isEmpty() ? new HashMap<String, String>(properties) : Collections.emptyMap();
    }

    DefaultArtifact(String groupId, String artifactId, String classifier, String extension, String version, File file, Map<String, String> properties) {
        this.groupId = DefaultArtifact.emptify(groupId);
        this.artifactId = DefaultArtifact.emptify(artifactId);
        this.classifier = DefaultArtifact.emptify(classifier);
        this.extension = DefaultArtifact.emptify(extension);
        this.version = DefaultArtifact.emptify(version);
        this.file = file;
        this.properties = properties;
    }

    private static String emptify(String str) {
        return str == null ? "" : str;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getBaseVersion() {
        if (this.baseVersion == null) {
            this.baseVersion = DefaultArtifact.toBaseVersion(this.getVersion());
        }
        return this.baseVersion;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Artifact setVersion(String version) {
        if (this.version.equals(version) || version == null && this.version.length() <= 0) {
            return this;
        }
        return new DefaultArtifact(this.groupId, this.artifactId, this.classifier, this.extension, version, this.file, this.properties);
    }

    @Override
    public boolean isSnapshot() {
        return DefaultArtifact.isSnapshot(this.getVersion());
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public Artifact setFile(File file) {
        if (this.file == null ? file == null : this.file.equals(file)) {
            return this;
        }
        return new DefaultArtifact(this.groupId, this.artifactId, this.classifier, this.extension, this.version, file, this.properties);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.properties.get(key);
        return value != null ? value : defaultValue;
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public Artifact setProperties(Map<String, String> properties) {
        if (((Object)this.properties).equals(properties) || properties == null && this.properties.isEmpty()) {
            return this;
        }
        return new DefaultArtifact(this.groupId, this.artifactId, this.classifier, this.extension, this.version, properties, this.file);
    }
}

