/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@com.intellij.openapi.components.State(name="MarkdownDocumentLinksSafeState", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0001\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/settings/DocumentLinksSafeState;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lorg/intellij/plugins/markdown/settings/DocumentLinksSafeState$State;", "()V", "allowProtocol", "", "protocol", "", "isProtocolAllowed", "", "Companion", "State", "intellij.markdown.core"})
public final class DocumentLinksSafeState
extends SimplePersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<String> httpSchemes;

    public DocumentLinksSafeState() {
        super((BaseState)new State());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isProtocolAllowed(@NotNull String protocol) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        if (Companion.isHttpScheme(protocol)) return true;
        if (Companion.isFileProtocol(protocol)) return true;
        Set<String> set = ((State)this.getState()).getAllowedProtocols();
        String string = protocol.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (!set.contains(string)) return false;
        return true;
    }

    public final void allowProtocol(@NotNull String protocol) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        State state = (State)this.getState();
        String string = protocol.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        state.addProtocol(string);
    }

    @JvmStatic
    @NotNull
    public static final DocumentLinksSafeState getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    static {
        Object[] objectArray = new String[]{"http", "https"};
        httpSchemes = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/settings/DocumentLinksSafeState$Companion;", "", "()V", "httpSchemes", "", "", "getInstance", "Lorg/intellij/plugins/markdown/settings/DocumentLinksSafeState;", "project", "Lcom/intellij/openapi/project/Project;", "isFileProtocol", "", "scheme", "isHttpScheme", "intellij.markdown.core"})
    @SourceDebugExtension(value={"SMAP\nDocumentLinksSafeState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentLinksSafeState.kt\norg/intellij/plugins/markdown/settings/DocumentLinksSafeState$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,47:1\n30#2,3:48\n*S KotlinDebug\n*F\n+ 1 DocumentLinksSafeState.kt\norg/intellij/plugins/markdown/settings/DocumentLinksSafeState$Companion\n*L\n43#1:48,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isHttpScheme(@NotNull String scheme) {
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            Set set = httpSchemes;
            String string = scheme.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return set.contains(string);
        }

        public final boolean isFileProtocol(@NotNull String scheme) {
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            String string = scheme.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return Intrinsics.areEqual((Object)string, (Object)"file");
        }

        @JvmStatic
        @NotNull
        public final DocumentLinksSafeState getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DocumentLinksSafeState> serviceClass$iv = DocumentLinksSafeState.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (DocumentLinksSafeState)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/settings/DocumentLinksSafeState$State;", "Lcom/intellij/openapi/components/BaseState;", "()V", "allowedProtocols", "", "", "getAllowedProtocols", "()Ljava/util/Set;", "allowedProtocols$delegate", "Lkotlin/properties/ReadWriteProperty;", "addProtocol", "", "protocol", "intellij.markdown.core"})
    @ApiStatus.Internal
    public static final class State
    extends BaseState {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty allowedProtocols$delegate = this.stringSet().provideDelegate((Object)this, $$delegatedProperties[0]);

        @XCollection(propertyElementName="allowed-protocols", elementName="protocol", valueAttributeName="value")
        @NotNull
        public final Set<String> getAllowedProtocols() {
            return (Set)this.allowedProtocols$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void addProtocol(@NotNull String protocol) {
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            this.getAllowedProtocols().add(protocol);
            this.incrementModificationCount();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(State.class, "allowedProtocols", "getAllowedProtocols()Ljava/util/Set;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

