/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.types;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.BaseIrTypeSubstitutor;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeSubstitutor;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\u0018\u00002\u00020\u0001B-\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB#\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u000b\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/ir/types/IrTypeSubstitutor;", "Lorg/jetbrains/kotlin/ir/types/BaseIrTypeSubstitutor;", "typeParameters", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "typeArguments", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "allowEmptySubstitution", "", "(Ljava/util/List;Ljava/util/List;Z)V", "substitution", "", "(Ljava/util/Map;Z)V", "getSubstitutionArgument", "typeParameter", "isEmptySubstitution", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nIrTypeSubstitutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrTypeSubstitutor.kt\norg/jetbrains/kotlin/ir/types/IrTypeSubstitutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1#2:122\n*E\n"})
public final class IrTypeSubstitutor
extends BaseIrTypeSubstitutor {
    @NotNull
    private final Map<IrTypeParameterSymbol, IrTypeArgument> substitution;
    private final boolean allowEmptySubstitution;

    public IrTypeSubstitutor(@NotNull Map<IrTypeParameterSymbol, ? extends IrTypeArgument> substitution, boolean allowEmptySubstitution) {
        Intrinsics.checkNotNullParameter(substitution, (String)"substitution");
        this.substitution = substitution;
        this.allowEmptySubstitution = allowEmptySubstitution;
    }

    public /* synthetic */ IrTypeSubstitutor(Map map, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(map, bl);
    }

    public IrTypeSubstitutor(@NotNull List<? extends IrTypeParameterSymbol> typeParameters2, @NotNull List<? extends IrTypeArgument> typeArguments, boolean allowEmptySubstitution) {
        Intrinsics.checkNotNullParameter(typeParameters2, (String)"typeParameters");
        Intrinsics.checkNotNullParameter(typeArguments, (String)"typeArguments");
        this(MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)typeParameters2, (Iterable)typeArguments)), allowEmptySubstitution);
        if (!(typeParameters2.size() == typeArguments.size())) {
            boolean bl = false;
            String string = "Unexpected number of type arguments: " + typeArguments.size() + "\nType parameters are:\n" + CollectionsKt.joinToString$default((Iterable)typeParameters2, (CharSequence)"\n", null, null, (int)0, null, (Function1)1.1.INSTANCE, (int)30, null) + "Type arguments are:\n" + CollectionsKt.joinToString$default((Iterable)typeArguments, (CharSequence)"\n", null, null, (int)0, null, (Function1)1.2.INSTANCE, (int)30, null);
            throw new IllegalStateException(string.toString());
        }
    }

    public /* synthetic */ IrTypeSubstitutor(List list, List list2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(list, list2, bl);
    }

    @Override
    @NotNull
    public IrTypeArgument getSubstitutionArgument(@NotNull IrTypeParameterSymbol typeParameter) {
        Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"typeParameter");
        IrTypeArgument irTypeArgument = this.substitution.get(typeParameter);
        if (irTypeArgument == null) {
            IrTypeParameterSymbol irTypeParameterSymbol;
            IrTypeParameterSymbol it = irTypeParameterSymbol = typeParameter;
            boolean bl = false;
            Object object = this.allowEmptySubstitution ? irTypeParameterSymbol : null;
            IrSimpleType irSimpleType = object != null && (object = (IrTypeParameter)object.getOwner()) != null ? IrTypesKt.getDefaultType((IrTypeParameter)object) : null;
            if (irSimpleType != null) {
                irTypeArgument = irSimpleType;
            } else {
                throw new IllegalStateException(("Unsubstituted type parameter: " + RenderIrElementKt.render$default(typeParameter.getOwner(), null, 1, null)).toString());
            }
        }
        return irTypeArgument;
    }

    @Override
    public boolean isEmptySubstitution() {
        return this.substitution.isEmpty();
    }
}

