/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.data.Key;
import com.intellij.rt.coverage.instrumentation.util.SaveLabelsMethodNode;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Opcodes;
import org.jetbrains.coverage.org.objectweb.asm.tree.MethodNode;

public class CoverageEnumerator
extends MethodVisitor
implements Opcodes {
    private final MethodNode myMethodNode;
    protected final InstrumentationData myData;
    private final String myMethodDesc;
    private final boolean myBranchCoverage;
    protected int myCurrentLine;

    /*
     * WARNING - void declaration
     */
    public CoverageEnumerator(InstrumentationData data, boolean branchCoverage) {
        super(589824, new SaveLabelsMethodNode(data.getMethodAccess(), data.getMethodName(), data.getMethodDesc(), data.get(Key.METHOD_SIGNATURE), data.get(Key.EXCEPTIONS)));
        void var2_2;
        void var1_1;
        this.myMethodNode = (MethodNode)this.mv;
        this.myData = data;
        ProjectData projectData = this.myData.get(Key.PROJECT_DATA);
        this.myMethodDesc = var1_1.getFromPool(this.myData.getMethodName() + this.myData.getMethodDesc());
        this.myBranchCoverage = var2_2;
    }

    protected void onNewJump(Label originalLabel, Label trueLabel, Label falseLabel) {
    }

    protected void onNewSwitch(SwitchLabels original, SwitchLabels replacement) {
    }

    /*
     * WARNING - void declaration
     */
    public void accept(MethodVisitor visitor) {
        void var1_1;
        this.myMethodNode.accept((MethodVisitor)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void visitLineNumber(int line, Label start) {
        void var2_2;
        void var1_1;
        this.myCurrentLine = line;
        this.myData.createLineData(line, this.myMethodDesc);
        super.visitLineNumber((int)var1_1, (Label)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void visitJumpInsn(int opcode, Label label) {
        void var3_3;
        LineData lineData;
        if (this.myData.hasNoLinesInCurrentMethod() || !this.myBranchCoverage) {
            super.visitJumpInsn(opcode, label);
            return;
        }
        boolean jumpInstrumented = false;
        if (opcode != 167 && opcode != 168 && (lineData = this.myData.getLineData(this.myCurrentLine)) != null) {
            Label trueLabel = new Label();
            Label falseLabel = new Label();
            this.myData.addJump(lineData, trueLabel, falseLabel);
            this.onNewJump(label, trueLabel, falseLabel);
            jumpInstrumented = true;
            super.visitJumpInsn(opcode, trueLabel);
            super.visitJumpInsn(167, falseLabel);
            super.visitLabel(trueLabel);
            super.visitJumpInsn(167, label);
            super.visitLabel(falseLabel);
        }
        if (var3_3 == false) {
            void var2_2;
            void var1_1;
            super.visitJumpInsn((int)var1_1, (Label)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private SwitchLabels replaceLabels(SwitchLabels original, LineData lineData, int[] keys) {
        void var1_1;
        void var3_4;
        Label beforeSwitchLabel = new Label();
        Label newDefaultLabel = new Label();
        Label[] newLabels = new Label[original.getLabels().length];
        for (int i = 0; i < original.getLabels().length; ++i) {
            newLabels[i] = new Label();
        }
        super.visitJumpInsn(167, beforeSwitchLabel);
        SwitchLabels replacement = new SwitchLabels(newDefaultLabel, newLabels);
        this.myData.addSwitch(lineData, (int[])var3_4, newDefaultLabel, newLabels);
        this.onNewSwitch(original, replacement);
        for (int i = 0; i < newLabels.length; ++i) {
            super.visitLabel(newLabels[i]);
            super.visitJumpInsn(167, original.getLabels()[i]);
        }
        super.visitLabel(newDefaultLabel);
        super.visitJumpInsn(167, var1_1.getDefault());
        super.visitLabel(beforeSwitchLabel);
        return replacement;
    }

    /*
     * WARNING - void declaration
     */
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        void var1_1;
        void var2_2;
        void var3_3;
        if (this.myData.hasNoLinesInCurrentMethod() || !this.myBranchCoverage) {
            super.visitLookupSwitchInsn(dflt, keys, labels);
            return;
        }
        SwitchLabels switchLabels = this.visitSwitch(dflt, (Label[])var3_3, keys);
        super.visitLookupSwitchInsn(switchLabels.getDefault(), (int[])var2_2, var1_1.getLabels());
    }

    /*
     * WARNING - void declaration
     */
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.myData.hasNoLinesInCurrentMethod() || !this.myBranchCoverage) {
            super.visitTableSwitchInsn(min, max, dflt, labels);
            return;
        }
        SwitchLabels switchLabels = this.visitSwitch(dflt, labels, CoverageEnumerator.asLookupKeys(min, max));
        super.visitTableSwitchInsn((int)var1_1, (int)var2_2, switchLabels.getDefault(), var3_3.getLabels());
    }

    /*
     * WARNING - void declaration
     */
    private SwitchLabels visitSwitch(Label dflt, Label[] labels, int[] keys) {
        void var1_1;
        SwitchLabels switchLabels = new SwitchLabels(dflt, labels);
        LineData lineData = this.myData.getLineData(this.myCurrentLine);
        if (lineData != null) {
            void var3_3;
            void var2_2;
            switchLabels = this.replaceLabels(switchLabels, (LineData)var2_2, (int[])var3_3);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static int[] asLookupKeys(int min, int max) {
        void var2_2;
        int[] keys = new int[max - min + 1];
        for (int i = min; min <= i && i <= max; ++i) {
            keys[i - min] = i;
        }
        return var2_2;
    }

    protected static class SwitchLabels {
        private final Label myDefault;
        private final Label[] myLabels;

        /*
         * WARNING - void declaration
         */
        private SwitchLabels(Label dflt, Label[] labels) {
            void var2_2;
            void var1_1;
            this.myDefault = var1_1;
            this.myLabels = var2_2;
        }

        public Label getDefault() {
            return this.myDefault;
        }

        public Label[] getLabels() {
            return this.myLabels;
        }
    }
}

