/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.data.Key;
import com.intellij.rt.coverage.instrumentation.dataAccess.CoverageDataAccess;
import com.intellij.rt.coverage.instrumentation.filters.FilterUtils;
import com.intellij.rt.coverage.instrumentation.filters.classFilter.ClassFilter;
import com.intellij.rt.coverage.instrumentation.filters.classes.ClassSignatureFilter;
import com.intellij.rt.coverage.instrumentation.testTracking.TestTrackingMode;
import com.intellij.rt.coverage.util.ClassNameUtil;
import java.util.List;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;

public class InstrumentationStrategy {
    private static final List<ClassSignatureFilter> ourFilters = FilterUtils.createClassSignatureFilters();

    /*
     * WARNING - void declaration
     */
    static ClassVisitor createInstrumenter(ProjectData projectData, String className, ClassReader cr, ClassVisitor cw2, TestTrackingMode testTrackingMode, boolean branchCoverage, boolean shouldSaveSource, CoverageDataAccess dataAccess) {
        void var3_5;
        ClassVisitor cw2;
        void var1_3;
        void var2_4;
        for (ClassSignatureFilter classSignatureFilter : ourFilters) {
            if (!classSignatureFilter.shouldFilter((ClassReader)cr, projectData)) continue;
            return null;
        }
        InstrumentationData data = new InstrumentationData(projectData);
        data.put(Key.PROJECT_DATA, projectData);
        data.put(Key.CLASS_READER, var2_4);
        data.put(Key.CLASS_NAME, className);
        data.put(Key.CLASS_INTERNAL_NAME, ClassNameUtil.convertToInternalName((String)var1_3));
        if (testTrackingMode != null) {
            cw2 = testTrackingMode.createInstrumenter(cw2, data);
        }
        cw2 = new Instrumenter(cw2, (CoverageDataAccess)dataAccess, data, projectData, (boolean)branchCoverage, (boolean)shouldSaveSource);
        for (ClassFilter cv : FilterUtils.createClassFilters()) {
            void var0_2;
            if (!cv.isApplicable(data)) continue;
            cv.initFilter(cw2, data);
            cw2 = var0_2;
        }
        return var3_5;
    }
}

