/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.turboComplete.features.kind;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.ml.ContextFeatures;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.platform.ml.impl.turboComplete.CompletionKind;
import com.intellij.turboComplete.analysis.usage.CombinedKindUsageStatistics;
import com.intellij.turboComplete.analysis.usage.KindVarietyUsageTracker;
import com.intellij.turboComplete.features.kind.KindFeatureProvider;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/turboComplete/features/kind/KindUsageFeatures;", "Lcom/intellij/turboComplete/features/kind/KindFeatureProvider;", "()V", "calculateFeatures", "", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "kind", "Lcom/intellij/platform/ml/impl/turboComplete/CompletionKind;", "location", "Lcom/intellij/codeInsight/completion/CompletionLocation;", "contextFeatures", "Lcom/intellij/codeInsight/completion/ml/ContextFeatures;", "getName", "intellij.turboComplete"})
@SourceDebugExtension(value={"SMAP\nKindUsageFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KindUsageFeatures.kt\ncom/intellij/turboComplete/features/kind/KindUsageFeatures\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,24:1\n43#2,3:25\n*S KotlinDebug\n*F\n+ 1 KindUsageFeatures.kt\ncom/intellij/turboComplete/features/kind/KindUsageFeatures\n*L\n16#1:25,3\n*E\n"})
public final class KindUsageFeatures
implements KindFeatureProvider {
    @Override
    @NotNull
    public String getName() {
        return "usage";
    }

    @Override
    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull CompletionKind kind, @NotNull CompletionLocation location, @NotNull ContextFeatures contextFeatures) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)contextFeatures, (String)"contextFeatures");
        boolean $i$f$service = false;
        Class<KindVarietyUsageTracker> serviceClass$iv = KindVarietyUsageTracker.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        KindVarietyUsageTracker usageTracker = (KindVarietyUsageTracker)object;
        CombinedKindUsageStatistics usage = usageTracker.kindStatistics(kind);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"correct_prob", (Object)MLFeatureValue.Companion.float(((Number)usage.getRecentProbGenerateCorrect().getValue()).doubleValue())), TuplesKt.to((Object)"correct_in_row", (Object)MLFeatureValue.Companion.numerical(usage.getGeneratedInRow().getCorrect())), TuplesKt.to((Object)"incorrect_in_row", (Object)MLFeatureValue.Companion.numerical(usage.getGeneratedInRow().getNotCorrect()))};
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }
}

