/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.diagnostics;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.util.ApplicationKt;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.jetbrains.rd.platform.diagnostics.LogTraceCategoriesListener;
import com.jetbrains.rd.platform.diagnostics.LogTraceScenario;
import com.jetbrains.rd.platform.diagnostics.LogTraceScenariosRegistrySpecial;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bJ\u0010\u0010\u0010\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u000eH\u0002J\u0014\u0010\u0014\u001a\u00020\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bR.\u0010\u0003\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004j\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry;", "", "()V", "categoriesOldLevels", "Ljava/util/HashMap;", "Ljava/util/logging/Logger;", "Ljava/util/logging/Level;", "Lkotlin/collections/HashMap;", "syncAlarm", "Lcom/intellij/util/SingleAlarm;", "enabledScenarios", "", "Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenario;", "save", "", "", "synchronizeToLogger", "immediately", "", "synchronizeToLoggerImmediately", "updateTraceCategories", "traceCategories", "Companion", "HolderEpBean", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nLogTraceScenarioRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogTraceScenarioRegistry.kt\ncom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,182:1\n1603#2,9:183\n1855#2:192\n288#2,2:193\n1856#2:196\n1612#2:197\n1360#2:198\n1446#2,5:199\n1#3:195\n10#4:204\n*S KotlinDebug\n*F\n+ 1 LogTraceScenarioRegistry.kt\ncom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry\n*L\n59#1:183,9\n59#1:192\n59#1:193,2\n59#1:196\n59#1:197\n80#1:198\n80#1:199,5\n59#1:195\n25#1:204\n*E\n"})
public final class LogTraceScenariosRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SingleAlarm syncAlarm = new SingleAlarm(() -> LogTraceScenariosRegistry.syncAlarm$lambda$0(this), 100);
    @NotNull
    private final HashMap<Logger, Level> categoriesOldLevels = new HashMap();
    @NotNull
    private static final ExtensionPointName<HolderEpBean> HOLDER_EP_NAME = ExtensionPointName.Companion.create("com.intellij.rd.platform.traceScenarioHolder");
    @NotNull
    private static final ExtensionPointName<LogTraceCategoriesListener> TRACE_CATEGORIES_LISTENER_EP_NAME = new ExtensionPointName("com.intellij.rd.platform.logTraceCategoriesListener");
    @NotNull
    private static final com.intellij.openapi.diagnostic.Logger logger;
    @NotNull
    private static final ConcurrentList<LogTraceScenario> allValues;
    @NotNull
    private static final String TRACE_SCENARIOS_KEY = "rider.trace.scenarios";
    @NotNull
    private static final String TRACE_SCENARIOS_REGISTRY_KEY = "rd.forced.trace.scenarios";
    @NotNull
    private static final String delimiter = ",";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LogTraceScenario> enabledScenarios() {
        void $this$mapNotNullTo$iv$iv;
        String[] stringArray = new String[]{delimiter};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)(System.getProperty(TRACE_SCENARIOS_REGISTRY_KEY, "") + delimiter + PropertiesComponent.getInstance().getValue(TRACE_SCENARIOS_KEY, "")), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            LogTraceScenario it$iv$iv;
            Object v0;
            block2: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String name = (String)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$firstOrNull$iv = (Iterable)allValues;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    LogTraceScenario it = (LogTraceScenario)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            if ((LogTraceScenario)v0 == null) continue;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
    }

    public final void save(@NotNull List<String> enabledScenarios) {
        Intrinsics.checkNotNullParameter(enabledScenarios, (String)"enabledScenarios");
        String newEnabledScenarios = CollectionsKt.joinToString$default((Iterable)enabledScenarios, (CharSequence)delimiter, null, null, (int)0, null, null, (int)62, null);
        PropertiesComponent.getInstance().setValue(TRACE_SCENARIOS_KEY, newEnabledScenarios);
        this.synchronizeToLogger(true);
    }

    public final void synchronizeToLogger(boolean immediately) {
        if (immediately) {
            this.syncAlarm.cancelAllRequests();
            this.synchronizeToLoggerImmediately();
        } else {
            SingleAlarm.request$default((SingleAlarm)this.syncAlarm, (boolean)false, (int)0, (int)3, null);
        }
    }

    public static /* synthetic */ void synchronizeToLogger$default(LogTraceScenariosRegistry logTraceScenariosRegistry, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        logTraceScenariosRegistry.synchronizeToLogger(bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void synchronizeToLoggerImmediately() {
        Logger logger;
        void $this$flatMapTo$iv$iv;
        List<LogTraceScenario> enabledScenarios = this.enabledScenarios();
        Iterable $this$flatMap$iv = enabledScenarios;
        boolean $i$f$flatMap2 = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            LogTraceScenario it = (LogTraceScenario)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getCategories();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List traceCategories = CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
        this.updateTraceCategories(traceCategories);
        for (Map.Entry<Logger, Level> $i$f$flatMap2 : this.categoriesOldLevels.entrySet()) {
            Intrinsics.checkNotNull($i$f$flatMap2);
            logger = $i$f$flatMap2.getKey();
            Level level = $i$f$flatMap2.getValue();
            logger.setLevel(level);
        }
        this.categoriesOldLevels.clear();
        for (String category : traceCategories) {
            logger = Logger.getLogger(category);
            Map map = this.categoriesOldLevels;
            Intrinsics.checkNotNull((Object)logger);
            map.put(logger, logger.getLevel());
            logger.setLevel(Level.FINER);
        }
    }

    public final void updateTraceCategories(@NotNull List<String> traceCategories) {
        block1: {
            Intrinsics.checkNotNullParameter(traceCategories, (String)"traceCategories");
            for (LogTraceCategoriesListener listener2 : (LogTraceCategoriesListener[])TRACE_CATEGORIES_LISTENER_EP_NAME.getExtensions()) {
                listener2.traceCategoriesUpdated(traceCategories);
            }
            LogTraceScenariosRegistrySpecial logTraceScenariosRegistrySpecial = (LogTraceScenariosRegistrySpecial)ApplicationKt.getApplication().getService(LogTraceScenariosRegistrySpecial.class);
            if (logTraceScenariosRegistrySpecial == null) break block1;
            logTraceScenariosRegistrySpecial.traceCategoriesUpdated(traceCategories);
        }
    }

    private static final void syncAlarm$lambda$0(LogTraceScenariosRegistry this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        LogTraceScenariosRegistry.synchronizeToLogger$default(this$0, false, 1, null);
    }

    static {
        boolean $i$f$logger = false;
        com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance(LogTraceScenariosRegistry.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LogTraceScenariosRegistry.logger = logger;
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"createConcurrentList(...)");
        allValues = concurrentList;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u001aR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u0015\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000e\u00a2\u0006\u0002\b\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry$Companion;", "", "()V", "HOLDER_EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry$HolderEpBean;", "TRACE_CATEGORIES_LISTENER_EP_NAME", "Lcom/jetbrains/rd/platform/diagnostics/LogTraceCategoriesListener;", "getTRACE_CATEGORIES_LISTENER_EP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "TRACE_SCENARIOS_KEY", "", "TRACE_SCENARIOS_REGISTRY_KEY", "allValues", "Lcom/intellij/util/containers/ConcurrentList;", "Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenario;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getAllValues", "()Lcom/intellij/util/containers/ConcurrentList;", "delimiter", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry;", "loadTraceScenarioHolders", "", "intellij.rd.platform"})
    @SourceDebugExtension(value={"SMAP\nLogTraceScenarioRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogTraceScenarioRegistry.kt\ncom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n1549#2:183\n1620#2,3:184\n*S KotlinDebug\n*F\n+ 1 LogTraceScenarioRegistry.kt\ncom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry$Companion\n*L\n38#1:183\n38#1:184,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<LogTraceCategoriesListener> getTRACE_CATEGORIES_LISTENER_EP_NAME() {
            return TRACE_CATEGORIES_LISTENER_EP_NAME;
        }

        @NotNull
        public final LogTraceScenariosRegistry getInstance() {
            Object object = ApplicationKt.getApplication().getService(LogTraceScenariosRegistry.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (LogTraceScenariosRegistry)object;
        }

        /*
         * WARNING - void declaration
         */
        public final void loadTraceScenarioHolders() {
            for (ExtensionPointName.LazyExtension item : HOLDER_EP_NAME.filterableLazySequence()) {
                try {
                    void $this$mapTo$iv$iv;
                    HolderEpBean holder;
                    if ((HolderEpBean)item.getInstance() == null) continue;
                    Class<?> clazz = Class.forName(holder.getImplementation(), true, item.getPluginDescriptor().getPluginClassLoader());
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
                    KClass holderClass = JvmClassMappingKt.getKotlinClass(clazz);
                    holderClass.getObjectInstance();
                    Iterable $this$map$iv = holderClass.getNestedClasses();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        KClass kClass = (KClass)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getObjectInstance());
                    }
                    List cfr_ignored_0 = (List)destination$iv$iv;
                }
                catch (Throwable t) {
                    logger.error("Failed to load trace category " + item.getImplementationClassName(), t);
                }
            }
        }

        @NotNull
        public final ConcurrentList<LogTraceScenario> getAllValues() {
            return allValues;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry$HolderEpBean;", "", "()V", "implementation", "", "getImplementation", "()Ljava/lang/String;", "setImplementation", "(Ljava/lang/String;)V", "intellij.rd.platform"})
    public static final class HolderEpBean {
        @Attribute
        @RequiredElement
        @NotNull
        private String implementation = "";

        @NotNull
        public final String getImplementation() {
            return this.implementation;
        }

        public final void setImplementation(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.implementation = string;
        }
    }
}

