/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0013J\u001e\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0005\u0018\u00010\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00050\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rd/ui/bindable/ConverterStorage;", "", "()V", "componentToModel", "", "Ljava/awt/Component;", "Lcom/jetbrains/ide/model/uiautomation/BeControl;", "dataIdToComponent", "", "Lkotlin/Pair;", "checkStorageLimit", "", "storeComponent", "component", "model", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "tryGetComponentByDataId", "id", "(Ljava/lang/Integer;)Ljava/awt/Component;", "tryGetDataByDataId", "", "tryGetModelByComponent", "Companion", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nConverterStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConverterStorage.kt\ncom/jetbrains/rd/ui/bindable/ConverterStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,78:1\n1#2:79\n10#3:80\n*S KotlinDebug\n*F\n+ 1 ConverterStorage.kt\ncom/jetbrains/rd/ui/bindable/ConverterStorage\n*L\n70#1:80\n*E\n"})
public final class ConverterStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Component, BeControl> componentToModel = new LinkedHashMap();
    @NotNull
    private final Map<Integer, Pair<BeControl, Component>> dataIdToComponent = new LinkedHashMap();
    @NotNull
    private static final Logger logger;
    private static final int STORAGE_LIMIT = 500;

    public final void storeComponent(@NotNull Component component, @NotNull BeControl model, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        if (model.getDataId().getValueOrNull() == null) {
            return;
        }
        if (this.componentToModel.containsKey(component) || this.dataIdToComponent.containsKey(model.getDataId().getValueOrNull())) {
            return;
        }
        if (RLifetimeKt.isEternal((Lifetime)lifetime)) {
            logger.error("Component with eternal lifetime cannot be stored");
            return;
        }
        String ids = "data id " + model.getDataId().getValueOrNull() + " and control id " + model.getControlId().getValue();
        lifetime.bracketIfAlive((Function0)new Function0<Unit>(component, ids, this, model){
            final /* synthetic */ Component $component;
            final /* synthetic */ String $ids;
            final /* synthetic */ ConverterStorage this$0;
            final /* synthetic */ BeControl $model;
            {
                this.$component = $component;
                this.$ids = $ids;
                this.this$0 = $receiver;
                this.$model = $model;
                super(0);
            }

            public final void invoke() {
                ConverterStorage.access$getLogger$cp().trace("Add component [" + this.$component.getClass() + "] with " + this.$ids + " to client " + ClientId.Companion.getCurrent());
                ConverterStorage.access$getComponentToModel$p(this.this$0).put(this.$component, this.$model);
                Integer n = (Integer)this.$model.getDataId().getValueOrNull();
                if (n != null) {
                    Integer n2 = n;
                    ConverterStorage converterStorage = this.this$0;
                    BeControl beControl = this.$model;
                    Component component = this.$component;
                    int $this$invoke_u24lambda_u240 = ((Number)n2).intValue();
                    boolean bl = false;
                    Integer n3 = $this$invoke_u24lambda_u240;
                    ConverterStorage.access$getDataIdToComponent$p(converterStorage).put(n3, new Pair((Object)((Object)beControl), (Object)component));
                }
                ConverterStorage.access$checkStorageLimit(this.this$0);
            }
        }, (Function0)new Function0<Unit>(component, ids, this, model){
            final /* synthetic */ Component $component;
            final /* synthetic */ String $ids;
            final /* synthetic */ ConverterStorage this$0;
            final /* synthetic */ BeControl $model;
            {
                this.$component = $component;
                this.$ids = $ids;
                this.this$0 = $receiver;
                this.$model = $model;
                super(0);
            }

            public final void invoke() {
                block0: {
                    ConverterStorage.access$getLogger$cp().trace("Remove component [" + this.$component.getClass() + "] with " + this.$ids + " from client " + ClientId.Companion.getCurrent());
                    ConverterStorage.access$getComponentToModel$p(this.this$0).remove(this.$component);
                    Integer n = (Integer)this.$model.getDataId().getValueOrNull();
                    if (n == null) break block0;
                    Integer n2 = n;
                    ConverterStorage converterStorage = this.this$0;
                    int $this$invoke_u24lambda_u240 = ((Number)n2).intValue();
                    boolean bl = false;
                    ConverterStorage.access$getDataIdToComponent$p(converterStorage).remove($this$invoke_u24lambda_u240);
                }
            }
        });
    }

    private final void checkStorageLimit() {
        if (this.componentToModel.size() > 500) {
            logger.error("Possible leak in converter storage detected. Fix it or increase the limit.");
        }
    }

    @Nullable
    public final BeControl tryGetModelByComponent(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return this.componentToModel.get(component);
    }

    @Nullable
    public final Component tryGetComponentByDataId(@Nullable Integer id) {
        if (id == null) {
            return null;
        }
        Pair<BeControl, Component> pair = this.dataIdToComponent.get(id);
        return pair != null ? (Component)pair.getSecond() : null;
    }

    @Nullable
    public final Pair<BeControl, Component> tryGetDataByDataId(@Nullable String id) {
        Pair<BeControl, Component> pair;
        if (id == null) {
            return null;
        }
        Integer n = StringsKt.toIntOrNull((String)id);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            pair = this.dataIdToComponent.get(it);
        } else {
            pair = null;
        }
        return pair;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ Map access$getComponentToModel$p(ConverterStorage $this) {
        return $this.componentToModel;
    }

    public static final /* synthetic */ void access$checkStorageLimit(ConverterStorage $this) {
        $this.checkStorageLimit();
    }

    public static final /* synthetic */ Map access$getDataIdToComponent$p(ConverterStorage $this) {
        return $this.dataIdToComponent;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ConverterStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ConverterStorage.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001b\u0010\u000b\u001a\u0004\u0018\u00010\u0004*\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rd/ui/bindable/ConverterStorage$Companion;", "", "()V", "STORAGE_LIMIT", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rd/ui/bindable/ConverterStorage;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "getComponentId", "Ljava/awt/Component;", "(Ljava/awt/Component;Lcom/intellij/openapi/client/ClientAppSession;)Ljava/lang/Integer;", "intellij.rd.ui"})
    @SourceDebugExtension(value={"SMAP\nConverterStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConverterStorage.kt\ncom/jetbrains/rd/ui/bindable/ConverterStorage$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n23#2:79\n1#3:80\n*S KotlinDebug\n*F\n+ 1 ConverterStorage.kt\ncom/jetbrains/rd/ui/bindable/ConverterStorage$Companion\n*L\n68#1:79\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConverterStorage getInstance(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ClientSession $this$service$iv = (ClientSession)session;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(ConverterStorage.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            return (ConverterStorage)object;
        }

        @Nullable
        public final Integer getComponentId(@Nullable Component $this$getComponentId, @NotNull ClientAppSession session) {
            Integer n;
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Component component = $this$getComponentId;
            if (component != null) {
                Component it = component;
                boolean bl = false;
                IOptProperty<Integer> iOptProperty = Companion.getInstance(session).tryGetModelByComponent(it);
                n = iOptProperty != null && (iOptProperty = iOptProperty.getDataId()) != null ? (Integer)iOptProperty.getValueOrNull() : null;
            } else {
                n = null;
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

