/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.icons.converters;

import com.intellij.codeHighlighting.HighlightDisplayLevelColoredIcon;
import com.intellij.util.ui.ColorizeProxyIcon;
import com.jetbrains.rd.ide.model.AbstractColor;
import com.jetbrains.rd.ide.model.ColorIconModel;
import com.jetbrains.rd.ide.model.ColorizedIconModel;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import com.jetbrains.rd.ui.icons.ProtocolIconConverter;
import com.jetbrains.rd.ui.icons.ProtocolIconRegistry;
import java.awt.Color;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/ColorizedIconConverter;", "Lcom/jetbrains/rd/ui/icons/ProtocolIconConverter;", "Lcom/intellij/codeHighlighting/HighlightDisplayLevelColoredIcon;", "Lcom/jetbrains/rd/ide/model/ColorizedIconModel;", "()V", "createIcon", "Ljavax/swing/Icon;", "model", "registry", "Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistry;", "createModel", "Lcom/jetbrains/rd/ide/model/IconModel;", "icon", "intellij.rd.ui"})
public final class ColorizedIconConverter
implements ProtocolIconConverter<HighlightDisplayLevelColoredIcon, ColorizedIconModel> {
    @Override
    @NotNull
    public Icon createIcon(@NotNull ColorizedIconModel model, @NotNull ProtocolIconRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Icon base = registry.createIcon(model.getBase());
        Color color = ColorHostKt.toColor(model.getColor());
        return (Icon)new ColorizeProxyIcon.Simple(base, color);
    }

    @Override
    @NotNull
    public IconModel createModel(@NotNull HighlightDisplayLevelColoredIcon icon2, @NotNull ProtocolIconRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        AbstractColor color = ColorHostKt.toModel(icon2.getColor());
        IconModel iconModel = registry.createModel(icon2.getIcon());
        if (iconModel == null) {
            return new ColorIconModel(color);
        }
        IconModel baseModel = iconModel;
        return new ColorizedIconModel(color, baseModel);
    }
}

