/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveAttributeIntentionFix
extends PsiElementBaseIntentionAction
implements LocalQuickFix {
    private final String myLocalName;

    public RemoveAttributeIntentionFix(String localName) {
        this.myLocalName = localName;
    }

    public RemoveAttributeIntentionFix() {
        this(null);
    }

    @NotNull
    public String getName() {
        String string2 = XmlAnalysisBundle.message("xml.quickfix.remove.attribute.text", this.myLocalName);
        if (string2 == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string2 = this.myLocalName != null ? this.getName() : this.getFamilyName();
        if (string2 == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public String getFamilyName() {
        String string2 = XmlAnalysisBundle.message("xml.quickfix.remove.attribute.family", new Object[0]);
        if (string2 == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(2);
        }
        return string2;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(3);
        }
        if (element == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(4);
        }
        return RemoveAttributeIntentionFix.getAttribute(element, editor) != null;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(5);
        }
        if (element == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(6);
        }
        this.removeAttribute(RemoveAttributeIntentionFix.getAttribute(element, editor), editor);
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(7);
        }
        if (descriptor == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(8);
        }
        PsiElement e = descriptor.getPsiElement();
        this.removeAttribute(e, null);
    }

    protected void removeAttribute(PsiElement e, Editor editor) {
        XmlAttribute myAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)e, XmlAttribute.class, (boolean)false);
        if (myAttribute == null) {
            return;
        }
        PsiElement next = RemoveAttributeIntentionFix.findNextAttribute(myAttribute);
        myAttribute.delete();
        if (next != null && editor != null) {
            editor.getCaretModel().moveToOffset(next.getTextRange().getStartOffset());
        }
    }

    @Nullable
    private static PsiElement findNextAttribute(XmlAttribute attribute) {
        for (PsiElement nextSibling = attribute.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
            if (!(nextSibling instanceof XmlAttribute)) continue;
            return nextSibling;
        }
        return null;
    }

    private static XmlAttribute getAttribute(PsiElement element, Editor editor) {
        XmlAttribute result2 = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class);
        if (result2 != null) {
            return result2;
        }
        if (element.getTextRange().getStartOffset() == editor.getCaretModel().getOffset()) {
            return (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.prevLeaf((PsiElement)element), XmlAttribute.class);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/RemoveAttributeIntentionFix";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/RemoveAttributeIntentionFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string2);
        };
    }
}

