/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageOptionsProvider;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageView;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.containers.DisposableWrapperList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Unit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="CoverageViewManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
@Service(value={Service.Level.PROJECT})
public final class CoverageViewManager
implements PersistentStateComponent<StateBean>,
Disposable {
    private static final Logger LOG = Logger.getInstance(CoverageViewManager.class);
    @NonNls
    public static final String TOOLWINDOW_ID = "Coverage";
    private final Project myProject;
    private ContentManager myContentManager;
    private StateBean myStateBean;
    private final Map<CoverageSuitesBundle, CoverageView> myViews;

    public CoverageViewManager(@NotNull Project project2) {
        if (project2 == null) {
            CoverageViewManager.$$$reportNull$$$0(0);
        }
        this.myStateBean = new StateBean();
        this.myViews = new HashMap<CoverageSuitesBundle, CoverageView>();
        this.myProject = project2;
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this)).submit(() -> {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).registerToolWindow(TOOLWINDOW_ID, builder2 -> {
                builder2.sideTool = true;
                builder2.icon = AllIcons.Toolwindows.ToolWindowCoverage;
                builder2.anchor = ToolWindowAnchor.RIGHT;
                builder2.stripeTitle = CoverageBundle.messagePointer("coverage.view.title", new Object[0]);
                return Unit.INSTANCE;
            });
            toolWindow.setHelpId("reference.toolWindows.Coverage");
            this.myContentManager = toolWindow.getContentManager();
        });
    }

    public void dispose() {
    }

    public StateBean getState() {
        if (!this.myViews.isEmpty()) {
            CoverageView view = this.myViews.values().iterator().next();
            view.saveSize();
        }
        return this.myStateBean;
    }

    public void loadState(@NotNull StateBean state) {
        if (state == null) {
            CoverageViewManager.$$$reportNull$$$0(1);
        }
        this.myStateBean = state;
    }

    public StateBean getStateBean() {
        return this.myStateBean;
    }

    public CoverageView getToolwindow(CoverageSuitesBundle suitesBundle) {
        return this.myViews.get(suitesBundle);
    }

    public CoverageSuitesBundle getOpenedSuite() {
        ContentManager manager = this.myContentManager;
        if (manager == null) {
            return null;
        }
        Content selectedContent = manager.getSelectedContent();
        if (selectedContent == null) {
            return null;
        }
        for (Map.Entry<CoverageSuitesBundle, CoverageView> entry2 : this.myViews.entrySet()) {
            Content content = manager.getContent((JComponent)((Object)entry2.getValue()));
            if (content != selectedContent) continue;
            return entry2.getKey();
        }
        return null;
    }

    public void activateToolwindow(@NotNull CoverageView view, boolean requestFocus) {
        if (view == null) {
            CoverageViewManager.$$$reportNull$$$0(2);
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(TOOLWINDOW_ID);
        if (requestFocus) {
            this.myContentManager.setSelectedContent(this.myContentManager.getContent((JComponent)((Object)view)));
            LOG.assertTrue(toolWindow != null);
            toolWindow.activate(null, false);
        }
    }

    public static CoverageViewManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            CoverageViewManager.$$$reportNull$$$0(3);
        }
        return (CoverageViewManager)project2.getService(CoverageViewManager.class);
    }

    public void createToolWindow(CoverageSuitesBundle suitesBundle, boolean activate2) {
        Content content;
        CoverageView coverageView = this.myViews.get(suitesBundle);
        if (coverageView == null) {
            coverageView = new CoverageView(this.myProject, suitesBundle, this.myStateBean);
            this.myViews.put(suitesBundle, coverageView);
            content = this.myContentManager.getFactory().createContent((JComponent)((Object)coverageView), CoverageViewManager.getDisplayName(suitesBundle), false);
            this.myContentManager.addContent(content);
        } else {
            content = this.myContentManager.getContent((JComponent)((Object)coverageView));
        }
        this.myContentManager.setSelectedContent(content);
        if (CoverageOptionsProvider.getInstance(this.myProject).activateViewOnRun() && activate2) {
            this.activateToolwindow(coverageView, true);
        }
    }

    public void closeView(CoverageSuitesBundle suitesBundle) {
        CoverageView oldView = this.myViews.remove(suitesBundle);
        if (oldView != null) {
            oldView.saveSize();
            ApplicationManager.getApplication().invokeLater(() -> {
                Content content = this.myContentManager.getContent((JComponent)((Object)oldView));
                if (content != null) {
                    this.myContentManager.removeContent(content, false);
                }
            });
        }
    }

    @NlsSafe
    public static String getDisplayName(@NotNull CoverageSuitesBundle suitesBundle) {
        RunConfigurationBase configuration;
        if (suitesBundle == null) {
            CoverageViewManager.$$$reportNull$$$0(4);
        }
        return (configuration = suitesBundle.getRunConfiguration()) != null ? configuration.getName() : suitesBundle.getPresentableName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suitesBundle";
                break;
            }
        }
        objectArray2[1] = "com/intellij/coverage/view/CoverageViewManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "activateToolwindow";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getDisplayName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class StateBean {
        private boolean myFlattenPackages = false;
        public boolean myAutoScrollToSource = false;
        public boolean myAutoScrollFromSource = false;
        public List<Integer> myColumnSize;
        public boolean myAscendingOrder = true;
        public int mySortingColumn = 0;
        private boolean myHideFullyCovered = false;
        private boolean myShowOnlyModified = true;
        private boolean myDefaultFilters = true;
        private final DisposableWrapperList<CoverageViewSettingsListener> myListeners = new DisposableWrapperList();

        public boolean isFlattenPackages() {
            return this.myFlattenPackages;
        }

        public void setFlattenPackages(boolean flattenPackages) {
            if (this.myFlattenPackages != flattenPackages) {
                this.myFlattenPackages = flattenPackages;
                this.fireChanged();
            }
        }

        public boolean isHideFullyCovered() {
            return this.myHideFullyCovered;
        }

        public void setHideFullyCovered(boolean hideFullyCovered) {
            if (this.myHideFullyCovered != hideFullyCovered) {
                this.myHideFullyCovered = hideFullyCovered;
                this.myDefaultFilters = false;
                this.fireChanged();
            }
        }

        public boolean isShowOnlyModified() {
            return this.myShowOnlyModified;
        }

        public void setShowOnlyModified(boolean showOnlyModified) {
            if (this.myShowOnlyModified != showOnlyModified) {
                this.myShowOnlyModified = showOnlyModified;
                this.myDefaultFilters = false;
                this.fireChanged();
            }
        }

        public boolean isDefaultFilters() {
            return this.myDefaultFilters;
        }

        public void addListener(Disposable disposable, CoverageViewSettingsListener listener2) {
            this.myListeners.add((Object)listener2, disposable);
        }

        private void fireChanged() {
            for (CoverageViewSettingsListener listener2 : this.myListeners) {
                listener2.onSettingsChanged(this);
            }
        }
    }

    public static interface CoverageViewSettingsListener {
        public void onSettingsChanged(StateBean var1);
    }
}

