/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.formove;

import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryException;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.formove.PathsVerifier;
import com.intellij.openapi.diff.impl.patch.formove.TriggerAdditionOrDeletion;
import com.intellij.openapi.diff.impl.patch.formove.UndoApplyPatchDialog;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchAction;
import com.intellij.openapi.vcs.impl.PartialChangesUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PatchApplier {
    private static final Logger LOG = Logger.getInstance(PatchApplier.class);
    private final Project myProject;
    private final VirtualFile myBaseDirectory;
    @NotNull
    private final List<? extends FilePatch> myPatches;
    private final CommitContext myCommitContext;
    @Nullable
    private final LocalChangeList myTargetChangeList;
    @NotNull
    private final List<FilePatch> myRemainingPatches;
    @NotNull
    private final List<FilePatch> myFailedPatches;
    private final PathsVerifier myVerifier;
    private final boolean myReverseConflict;
    private final @NlsContexts.Label @Nullable String myLeftConflictPanelTitle;
    private final @NlsContexts.Label @Nullable String myRightConflictPanelTitle;

    public PatchApplier(@NotNull Project project2, @NotNull VirtualFile baseDirectory, @NotNull List<? extends FilePatch> patches, @Nullable LocalChangeList targetChangeList, @Nullable CommitContext commitContext, boolean reverseConflict, @NlsContexts.Label @Nullable String leftConflictPanelTitle, @NlsContexts.Label @Nullable String rightConflictPanelTitle) {
        if (project2 == null) {
            PatchApplier.$$$reportNull$$$0(0);
        }
        if (baseDirectory == null) {
            PatchApplier.$$$reportNull$$$0(1);
        }
        if (patches == null) {
            PatchApplier.$$$reportNull$$$0(2);
        }
        this.myProject = project2;
        this.myBaseDirectory = baseDirectory;
        this.myPatches = patches;
        this.myTargetChangeList = targetChangeList;
        this.myCommitContext = commitContext;
        this.myReverseConflict = reverseConflict;
        this.myLeftConflictPanelTitle = leftConflictPanelTitle;
        this.myRightConflictPanelTitle = rightConflictPanelTitle;
        this.myRemainingPatches = new ArrayList<FilePatch>();
        this.myFailedPatches = new ArrayList<FilePatch>();
        this.myVerifier = new PathsVerifier(this.myProject, baseDirectory, this.myPatches);
    }

    public void setIgnoreContentRootsCheck() {
        this.myVerifier.setIgnoreContentRootsCheck(true);
    }

    public PatchApplier(@NotNull Project project2, @NotNull VirtualFile baseDirectory, @NotNull List<? extends FilePatch> patches, @Nullable LocalChangeList targetChangeList, @Nullable CommitContext commitContext) {
        if (project2 == null) {
            PatchApplier.$$$reportNull$$$0(3);
        }
        if (baseDirectory == null) {
            PatchApplier.$$$reportNull$$$0(4);
        }
        if (patches == null) {
            PatchApplier.$$$reportNull$$$0(5);
        }
        this(project2, baseDirectory, patches, targetChangeList, commitContext, false, null, null);
    }

    @NotNull
    public List<FilePatch> getRemainingPatches() {
        List<FilePatch> list2 = this.myRemainingPatches;
        if (list2 == null) {
            PatchApplier.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    public Collection<FilePatch> getFailedPatches() {
        List<FilePatch> list2 = this.myFailedPatches;
        if (list2 == null) {
            PatchApplier.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @NotNull
    private List<FilePatch> getBinaryPatches() {
        List list2 = ContainerUtil.mapNotNull(this.myVerifier.getBinaryPatches(), patchInfo -> patchInfo.getApplyPatch().getPatch());
        if (list2 == null) {
            PatchApplier.$$$reportNull$$$0(8);
        }
        return list2;
    }

    public void execute() {
        this.execute(true, false);
    }

    public ApplyPatchStatus execute(boolean showSuccessNotification, boolean silentAddDelete) {
        return PatchApplier.executePatchGroup(Collections.singletonList(this), this.myTargetChangeList, showSuccessNotification, silentAddDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runWithDefaultConfirmations(@NotNull Project project2, boolean resetConfirmations, @NotNull Runnable task2) {
        if (project2 == null) {
            PatchApplier.$$$reportNull$$$0(9);
        }
        if (task2 == null) {
            PatchApplier.$$$reportNull$$$0(10);
        }
        if (!resetConfirmations) {
            task2.run();
        } else {
            ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance(project2);
            VcsShowConfirmationOption addConfirmation = vcsManager2.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, null);
            VcsShowConfirmationOption deleteConfirmation = vcsManager2.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, null);
            VcsShowConfirmationOption.Value addConfirmationValue = addConfirmation.getValue();
            VcsShowConfirmationOption.Value deleteConfirmationValue = deleteConfirmation.getValue();
            addConfirmation.setValue(VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY);
            deleteConfirmation.setValue(VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY);
            try {
                task2.run();
            }
            finally {
                addConfirmation.setValue(addConfirmationValue);
                deleteConfirmation.setValue(deleteConfirmationValue);
            }
        }
    }

    public static ApplyPatchStatus executePatchGroup(Collection<PatchApplier> group2, @Nullable LocalChangeList localChangeList) {
        return PatchApplier.executePatchGroup(group2, localChangeList, true, false);
    }

    private static ApplyPatchStatus executePatchGroup(@NotNull Collection<PatchApplier> group2, @Nullable LocalChangeList targetChangeList, boolean showSuccessNotification, boolean silentAddDelete) {
        if (group2 == null) {
            PatchApplier.$$$reportNull$$$0(11);
        }
        if (group2.isEmpty()) {
            return ApplyPatchStatus.SUCCESS;
        }
        Project project2 = group2.iterator().next().myProject;
        return (ApplyPatchStatus)((Object)PartialChangesUtil.computeUnderChangeListSync(project2, targetChangeList, () -> {
            ApplyPatchStatus result2 = ApplyPatchStatus.SUCCESS;
            for (PatchApplier patchApplier : group2) {
                result2 = ApplyPatchStatus.and(result2, patchApplier.nonWriteActionPreCheck());
            }
            Label beforeLabel = LocalHistory.getInstance().putSystemLabel(project2, VcsBundle.message("patch.apply.before.patch.label.text", new Object[0]));
            TriggerAdditionOrDeletion trigger = new TriggerAdditionOrDeletion(project2);
            Ref refStatus = new Ref((Object)result2);
            ApplicationManager.getApplication().invokeAndWait(() -> {
                try {
                    PatchApplier.runWithDefaultConfirmations(project2, silentAddDelete, () -> CommandProcessor.getInstance().executeCommand(project2, () -> {
                        ArrayList<FilePath> toBeAdded = new ArrayList<FilePath>();
                        ArrayList<FilePath> toBeDeleted = new ArrayList<FilePath>();
                        for (PatchApplier applier : group2) {
                            refStatus.set((Object)ApplyPatchStatus.and((ApplyPatchStatus)((Object)((Object)((Object)((Object)((Object)refStatus.get()))))), applier.createFiles()));
                            toBeAdded.addAll(applier.myVerifier.getToBeAdded());
                            toBeDeleted.addAll(applier.myVerifier.getToBeDeleted());
                        }
                        trigger.prepare(toBeAdded, toBeDeleted);
                        if (refStatus.get() == ApplyPatchStatus.SUCCESS) {
                            refStatus.set(null);
                        }
                        for (PatchApplier applier : group2) {
                            refStatus.set((Object)ApplyPatchStatus.and((ApplyPatchStatus)((Object)((Object)((Object)((Object)((Object)refStatus.get()))))), applier.executeWritable()));
                            if (refStatus.get() != ApplyPatchStatus.ABORT) continue;
                            break;
                        }
                    }, VcsBundle.message("patch.apply.command", new Object[0]), null));
                }
                finally {
                    trigger.cleanup();
                    LocalHistory.getInstance().putSystemLabel(project2, VcsBundle.message("patch.apply.after.patch.label.text", new Object[0]));
                }
            });
            result2 = (ApplyPatchStatus)((Object)((Object)refStatus.get()));
            result2 = result2 == null ? ApplyPatchStatus.FAILURE : result2;
            trigger.processIt();
            boolean rollback = false;
            if (result2 == ApplyPatchStatus.FAILURE) {
                rollback = PatchApplier.askToRollback(project2, group2);
            }
            if (result2 == ApplyPatchStatus.ABORT || rollback) {
                PatchApplier.rollbackUnderProgressIfNeeded(project2, beforeLabel);
            }
            if (showSuccessNotification || !ApplyPatchStatus.SUCCESS.equals((Object)result2)) {
                PatchApplier.showApplyStatus(project2, result2);
            }
            HashSet<FilePath> directlyAffected = new HashSet<FilePath>();
            HashSet<VirtualFile> indirectlyAffected = new HashSet<VirtualFile>();
            for (PatchApplier applier : group2) {
                directlyAffected.addAll(applier.getDirectlyAffected());
                indirectlyAffected.addAll(applier.getIndirectlyAffected());
            }
            directlyAffected.addAll(trigger.getAffected());
            PatchApplier.refreshPassedFiles(project2, directlyAffected, indirectlyAffected);
            return result2;
        }));
    }

    private static boolean askToRollback(@NotNull Project project2, @NotNull Collection<PatchApplier> group2) {
        if (project2 == null) {
            PatchApplier.$$$reportNull$$$0(12);
        }
        if (group2 == null) {
            PatchApplier.$$$reportNull$$$0(13);
        }
        List allFailed = ContainerUtil.concat(group2, PatchApplier::getFailedPatches);
        boolean shouldInformAboutBinaries = ContainerUtil.exists(group2, applier -> !applier.getBinaryPatches().isEmpty());
        List filePaths = ContainerUtil.map((Collection)allFailed, filePatch -> VcsUtil.getFilePath((String)ObjectUtils.chooseNotNull((Object)filePatch.getAfterName(), (Object)filePatch.getBeforeName()), false));
        AtomicBoolean doRollback = new AtomicBoolean();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            UndoApplyPatchDialog undoApplyPatchDialog = new UndoApplyPatchDialog(project2, filePaths, shouldInformAboutBinaries);
            doRollback.set(undoApplyPatchDialog.showAndGet());
        });
        return doRollback.get();
    }

    private static void rollbackUnderProgressIfNeeded(@NotNull Project project2, @NotNull Label labelToRevert) {
        if (project2 == null) {
            PatchApplier.$$$reportNull$$$0(14);
        }
        if (labelToRevert == null) {
            PatchApplier.$$$reportNull$$$0(15);
        }
        Runnable rollback = () -> {
            try {
                labelToRevert.revert(project2, project2.getBaseDir());
                VcsNotifier.getInstance(project2).notifyImportantWarning("vcs.patch.apply.aborted", VcsBundle.message("patch.apply.aborted.title", new Object[0]), VcsBundle.message("patch.apply.aborted.message", new Object[0]));
            }
            catch (LocalHistoryException e) {
                VcsNotifier.getInstance(project2).notifyImportantWarning("vcs.patch.apply.rollback.failed", VcsBundle.message("patch.apply.rollback.failed.title", new Object[0]), VcsBundle.message("patch.apply.rollback.failed.message", new Object[0]));
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(rollback, VcsBundle.message("patch.apply.rollback.progress.title", new Object[0]), true, project2);
        } else {
            ProgressManager.progress((String)VcsBundle.message("patch.apply.rollback.progress", new Object[0]));
            rollback.run();
        }
    }

    @NotNull
    private ApplyPatchStatus nonWriteActionPreCheck() {
        List<FilePatch> failedPreCheck = this.myVerifier.nonWriteActionPreCheck();
        List<FilePatch> skipped = this.myVerifier.getSkipped();
        this.myRemainingPatches.addAll(this.myPatches);
        this.myFailedPatches.addAll(failedPreCheck);
        this.myPatches.removeAll(failedPreCheck);
        this.myPatches.removeAll(skipped);
        if (!failedPreCheck.isEmpty()) {
            ApplyPatchStatus applyPatchStatus = ApplyPatchStatus.FAILURE;
            if (applyPatchStatus == null) {
                PatchApplier.$$$reportNull$$$0(16);
            }
            return applyPatchStatus;
        }
        if (skipped.isEmpty()) {
            ApplyPatchStatus applyPatchStatus = ApplyPatchStatus.SUCCESS;
            if (applyPatchStatus == null) {
                PatchApplier.$$$reportNull$$$0(17);
            }
            return applyPatchStatus;
        }
        if (skipped.size() == this.myPatches.size()) {
            ApplyPatchStatus applyPatchStatus = ApplyPatchStatus.ALREADY_APPLIED;
            if (applyPatchStatus == null) {
                PatchApplier.$$$reportNull$$$0(18);
            }
            return applyPatchStatus;
        }
        ApplyPatchStatus applyPatchStatus = ApplyPatchStatus.PARTIAL;
        if (applyPatchStatus == null) {
            PatchApplier.$$$reportNull$$$0(19);
        }
        return applyPatchStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ApplyPatchStatus executeWritable() {
        ApplyPatchStatus applyStatus;
        block11: {
            AccessToken ignore = SlowOperations.knownIssue((String)"IDEA-305053, EA-659443");
            ReadonlyStatusHandler.OperationStatus readOnlyFilesStatus = ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(this.myVerifier.getWritableFiles());
            if (!readOnlyFilesStatus.hasReadonlyFiles()) break block11;
            PatchApplier.showError(this.myProject, readOnlyFilesStatus.getReadonlyFilesMessage());
            ApplyPatchStatus applyPatchStatus = ApplyPatchStatus.ABORT;
            ApplyPatchStatus applyPatchStatus2 = applyPatchStatus;
            if (applyPatchStatus2 == null) {
                PatchApplier.$$$reportNull$$$0(20);
            }
            return applyPatchStatus2;
            finally {
                if (ignore != null) {
                    ignore.close();
                }
            }
        }
        this.myFailedPatches.addAll(this.myVerifier.filterBadFileTypePatches());
        ApplyPatchStatus initStatus = this.myFailedPatches.isEmpty() ? null : ApplyPatchStatus.FAILURE;
        List<PathsVerifier.PatchAndFile> textPatches = this.myVerifier.getTextPatches();
        List<PathsVerifier.PatchAndFile> binaryPatches = this.myVerifier.getBinaryPatches();
        try {
            PatchApplier.markInternalOperation(textPatches, true);
            applyStatus = this.actualApply(ContainerUtil.concat(textPatches, binaryPatches), this.myCommitContext);
        }
        finally {
            PatchApplier.markInternalOperation(textPatches, false);
        }
        ApplyPatchStatus status = ApplyPatchStatus.and(initStatus, applyStatus);
        ApplyPatchStatus applyPatchStatus = (ApplyPatchStatus)((Object)ObjectUtils.notNull((Object)((Object)status), (Object)((Object)ApplyPatchStatus.SUCCESS)));
        if (applyPatchStatus == null) {
            PatchApplier.$$$reportNull$$$0(21);
        }
        return applyPatchStatus;
    }

    @NotNull
    private ApplyPatchStatus createFiles() {
        Boolean isSuccess = (Boolean)ApplicationManager.getApplication().runWriteAction(() -> {
            List<FilePatch> filePatches = this.myVerifier.execute();
            this.myFailedPatches.addAll(filePatches);
            this.myPatches.removeAll(filePatches);
            return this.myFailedPatches.isEmpty();
        });
        ApplyPatchStatus applyPatchStatus = isSuccess != false ? ApplyPatchStatus.SUCCESS : ApplyPatchStatus.FAILURE;
        if (applyPatchStatus == null) {
            PatchApplier.$$$reportNull$$$0(22);
        }
        return applyPatchStatus;
    }

    private static void markInternalOperation(List<PathsVerifier.PatchAndFile> textPatches, boolean set) {
        for (PathsVerifier.PatchAndFile patch : textPatches) {
            ChangesUtil.markInternalOperation(patch.getFile(), set);
        }
    }

    private List<FilePath> getDirectlyAffected() {
        return this.myVerifier.getDirectlyAffected();
    }

    private List<VirtualFile> getIndirectlyAffected() {
        return this.myVerifier.getAllAffected();
    }

    private static void refreshPassedFiles(@NotNull Project project2, @NotNull Collection<? extends FilePath> directlyAffected, @NotNull Collection<? extends VirtualFile> indirectlyAffected) {
        if (project2 == null) {
            PatchApplier.$$$reportNull$$$0(23);
        }
        if (directlyAffected == null) {
            PatchApplier.$$$reportNull$$$0(24);
        }
        if (indirectlyAffected == null) {
            PatchApplier.$$$reportNull$$$0(25);
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        for (FilePath filePath : directlyAffected) {
            lfs.refreshAndFindFileByIoFile(filePath.getIOFile());
        }
        if (project2.isDisposed()) {
            return;
        }
        VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance(project2);
        vcsDirtyScopeManager.filePathsDirty(directlyAffected, null);
        vcsDirtyScopeManager.filesDirty(indirectlyAffected, null);
    }

    @Nullable
    private ApplyPatchStatus actualApply(@NotNull List<PathsVerifier.PatchAndFile> patches, @Nullable CommitContext commitContext) {
        if (patches == null) {
            PatchApplier.$$$reportNull$$$0(26);
        }
        ApplyPatchContext context = new ApplyPatchContext(this.myBaseDirectory, 0, true, true);
        try {
            return this.applyList(patches, context, commitContext);
        }
        catch (IOException e) {
            PatchApplier.showError(this.myProject, e.getMessage());
            return ApplyPatchStatus.ABORT;
        }
    }

    @Nullable
    private ApplyPatchStatus applyList(@NotNull List<PathsVerifier.PatchAndFile> patches, @NotNull ApplyPatchContext context, @Nullable CommitContext commitContext) throws IOException {
        if (patches == null) {
            PatchApplier.$$$reportNull$$$0(27);
        }
        if (context == null) {
            PatchApplier.$$$reportNull$$$0(28);
        }
        ApplyPatchStatus status = null;
        for (PathsVerifier.PatchAndFile patch : patches) {
            ApplyFilePatchBase<?> applyFilePatch = patch.getApplyPatch();
            ApplyPatchStatus patchStatus = ApplyPatchAction.applyContent(this.myProject, applyFilePatch, context, patch.getFile(), commitContext, this.myReverseConflict, this.myLeftConflictPanelTitle, this.myRightConflictPanelTitle);
            if (patchStatus == ApplyPatchStatus.SUCCESS || patchStatus == ApplyPatchStatus.ALREADY_APPLIED) {
                PatchApplier.applyAdditionalPatchData(patch.getFile(), applyFilePatch.getPatch());
            }
            if (patchStatus == ApplyPatchStatus.ABORT) {
                return patchStatus;
            }
            status = ApplyPatchStatus.and(status, patchStatus);
            if (patchStatus == ApplyPatchStatus.FAILURE) {
                this.myFailedPatches.add((FilePatch)applyFilePatch.getPatch());
                continue;
            }
            if (patchStatus == ApplyPatchStatus.SKIP) continue;
            this.myVerifier.doMoveIfNeeded(patch.getFile());
            this.myRemainingPatches.remove(applyFilePatch.getPatch());
        }
        return status;
    }

    private static <V extends FilePatch> void applyAdditionalPatchData(@NotNull VirtualFile fileToApplyData, @NotNull V filePatch) {
        if (fileToApplyData == null) {
            PatchApplier.$$$reportNull$$$0(29);
        }
        if (filePatch == null) {
            PatchApplier.$$$reportNull$$$0(30);
        }
        int newFileMode = filePatch.getNewFileMode();
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)fileToApplyData);
        if (newFileMode == 100755 || newFileMode == 100644) {
            try {
                file.setExecutable(newFileMode == 100755);
            }
            catch (Exception e) {
                LOG.warn("Can't change file mode for " + fileToApplyData.getPresentableName());
            }
        }
    }

    private static void showApplyStatus(@NotNull Project project2, ApplyPatchStatus status) {
        if (project2 == null) {
            PatchApplier.$$$reportNull$$$0(31);
        }
        VcsNotifier vcsNotifier = VcsNotifier.getInstance(project2);
        if (status == ApplyPatchStatus.ALREADY_APPLIED) {
            vcsNotifier.notifyMinorInfo("vcs.patch.already.applied", VcsBundle.message("patch.apply.notification.title", new Object[0]), VcsBundle.message("patch.apply.already.applied", new Object[0]));
        } else if (status == ApplyPatchStatus.PARTIAL) {
            vcsNotifier.notifyMinorInfo("vcs.patch.partially.applied", VcsBundle.message("patch.apply.notification.title", new Object[0]), VcsBundle.message("patch.apply.partially.applied", new Object[0]));
        } else if (status == ApplyPatchStatus.SUCCESS) {
            vcsNotifier.notifySuccess("vcs.patch.apply.success.applied", "", VcsBundle.message("patch.apply.success.applied.text", new Object[0]));
        }
    }

    public static void showError(Project project2, @NlsContexts.DialogMessage String message2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        VcsImplUtil.showErrorMessage(project2, message2, VcsBundle.message("patch.apply.dialog.title", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 16, 17, 18, 19, 20, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirectory";
                break;
            }
            case 2: 
            case 5: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patches";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/patch/formove/PatchApplier";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelToRevert";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directlyAffected";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indirectlyAffected";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToApplyData";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/patch/formove/PatchApplier";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemainingPatches";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFailedPatches";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryPatches";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "nonWriteActionPreCheck";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "executeWritable";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runWithDefaultConfirmations";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executePatchGroup";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "askToRollback";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "rollbackUnderProgressIfNeeded";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "refreshPassedFiles";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "actualApply";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "applyList";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "applyAdditionalPatchData";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "showApplyStatus";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 7, 8, 16, 17, 18, 19, 20, 21, 22 -> new IllegalStateException(string2);
        };
    }
}

