/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.VcsContextUtil;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogFileHistoryProvider;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedShowHistoryAction
extends DumbAwareAction {
    private static final int MANY_CHANGES_THRESHOLD = 1000;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(1);
        }
        boolean isVisible2 = (project2 = e.getProject()) != null && ProjectLevelVcsManager.getInstance(project2).hasActiveVcss();
        e.getPresentation().setEnabled(this.isEnabled(e.getDataContext()));
        e.getPresentation().setVisible(isVisible2);
    }

    protected boolean isEnabled(@NotNull DataContext context) {
        Project project2;
        if (context == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(2);
        }
        if ((project2 = (Project)context.getData(CommonDataKeys.PROJECT)) == null) {
            return false;
        }
        List selectedFiles = VcsContextUtil.selectedFilePathsIterable(context).take(1000).toList();
        if (selectedFiles.isEmpty()) {
            return false;
        }
        List<FilePath> symlinkedPaths = TabbedShowHistoryAction.getContextSymlinkedPaths(project2, context);
        if (symlinkedPaths != null && TabbedShowHistoryAction.canShowNewFileHistory(project2, symlinkedPaths)) {
            return true;
        }
        if (TabbedShowHistoryAction.canShowNewFileHistory(project2, selectedFiles)) {
            return ContainerUtil.all((Collection)selectedFiles, path2 -> AbstractVcs.fileInVcsByFileStatus(project2, path2));
        }
        if (selectedFiles.size() == 1) {
            FilePath selectedPath = (FilePath)ContainerUtil.getFirstItem((List)selectedFiles);
            if (selectedPath == null) {
                return false;
            }
            VirtualFile fileOrParent = TabbedShowHistoryAction.getExistingFileOrParent(selectedPath);
            if (fileOrParent == null) {
                return false;
            }
            if (TabbedShowHistoryAction.canShowOldFileHistory(project2, selectedPath, fileOrParent)) {
                return AbstractVcs.fileInVcsByFileStatus(project2, selectedPath);
            }
        }
        return false;
    }

    private static boolean canShowOldFileHistory(@NotNull Project project2, @NotNull FilePath path2, @NotNull VirtualFile fileOrParent) {
        AbstractVcs vcs;
        if (project2 == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(3);
        }
        if (path2 == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(4);
        }
        if (fileOrParent == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(5);
        }
        if ((vcs = ChangesUtil.getVcsForFile(fileOrParent, project2)) == null) {
            return false;
        }
        VcsHistoryProvider provider = vcs.getVcsHistoryProvider();
        return provider != null && (provider.supportsHistoryForDirectories() || !path2.isDirectory()) && provider.canShowHistoryFor(fileOrParent);
    }

    private static boolean canShowNewFileHistory(@NotNull Project project2, @NotNull Collection<FilePath> paths) {
        VcsLogFileHistoryProvider historyProvider;
        if (project2 == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(6);
        }
        if (paths == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(7);
        }
        return (historyProvider = (VcsLogFileHistoryProvider)project2.getService(VcsLogFileHistoryProvider.class)) != null && historyProvider.canShowFileHistory(paths, null);
    }

    @Nullable
    private static VirtualFile getExistingFileOrParent(@NotNull FilePath selectedPath) {
        if (selectedPath == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(8);
        }
        return (VirtualFile)ObjectUtils.chooseNotNull((Object)selectedPath.getVirtualFile(), (Object)selectedPath.getVirtualFileParent());
    }

    @Nullable
    private static List<FilePath> getContextSymlinkedPaths(@NotNull Project project2, @NotNull DataContext context) {
        VirtualFile file;
        VirtualFile vcsFile;
        if (project2 == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(9);
        }
        if (context == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(10);
        }
        return (vcsFile = VcsUtil.resolveSymlink(project2, file = VcsContextUtil.selectedFile(context))) != null ? Collections.singletonList(VcsUtil.getFilePath(vcsFile)) : null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        List<FilePath> symlinkedPaths;
        if (e == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(11);
        }
        if ((symlinkedPaths = TabbedShowHistoryAction.getContextSymlinkedPaths(project2 = Objects.requireNonNull(e.getProject()), e.getDataContext())) != null && TabbedShowHistoryAction.canShowNewFileHistory(project2, symlinkedPaths)) {
            TabbedShowHistoryAction.showNewFileHistory(project2, symlinkedPaths);
            return;
        }
        List<FilePath> selectedFiles = VcsContextUtil.selectedFilePaths(e.getDataContext());
        if (TabbedShowHistoryAction.canShowNewFileHistory(project2, selectedFiles)) {
            TabbedShowHistoryAction.showNewFileHistory(project2, selectedFiles);
            return;
        }
        if (selectedFiles.size() == 1) {
            FilePath path2 = Objects.requireNonNull((FilePath)ContainerUtil.getFirstItem(selectedFiles));
            AbstractVcs vcs = Objects.requireNonNull(ChangesUtil.getVcsForFile(Objects.requireNonNull(TabbedShowHistoryAction.getExistingFileOrParent(path2)), project2));
            TabbedShowHistoryAction.showOldFileHistory(project2, vcs, path2);
        }
    }

    private static void showNewFileHistory(@NotNull Project project2, @NotNull Collection<FilePath> paths) {
        if (project2 == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(12);
        }
        if (paths == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(13);
        }
        VcsLogFileHistoryProvider historyProvider = (VcsLogFileHistoryProvider)project2.getService(VcsLogFileHistoryProvider.class);
        historyProvider.showFileHistory(paths, null);
    }

    private static void showOldFileHistory(@NotNull Project project2, @NotNull AbstractVcs vcs, @NotNull FilePath path2) {
        if (project2 == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(14);
        }
        if (vcs == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(15);
        }
        if (path2 == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(16);
        }
        VcsHistoryProvider provider = Objects.requireNonNull(vcs.getVcsHistoryProvider());
        AbstractVcsHelper.getInstance(project2).showFileHistory(provider, vcs.getAnnotationProvider(), path2, vcs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrParent";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedPath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canShowOldFileHistory";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canShowNewFileHistory";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExistingFileOrParent";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getContextSymlinkedPaths";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showNewFileHistory";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showOldFileHistory";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16 -> new IllegalArgumentException(string2);
        };
    }
}

