/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.FilePathHolder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RecursiveFilePathHolderImpl
implements FilePathHolder {
    private final Project myProject;
    private final Set<FilePath> myMap;

    public RecursiveFilePathHolderImpl(Project project2) {
        this.myProject = project2;
        this.myMap = new HashSet<FilePath>();
    }

    @Override
    public void cleanAll() {
        this.myMap.clear();
    }

    @Override
    public void addFile(@NotNull FilePath file) {
        if (file == null) {
            RecursiveFilePathHolderImpl.$$$reportNull$$$0(0);
        }
        if (!this.containsFile(file)) {
            this.myMap.add(file);
        }
    }

    @Override
    public RecursiveFilePathHolderImpl copy() {
        RecursiveFilePathHolderImpl copyHolder = new RecursiveFilePathHolderImpl(this.myProject);
        copyHolder.myMap.addAll(this.myMap);
        return copyHolder;
    }

    @Override
    public boolean containsFile(@NotNull FilePath file, @NotNull VirtualFile vcsRoot) {
        if (file == null) {
            RecursiveFilePathHolderImpl.$$$reportNull$$$0(1);
        }
        if (vcsRoot == null) {
            RecursiveFilePathHolderImpl.$$$reportNull$$$0(2);
        }
        return this.containsFile(file);
    }

    private boolean containsFile(@NotNull FilePath file) {
        if (file == null) {
            RecursiveFilePathHolderImpl.$$$reportNull$$$0(3);
        }
        if (this.myMap.isEmpty()) {
            return false;
        }
        for (FilePath parent = file; parent != null; parent = parent.getParentPath()) {
            if (!this.myMap.contains(parent)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Collection<FilePath> values() {
        Set<FilePath> set = this.myMap;
        if (set == null) {
            RecursiveFilePathHolderImpl.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    public void cleanUnderScope(@NotNull VcsDirtyScope scope2) {
        if (scope2 == null) {
            RecursiveFilePathHolderImpl.$$$reportNull$$$0(5);
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        Iterator<FilePath> iterator = this.myMap.iterator();
        while (iterator.hasNext()) {
            FilePath file = iterator.next();
            if (!RecursiveFilePathHolderImpl.isFileDirty(scope2, file)) continue;
            iterator.remove();
        }
    }

    private static boolean isFileDirty(@NotNull VcsDirtyScope scope2, @NotNull FilePath filePath) {
        if (scope2 == null) {
            RecursiveFilePathHolderImpl.$$$reportNull$$$0(6);
        }
        if (filePath == null) {
            RecursiveFilePathHolderImpl.$$$reportNull$$$0(7);
        }
        return scope2.belongsTo(filePath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecursiveFilePathHolderImpl that = (RecursiveFilePathHolderImpl)o;
        return this.myMap.equals(that.myMap);
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/RecursiveFilePathHolderImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/RecursiveFilePathHolderImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsFile";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "cleanUnderScope";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isFileDirty";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4 -> new IllegalStateException(string2);
        };
    }
}

