/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMissingFilesAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        List files2;
        if (e == null) {
            AbstractMissingFilesAction.$$$reportNull$$$0(0);
        }
        boolean enabled = (files2 = (List)e.getData(ChangesListView.MISSING_FILES_DATA_KEY)) != null && !files2.isEmpty();
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AbstractMissingFilesAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractMissingFilesAction.$$$reportNull$$$0(2);
        }
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        List files2 = (List)e.getData(ChangesListView.MISSING_FILES_DATA_KEY);
        if (files2 == null) {
            return;
        }
        ProgressManager progressManager = ProgressManager.getInstance();
        Runnable action2 = () -> {
            ArrayList allExceptions = new ArrayList();
            ChangesUtil.processFilePathsByVcs(project2, files2, (vcs, items2) -> {
                List<VcsException> exceptions2 = this.processFiles(vcs, files2);
                if (exceptions2 != null) {
                    allExceptions.addAll(exceptions2);
                }
            });
            for (FilePath file : files2) {
                VcsDirtyScopeManager.getInstance(project2).fileDirty(file);
            }
            if (allExceptions.size() > 0) {
                AbstractVcsHelper.getInstance(project2).showErrors(allExceptions, VcsBundle.message("changes.tab.title.vcs.errors", new Object[0]));
            }
        };
        if (this.synchronously()) {
            action2.run();
        } else {
            progressManager.runProcessWithProgressSynchronously(action2, this.getName(), true, project2);
        }
    }

    protected abstract boolean synchronously();

    @NlsContexts.ProgressTitle
    protected abstract String getName();

    protected abstract List<VcsException> processFiles(AbstractVcs var1, List<? extends FilePath> var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/AbstractMissingFilesAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/AbstractMissingFilesAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

