/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.savedPatches;

import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.savedPatches.SavedPatchesProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.PresentableChange;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.util.containers.JBIterable;
import java.beans.PropertyChangeEvent;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0014J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesDiffPreview;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "isInEditor", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;ZLcom/intellij/openapi/Disposable;)V", "disposableFlag", "Lcom/intellij/openapi/util/CheckedDisposable;", "Lorg/jetbrains/annotations/NotNull;", "iterateAllChanges", "", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$Wrapper;", "iterateSelectedChanges", "selectChange", "", "change", "shouldAddToolbarBottomBorder", "toolbarComponents", "Lcom/intellij/diff/FrameDiffTool$ToolbarComponents;", "updatePreviewLater", "modelUpdateInProgress", "wrap", "treeModelData", "Lcom/intellij/openapi/vcs/changes/ui/VcsTreeModelData;", "MyChangeWrapper", "intellij.platform.vcs.impl"})
public final class SavedPatchesDiffPreview
extends ChangeViewDiffRequestProcessor {
    @NotNull
    private final ChangesTree tree;
    private final boolean isInEditor;
    @NotNull
    private final CheckedDisposable disposableFlag;

    public SavedPatchesDiffPreview(@NotNull Project project2, @NotNull ChangesTree tree2, boolean isInEditor, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)tree2), (String)"tree");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(project2, "SavedPatchesUiPlace");
        this.tree = tree2;
        this.isInEditor = isInEditor;
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
        this.disposableFlag = checkedDisposable;
        this.tree.addSelectionListener(() -> SavedPatchesDiffPreview._init_$lambda$0(this), (Disposable)this);
        this.tree.addPropertyChangeListener("model", arg_0 -> SavedPatchesDiffPreview._init_$lambda$1(this, arg_0));
        Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)this));
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)this.disposableFlag));
        this.updatePreviewLater(false);
    }

    protected boolean shouldAddToolbarBottomBorder(@NotNull FrameDiffTool.ToolbarComponents toolbarComponents) {
        Intrinsics.checkNotNullParameter((Object)toolbarComponents, (String)"toolbarComponents");
        return !this.isInEditor || super.shouldAddToolbarBottomBorder(toolbarComponents);
    }

    private final void updatePreviewLater(boolean modelUpdateInProgress) {
        ApplicationManager.getApplication().invokeLater(() -> SavedPatchesDiffPreview.updatePreviewLater$lambda$2(this, modelUpdateInProgress), arg_0 -> SavedPatchesDiffPreview.updatePreviewLater$lambda$3(this, arg_0));
    }

    @NotNull
    public Iterable<ChangeViewDiffRequestProcessor.Wrapper> iterateSelectedChanges() {
        VcsTreeModelData vcsTreeModelData = VcsTreeModelData.selected((JTree)((Object)this.tree));
        Intrinsics.checkNotNullExpressionValue((Object)vcsTreeModelData, (String)"selected(...)");
        return this.wrap(vcsTreeModelData);
    }

    @NotNull
    public Iterable<ChangeViewDiffRequestProcessor.Wrapper> iterateAllChanges() {
        VcsTreeModelData vcsTreeModelData = VcsTreeModelData.all((JTree)((Object)this.tree));
        Intrinsics.checkNotNullExpressionValue((Object)vcsTreeModelData, (String)"all(...)");
        return this.wrap(vcsTreeModelData);
    }

    @Override
    protected void selectChange(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        ChangesBrowserBase.selectObjectWithTag(this.tree, change.getUserObject(), change.getTag());
    }

    private final Iterable<ChangeViewDiffRequestProcessor.Wrapper> wrap(VcsTreeModelData treeModelData) {
        JBIterable jBIterable = treeModelData.iterateUserObjects(SavedPatchesProvider.ChangeObject.class).map(arg_0 -> SavedPatchesDiffPreview.wrap$lambda$4((Function1)new Function1<SavedPatchesProvider.ChangeObject, MyChangeWrapper>(this){
            final /* synthetic */ SavedPatchesDiffPreview this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final MyChangeWrapper invoke(SavedPatchesProvider.ChangeObject it) {
                Intrinsics.checkNotNull((Object)it);
                return this.this$0.new MyChangeWrapper(it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"map(...)");
        return (Iterable)jBIterable;
    }

    private static final void _init_$lambda$0(SavedPatchesDiffPreview this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updatePreviewLater(false);
    }

    private static final void _init_$lambda$1(SavedPatchesDiffPreview this$0, PropertyChangeEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updatePreviewLater(false);
    }

    private static final void updatePreviewLater$lambda$2(SavedPatchesDiffPreview this$0, boolean $modelUpdateInProgress) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updatePreview(this$0.getComponent().isShowing(), $modelUpdateInProgress);
    }

    private static final boolean updatePreviewLater$lambda$3(SavedPatchesDiffPreview this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.disposableFlag.isDisposed();
    }

    private static final MyChangeWrapper wrap$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (MyChangeWrapper)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u000e\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0097\u0001J\u000e\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\fH\u0097\u0001J\r\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesDiffPreview$MyChangeWrapper;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$Wrapper;", "Lcom/intellij/openapi/vcs/changes/ui/PresentableChange;", "change", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesProvider$ChangeObject;", "(Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesDiffPreview;Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesProvider$ChangeObject;)V", "createProducer", "Lcom/intellij/diff/chains/DiffRequestProducer;", "project", "Lcom/intellij/openapi/project/Project;", "getFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "Lorg/jetbrains/annotations/NotNull;", "getFileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "getPresentableName", "", "Lorg/jetbrains/annotations/Nls;", "getTag", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$Tag;", "getUserObject", "", "intellij.platform.vcs.impl"})
    private final class MyChangeWrapper
    extends ChangeViewDiffRequestProcessor.Wrapper
    implements PresentableChange {
        @NotNull
        private final SavedPatchesProvider.ChangeObject change;

        public MyChangeWrapper(SavedPatchesProvider.ChangeObject change) {
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            this.change = change;
        }

        @Override
        @NotNull
        public FilePath getFilePath() {
            return this.change.getFilePath();
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            return this.change.getFileStatus();
        }

        @Override
        @NotNull
        public Object getUserObject() {
            return this.change;
        }

        @Override
        @NotNull
        public String getPresentableName() {
            String string2 = this.change.getFilePath().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            return string2;
        }

        @Override
        @Nullable
        public DiffRequestProducer createProducer(@Nullable Project project2) {
            return this.change.createDiffRequestProducer(project2);
        }

        @Override
        @Nullable
        public ChangesBrowserNode.Tag getTag() {
            return this.change.getTag();
        }
    }
}

