/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00140\u00182\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/openapi/vcs/changes/ui/BackgroundRefresher;", "T", "", "name", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Ljava/lang/String;Lcom/intellij/openapi/Disposable;)V", "currentIndicator", "Lcom/intellij/openapi/progress/EmptyProgressIndicator;", "currentTask", "Ljava/util/concurrent/ScheduledFuture;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "isDisposed", "", "nextRefresh", "promisesToFulfil", "", "Lorg/jetbrains/concurrency/AsyncPromise;", "requestLock", "Ljava/util/concurrent/locks/Lock;", "collectPromises", "", "force", "requestRefresh", "Lorg/jetbrains/concurrency/Promise;", "delayMillis", "", "block", "Lcom/intellij/openapi/util/Computable;", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nBackgroundRefresher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackgroundRefresher.kt\ncom/intellij/openapi/vcs/changes/ui/BackgroundRefresher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
public final class BackgroundRefresher<T> {
    @NotNull
    private final ScheduledExecutorService executor;
    @NotNull
    private final Lock requestLock;
    @NotNull
    private EmptyProgressIndicator currentIndicator;
    private boolean isDisposed;
    @Nullable
    private ScheduledFuture<?> currentTask;
    private boolean nextRefresh;
    @NotNull
    private final List<AsyncPromise<T>> promisesToFulfil;

    public BackgroundRefresher(@NotNull String name, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        ScheduledExecutorService scheduledExecutorService = AppExecutorUtil.createBoundedScheduledExecutorService((String)name, (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"createBoundedScheduledExecutorService(...)");
        this.executor = scheduledExecutorService;
        this.requestLock = new ReentrantLock();
        this.currentIndicator = new EmptyProgressIndicator();
        this.promisesToFulfil = new ArrayList();
        Disposer.register((Disposable)parentDisposable, () -> BackgroundRefresher._init_$lambda$1(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Promise<T> requestRefresh(int delayMillis, @NotNull Computable<T> block) {
        AsyncPromise asyncPromise;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Lock lock = this.requestLock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.isDisposed) {
                AsyncPromise asyncPromise2;
                AsyncPromise it = asyncPromise2 = new AsyncPromise();
                boolean bl2 = false;
                it.cancel(false);
                Promise promise = (Promise)asyncPromise2;
                return promise;
            }
            ScheduledFuture<?> scheduledFuture = this.currentTask;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            this.currentIndicator.cancel();
            AsyncPromise promise = new AsyncPromise();
            this.promisesToFulfil.add(promise);
            this.nextRefresh = true;
            this.currentTask = this.executor.schedule(() -> BackgroundRefresher.requestRefresh$lambda$5$lambda$4(this, block), (long)delayMillis, TimeUnit.MILLISECONDS);
            asyncPromise = promise;
        }
        finally {
            lock.unlock();
        }
        return (Promise)asyncPromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<AsyncPromise<T>> collectPromises(boolean force) {
        Lock lock = this.requestLock;
        lock.lock();
        try {
            boolean bl = false;
            if (!force && (this.nextRefresh || this.isDisposed)) {
                List list2 = CollectionsKt.emptyList();
                return list2;
            }
            List promises = CollectionsKt.toList((Iterable)this.promisesToFulfil);
            this.promisesToFulfil.clear();
            List list3 = promises;
            return list3;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void _init_$lambda$1(BackgroundRefresher this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Lock lock = this$0.requestLock;
        lock.lock();
        try {
            boolean bl = false;
            this$0.isDisposed = true;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this$0.executor.shutdownNow();
        this$0.currentIndicator.cancel();
        this$0.currentTask = null;
        for (AsyncPromise asyncPromise : this$0.collectPromises(true)) {
            asyncPromise.setError((Throwable)AsyncPromise.CANCELED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void requestRefresh$lambda$5$lambda$4(BackgroundRefresher this$0, Computable $block) {
        EmptyProgressIndicator emptyProgressIndicator;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        Lock lock = this$0.requestLock;
        lock.lock();
        try {
            EmptyProgressIndicator emptyProgressIndicator2;
            boolean bl = false;
            this$0.nextRefresh = false;
            this$0.currentTask = null;
            this$0.currentIndicator = emptyProgressIndicator2 = new EmptyProgressIndicator();
            emptyProgressIndicator = emptyProgressIndicator2;
        }
        finally {
            lock.unlock();
        }
        EmptyProgressIndicator indicator = emptyProgressIndicator;
        try {
            Object value2 = ProgressManager.getInstance().runProcess($block, (ProgressIndicator)indicator);
            ProgressManager.checkCanceled();
            if (this$0.executor.isShutdown()) {
                throw new ProcessCanceledException();
            }
            for (AsyncPromise asyncPromise : this$0.collectPromises(false)) {
                asyncPromise.setResult(value2);
            }
        }
        catch (Throwable t) {
            for (AsyncPromise asyncPromise : this$0.collectPromises(false)) {
                asyncPromise.setError(t);
            }
        }
    }
}

