/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowser;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeListImpl;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommittedChangeListPanel
extends JPanel
implements DataProvider {
    private final Project myProject;
    private final JLabel myDescriptionLabel;
    private final CommittedChangesBrowser myChangesBrowser;
    private final JEditorPane myCommitMessageArea;
    private final JScrollPane myCommitMessageScrollPane;
    @NotNull
    private CommittedChangeList myChangeList;
    @NotNull
    private Collection<Change> myChanges;
    private boolean myShowSideBorders;
    private boolean myShowCommitMessage;

    public CommittedChangeListPanel(@NotNull Project project2) {
        if (project2 == null) {
            CommittedChangeListPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myShowSideBorders = true;
        this.myShowCommitMessage = true;
        this.myProject = project2;
        this.myChangeList = CommittedChangeListPanel.createChangeList(Collections.emptyList());
        this.myChanges = this.myChangeList.getChanges();
        this.myDescriptionLabel = new JLabel();
        this.myDescriptionLabel.setBorder(BorderFactory.createEtchedBorder());
        this.myChangesBrowser = new MyChangesBrowser(this.myProject);
        this.myCommitMessageArea = new JEditorPane("text/html", ""){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setText(CommittedChangeListPanel.this.getChangelistCommentHtml());
            }
        };
        this.myCommitMessageArea.setBorder(JBUI.Borders.empty((int)3));
        this.myCommitMessageArea.setEditable(false);
        this.myCommitMessageArea.setBackground(UIUtil.getTreeBackground());
        this.myCommitMessageArea.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        this.myCommitMessageScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myCommitMessageArea);
        OnePixelSplitter splitter = new OnePixelSplitter(true, 0.8f);
        splitter.setFirstComponent((JComponent)this.myChangesBrowser);
        splitter.setSecondComponent((JComponent)this.myCommitMessageScrollPane);
        this.add((Component)splitter, "Center");
        this.add((Component)this.myDescriptionLabel, "North");
        this.updatePresentation();
        this.setDescription(null);
    }

    private void updatePresentation() {
        this.myCommitMessageScrollPane.setVisible(this.myShowCommitMessage);
        if (this.myShowSideBorders) {
            if (this.myShowCommitMessage) {
                this.myChangesBrowser.setViewerBorder(IdeBorderFactory.createBorder((int)7));
                this.myCommitMessageScrollPane.setBorder(IdeBorderFactory.createBorder((int)13));
            } else {
                this.myChangesBrowser.setViewerBorder(IdeBorderFactory.createBorder((int)15));
            }
        } else {
            this.myChangesBrowser.setViewerBorder(IdeBorderFactory.createBorder((int)2));
            this.myCommitMessageScrollPane.setBorder((Border)JBUI.Borders.empty());
        }
    }

    public void setChangeList(@NotNull CommittedChangeList changeList) {
        if (changeList == null) {
            CommittedChangeListPanel.$$$reportNull$$$0(1);
        }
        this.myChangeList = changeList;
        this.myChanges = changeList.getChanges();
        this.myChangesBrowser.setChangesToDisplay(this.myChanges);
        this.myCommitMessageArea.setText(this.getChangelistCommentHtml());
        this.myCommitMessageArea.setCaretPosition(0);
    }

    @NotNull
    @Nls
    private String getChangelistCommentHtml() {
        String string2 = IssueLinkHtmlRenderer.formatTextIntoHtml(this.myProject, this.myChangeList.getComment().trim());
        if (string2 == null) {
            CommittedChangeListPanel.$$$reportNull$$$0(2);
        }
        return string2;
    }

    public void setShowCommitMessage(boolean value2) {
        this.myShowCommitMessage = value2;
        this.updatePresentation();
    }

    public void setShowSideBorders(boolean value2) {
        this.myShowSideBorders = value2;
        this.updatePresentation();
    }

    public void setDescription(@Nullable @NlsContexts.Label String description2) {
        this.myDescriptionLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)StringUtil.notNullize((String)description2)));
        this.myDescriptionLabel.setVisible(description2 != null);
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myChangesBrowser.getPreferredFocusedComponent();
        if (jComponent == null) {
            CommittedChangeListPanel.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @NotNull
    public CommittedChangesBrowser getChangesBrowser() {
        CommittedChangesBrowser committedChangesBrowser = this.myChangesBrowser;
        if (committedChangesBrowser == null) {
            CommittedChangeListPanel.$$$reportNull$$$0(4);
        }
        return committedChangesBrowser;
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            CommittedChangeListPanel.$$$reportNull$$$0(5);
        }
        if (VcsDataKeys.CHANGES.is(dataId)) {
            return this.myChanges.toArray(Change.EMPTY_CHANGE_ARRAY);
        }
        if (VcsDataKeys.VCS.is(dataId)) {
            AbstractVcs vcs = this.myChangeList.getVcs();
            return vcs == null ? null : vcs.getKeyInstanceMethod();
        }
        if (VcsDataKeys.CHANGE_LISTS.is(dataId)) {
            return new ChangeList[]{this.myChangeList};
        }
        return null;
    }

    @NotNull
    public static CommittedChangeListImpl createChangeList(@NotNull Collection<Change> changes) {
        if (changes == null) {
            CommittedChangeListPanel.$$$reportNull$$$0(6);
        }
        return new CommittedChangeListImpl("", "", "", -1L, new Date(0L), changes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/CommittedChangeListPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/CommittedChangeListPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangelistCommentHtml";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesBrowser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setChangeList";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createChangeList";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4 -> new IllegalStateException(string2);
        };
    }

    private static class MyChangesBrowser
    extends CommittedChangesBrowser {
        MyChangesBrowser(@NotNull Project project2) {
            if (project2 == null) {
                MyChangesBrowser.$$$reportNull$$$0(0);
            }
            super(project2);
        }

        @Override
        @NotNull
        protected List<AnAction> createPopupMenuActions() {
            List list2 = ContainerUtil.append(super.createPopupMenuActions(), (Object[])new AnAction[]{ActionManager.getInstance().getAction("Vcs.CopyRevisionNumberAction")});
            if (list2 == null) {
                MyChangesBrowser.$$$reportNull$$$0(1);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/CommittedChangeListPanel$MyChangesBrowser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/CommittedChangeListPanel$MyChangesBrowser";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupMenuActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }
}

