/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.codeInsight.CodeSmellInfo;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CodeSmellDetector;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CodeAnalysisBeforeCheckinHandler;
import com.intellij.openapi.vcs.checkin.CommitInfo;
import com.intellij.openapi.vcs.checkin.CommitProblemWithDetails;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/checkin/CodeAnalysisCommitProblem;", "Lcom/intellij/openapi/vcs/checkin/CommitProblemWithDetails;", "codeSmells", "", "Lcom/intellij/codeInsight/CodeSmellInfo;", "errors", "", "warnings", "(Ljava/util/List;II)V", "showDetailsAction", "", "getShowDetailsAction", "()Ljava/lang/String;", "text", "getText", "showDetails", "", "project", "Lcom/intellij/openapi/project/Project;", "showModalSolution", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler$ReturnResult;", "commitInfo", "Lcom/intellij/openapi/vcs/checkin/CommitInfo;", "intellij.platform.vcs.impl"})
public final class CodeAnalysisCommitProblem
implements CommitProblemWithDetails {
    @NotNull
    private final List<CodeSmellInfo> codeSmells;
    private final int errors;
    private final int warnings;

    public CodeAnalysisCommitProblem(@NotNull List<CodeSmellInfo> codeSmells, int errors, int warnings) {
        Intrinsics.checkNotNullParameter(codeSmells, (String)"codeSmells");
        this.codeSmells = codeSmells;
        this.errors = errors;
        this.warnings = warnings;
    }

    @Override
    @NotNull
    public String getText() {
        String errorsText = this.errors > 0 ? HighlightSeverity.ERROR.getCountMessage(this.errors) : null;
        String warningsText = this.warnings > 0 ? HighlightSeverity.WARNING.getCountMessage(this.warnings) : null;
        Object[] objectArray = new String[]{errorsText, warningsText};
        String string2 = NlsMessages.formatAndList((Collection)CollectionsKt.listOfNotNull((Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatAndList(...)");
        return string2;
    }

    @Override
    public void showDetails(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        CodeSmellDetector.getInstance(project2).showCodeSmellErrors(this.codeSmells);
    }

    @Override
    @NotNull
    public CheckinHandler.ReturnResult showModalSolution(@NotNull Project project2, @NotNull CommitInfo commitInfo) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commitInfo, (String)"commitInfo");
        return CodeAnalysisBeforeCheckinHandler.Companion.processFoundCodeSmells$intellij_platform_vcs_impl(project2, this.codeSmells, commitInfo.getCommitActionText());
    }

    @Override
    @NotNull
    public String getShowDetailsAction() {
        String string2 = VcsBundle.message("code.smells.review.button", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }
}

