/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.NlsContexts;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsBalloonProblemNotifier
implements Runnable {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("Common Version Control Messages");
    private final Project myProject;
    private final @NlsContexts.NotificationContent String myMessage;
    private final MessageType myMessageType;
    private final NamedRunnable @Nullable [] myNotificationListener;

    public VcsBalloonProblemNotifier(@NotNull Project project2, @NotNull @NlsContexts.NotificationContent String message2, MessageType messageType) {
        if (project2 == null) {
            VcsBalloonProblemNotifier.$$$reportNull$$$0(0);
        }
        if (message2 == null) {
            VcsBalloonProblemNotifier.$$$reportNull$$$0(1);
        }
        this(project2, message2, messageType, null);
    }

    public VcsBalloonProblemNotifier(@NotNull Project project2, @NlsContexts.NotificationContent @NotNull String message2, MessageType messageType, NamedRunnable @Nullable [] notificationListener) {
        if (project2 == null) {
            VcsBalloonProblemNotifier.$$$reportNull$$$0(2);
        }
        if (message2 == null) {
            VcsBalloonProblemNotifier.$$$reportNull$$$0(3);
        }
        this.myProject = project2;
        this.myMessage = message2;
        this.myMessageType = messageType;
        this.myNotificationListener = notificationListener;
    }

    public static void showOverChangesView(@NotNull Project project2, @NlsContexts.NotificationContent @NotNull String message2, MessageType type2, NamedRunnable ... notificationListener) {
        if (project2 == null) {
            VcsBalloonProblemNotifier.$$$reportNull$$$0(4);
        }
        if (message2 == null) {
            VcsBalloonProblemNotifier.$$$reportNull$$$0(5);
        }
        VcsBalloonProblemNotifier.show(project2, message2, type2, notificationListener);
    }

    public static void showOverVersionControlView(@NotNull Project project2, @NlsContexts.NotificationContent @NotNull String message2, MessageType type2) {
        if (project2 == null) {
            VcsBalloonProblemNotifier.$$$reportNull$$$0(6);
        }
        if (message2 == null) {
            VcsBalloonProblemNotifier.$$$reportNull$$$0(7);
        }
        VcsBalloonProblemNotifier.show(project2, message2, type2, null);
    }

    private static void show(Project project2, @NlsContexts.NotificationContent String message2, MessageType type2, NamedRunnable @Nullable [] notificationListener) {
        Application application = ApplicationManager.getApplication();
        if (application.isHeadlessEnvironment()) {
            return;
        }
        Runnable showErrorAction = () -> new VcsBalloonProblemNotifier(project2, message2, type2, notificationListener).run();
        if (application.isDispatchThread()) {
            showErrorAction.run();
        } else {
            application.invokeLater(showErrorAction);
        }
    }

    @Override
    public void run() {
        Notification notification;
        if (this.myNotificationListener != null && this.myNotificationListener.length > 0) {
            @Nls StringBuilder sb = new StringBuilder(this.myMessage);
            for (NamedRunnable runnable : this.myNotificationListener) {
                String name = runnable.toString();
                sb.append("<br/><a href=\"").append(name).append("\">").append(name).append("</a>");
            }
            notification = NOTIFICATION_GROUP.createNotification(sb.toString(), this.myMessageType.toNotificationType()).setListener((currentNotification, event) -> {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(event.getEventType())) {
                    if (this.myNotificationListener.length == 1) {
                        this.myNotificationListener[0].run();
                    } else {
                        String description2 = event.getDescription();
                        if (description2 != null) {
                            for (NamedRunnable runnable : this.myNotificationListener) {
                                if (!description2.equals(runnable.toString())) continue;
                                runnable.run();
                                break;
                            }
                        }
                    }
                    currentNotification.expire();
                }
            });
        } else {
            notification = NOTIFICATION_GROUP.createNotification(this.myMessage, this.myMessageType);
        }
        notification.notify(this.myProject.isDefault() ? null : this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/ui/VcsBalloonProblemNotifier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showOverChangesView";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "showOverVersionControlView";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

