/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.versionBrowser;

import com.intellij.DynamicBundle;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.StandardVersionFilterComponent;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.text.DateFormatUtil;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.michaelbaranov.microba.calendar.DatePicker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DateFilterComponent {
    private JPanel myDatePanel;
    private JCheckBox myUseDateAfterFilter;
    private JCheckBox myUseDateBeforeFilter;
    private DatePicker myDateAfter;
    private DatePicker myDateBefore;
    private JPanel myRootPanel;

    public DateFilterComponent() {
        this(true, DateFormatUtil.getDateTimeFormat().getDelegate());
    }

    public DateFilterComponent(boolean showBorder, @NotNull DateFormat dateFormat) {
        if (dateFormat == null) {
            DateFilterComponent.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        if (showBorder) {
            this.myDatePanel.setBorder(IdeBorderFactory.createTitledBorder((String)VcsBundle.message("border.changes.filter.date.filter", new Object[0])));
        }
        this.myDateAfter.setDateFormat(dateFormat);
        this.myDateBefore.setDateFormat(dateFormat);
        ActionListener listener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateFilterComponent.this.updateAllEnabled(e);
            }
        };
        this.myUseDateAfterFilter.addActionListener(listener2);
        this.myUseDateBeforeFilter.addActionListener(listener2);
        this.updateAllEnabled(null);
    }

    private void updateAllEnabled(@Nullable ActionEvent e) {
        StandardVersionFilterComponent.updatePair(this.myUseDateBeforeFilter, (JComponent)this.myDateBefore, e);
        StandardVersionFilterComponent.updatePair(this.myUseDateAfterFilter, (JComponent)this.myDateAfter, e);
    }

    @NotNull
    public JPanel getPanel() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            DateFilterComponent.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    public void setBefore(long beforeTs) {
        this.myUseDateBeforeFilter.setSelected(true);
        try {
            this.myDateBefore.setDate(new Date(beforeTs));
            this.myDateBefore.setEnabled(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void setAfter(long afterTs) {
        this.myUseDateAfterFilter.setSelected(true);
        try {
            this.myDateAfter.setDate(new Date(afterTs));
            this.myDateAfter.setEnabled(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public long getBefore() {
        return this.myUseDateBeforeFilter.isSelected() ? this.myDateBefore.getDate().getTime() : -1L;
    }

    public long getAfter() {
        return this.myUseDateAfterFilter.isSelected() ? this.myDateAfter.getDate().getTime() : -1L;
    }

    public void initValues(@NotNull ChangeBrowserSettings settings) {
        if (settings == null) {
            DateFilterComponent.$$$reportNull$$$0(2);
        }
        this.myUseDateBeforeFilter.setSelected(settings.USE_DATE_BEFORE_FILTER);
        this.myUseDateAfterFilter.setSelected(settings.USE_DATE_AFTER_FILTER);
        try {
            this.myDateBefore.setDate(settings.getDateBefore());
            this.myDateAfter.setDate(settings.getDateAfter());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.updateAllEnabled(null);
    }

    public void saveValues(@NotNull ChangeBrowserSettings settings) {
        if (settings == null) {
            DateFilterComponent.$$$reportNull$$$0(3);
        }
        settings.USE_DATE_BEFORE_FILTER = this.myUseDateBeforeFilter.isSelected();
        settings.USE_DATE_AFTER_FILTER = this.myUseDateAfterFilter.isSelected();
        settings.setDateBefore(this.myDateBefore.getDate());
        settings.setDateAfter(this.myDateAfter.getDate());
    }

    @Nls
    @Nullable
    public String validateInput() {
        if (this.myUseDateAfterFilter.isSelected() && this.myDateAfter.getDate() == null) {
            return VcsBundle.message("error.date.after.must.be.a.valid.date", new Object[0]);
        }
        if (this.myUseDateBeforeFilter.isSelected() && this.myDateBefore.getDate() == null) {
            return VcsBundle.message("error.date.before.must.be.a.valid.date", new Object[0]);
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        DatePicker datePicker;
        DatePicker datePicker2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        this.myDatePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel();
        FormLayout formLayout = new FormLayout("fill:d:noGrow,left:4dlu:noGrow,fill:max(d;4px):grow,left:4dlu:noGrow,fill:d:noGrow,left:6dlu:noGrow,fill:max(d;4px):grow", "center:d:grow");
        int[][] nArrayArray = new int[1][];
        int[] nArray = new int[]{3, 7};
        nArrayArray[0] = nArray;
        formLayout.setColumnGroups((int[][])nArrayArray);
        jPanel3.setLayout((LayoutManager)formLayout);
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseDateAfterFilter = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/VcsBundle", DateFilterComponent.class).getString("checkbox.show.changes.after.date"));
        jPanel3.add((Component)jCheckBox2, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myUseDateBeforeFilter = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/VcsBundle", DateFilterComponent.class).getString("checkbox.show.changes.before.date"));
        jPanel3.add((Component)jCheckBox, new CellConstraints(5, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myDateAfter = datePicker2 = new DatePicker();
        jPanel3.add((Component)datePicker2, new CellConstraints(3, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myDateBefore = datePicker = new DatePicker();
        jPanel3.add((Component)datePicker, new CellConstraints(7, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '&') {
                if (++i == string2.length()) break;
                if (!bl && string2.charAt(i) != '&') {
                    bl = true;
                    c = string2.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dateFormat";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/versionBrowser/DateFilterComponent";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/versionBrowser/DateFilterComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initValues";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveValues";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

