/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.vfs;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class ContentRevisionVirtualFile
extends AbstractVcsVirtualFile {
    @NotNull
    private final ContentRevision myContentRevision;
    private volatile byte[] myContent;
    private volatile boolean myContentLoadFailed;
    private final Object LOCK;
    private static final Set<ContentRevisionVirtualFile> ourCache = ContainerUtil.createWeakSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentRevisionVirtualFile create(@NotNull ContentRevision contentRevision) {
        if (contentRevision == null) {
            ContentRevisionVirtualFile.$$$reportNull$$$0(0);
        }
        Set<ContentRevisionVirtualFile> set = ourCache;
        synchronized (set) {
            for (ContentRevisionVirtualFile file : ourCache) {
                if (!contentRevision.equals(file.getContentRevision())) continue;
                return file;
            }
            ContentRevisionVirtualFile file = new ContentRevisionVirtualFile(contentRevision);
            ourCache.add(file);
            return file;
        }
    }

    private ContentRevisionVirtualFile(@NotNull ContentRevision contentRevision) {
        if (contentRevision == null) {
            ContentRevisionVirtualFile.$$$reportNull$$$0(1);
        }
        super(contentRevision.getFile().getPath(), (VirtualFileSystem)VcsFileSystem.getInstance());
        this.LOCK = new Object();
        this.myContentRevision = contentRevision;
        this.setCharset(StandardCharsets.UTF_8);
    }

    public boolean isDirectory() {
        return false;
    }

    @Override
    public byte @NotNull [] contentsToByteArray() {
        if (this.myContentLoadFailed) {
            if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
                ContentRevisionVirtualFile.$$$reportNull$$$0(2);
            }
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        if (this.myContent == null) {
            this.loadContent();
        }
        if (this.myContent == null) {
            ContentRevisionVirtualFile.$$$reportNull$$$0(3);
        }
        return this.myContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadContent() {
        try {
            byte[] bytes = ChangesUtil.loadContentRevision(this.myContentRevision);
            Object object = this.LOCK;
            synchronized (object) {
                this.myContent = bytes;
                this.myContentLoadFailed = false;
                this.setRevision(this.myContentRevision.getRevisionNumber().asString());
            }
        }
        catch (VcsException e) {
            Object object = this.LOCK;
            synchronized (object) {
                this.myContentLoadFailed = true;
                this.myContent = ArrayUtilRt.EMPTY_BYTE_ARRAY;
                this.setRevision("0");
            }
            this.showLoadingContentFailedMessage(e);
        }
    }

    @NotNull
    public ContentRevision getContentRevision() {
        ContentRevision contentRevision = this.myContentRevision;
        if (contentRevision == null) {
            ContentRevisionVirtualFile.$$$reportNull$$$0(4);
        }
        return contentRevision;
    }

    @Override
    @Nls
    @NotNull
    protected String getPresentableName(@Nls @NotNull String baseName) {
        VcsRevisionNumber number;
        if (baseName == null) {
            ContentRevisionVirtualFile.$$$reportNull$$$0(5);
        }
        if ((number = this.getContentRevision().getRevisionNumber()) instanceof ShortVcsRevisionNumber) {
            String string2 = baseName + " (" + ((ShortVcsRevisionNumber)number).toShortString() + ")";
            if (string2 == null) {
                ContentRevisionVirtualFile.$$$reportNull$$$0(6);
            }
            return string2;
        }
        String string3 = super.getPresentableName(baseName);
        if (string3 == null) {
            ContentRevisionVirtualFile.$$$reportNull$$$0(7);
        }
        return string3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRevision";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/vfs/ContentRevisionVirtualFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/vfs/ContentRevisionVirtualFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRevision";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4, 6, 7 -> new IllegalStateException(string2);
        };
    }
}

