/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.text.TextEditorPsiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.refactoring.actions.RenameElementAction;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.spellchecker.quickfixes.DictionarySuggestionProvider;
import com.intellij.spellchecker.quickfixes.LazySuggestions;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import icons.SpellcheckerIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameTo
extends LazySuggestions
implements SpellCheckerQuickFix {
    public RenameTo(String wordWithTypo) {
        super(wordWithTypo);
    }

    @NotNull
    public String getFamilyName() {
        String string2 = RenameTo.getFixName();
        if (string2 == null) {
            RenameTo.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Nullable
    private static DictionarySuggestionProvider findProvider() {
        for (Object extension : NameSuggestionProvider.EP_NAME.getExtensionList()) {
            if (!(extension instanceof DictionarySuggestionProvider)) continue;
            return (DictionarySuggestionProvider)((Object)extension);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        PsiElement psiElement;
        DictionarySuggestionProvider provider;
        if (project2 == null) {
            RenameTo.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            RenameTo.$$$reportNull$$$0(2);
        }
        if ((provider = RenameTo.findProvider()) != null) {
            provider.setActive(true);
        }
        if ((psiElement = descriptor.getPsiElement()) == null) {
            return;
        }
        Editor editor = this.getEditor(psiElement, project2);
        if (editor == null) {
            return;
        }
        SimpleDataContext.Builder builder2 = SimpleDataContext.builder();
        if (editor instanceof EditorWindow) {
            builder2.add(CommonDataKeys.EDITOR, (Object)editor);
            builder2.add(CommonDataKeys.PSI_ELEMENT, (Object)psiElement);
        } else if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiElement data2 = (PsiElement)new TextEditorPsiDataProvider().getData(CommonDataKeys.PSI_ELEMENT.getName(), editor, editor.getCaretModel().getCurrentCaret());
            builder2.add(CommonDataKeys.PSI_ELEMENT, (Object)data2);
        }
        Boolean selectAll = (Boolean)editor.getUserData(RenameHandlerRegistry.SELECT_ALL);
        try {
            editor.putUserData(RenameHandlerRegistry.SELECT_ALL, (Object)true);
            DataContext dataContext = builder2.setParent(EditorUtil.getEditorDataContext((Editor)editor)).build();
            RenameElementAction action2 = new RenameElementAction();
            AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action2, null, (String)"", (DataContext)dataContext);
            action2.actionPerformed(event);
            if (provider != null) {
                provider.setActive(false);
            }
        }
        finally {
            editor.putUserData(RenameHandlerRegistry.SELECT_ALL, (Object)selectAll);
        }
    }

    @Nls
    public static String getFixName() {
        return SpellCheckerBundle.message("rename.to", new Object[0]);
    }

    public Icon getIcon(int flags) {
        return SpellcheckerIcons.Spellcheck;
    }

    @Nullable
    protected Editor getEditor(PsiElement element, @NotNull Project project2) {
        if (project2 == null) {
            RenameTo.$$$reportNull$$$0(3);
        }
        Editor editor = null;
        if (InjectedLanguageUtil.findInjectionHost((PsiElement)element) != null) {
            editor = InjectedLanguageUtil.openEditorFor((PsiFile)element.getContainingFile(), (Project)project2);
        }
        if (editor == null) {
            editor = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
        }
        if (editor == null) {
            editor = PsiEditorUtil.findEditor((PsiElement)element);
        }
        return editor;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/quickfixes/RenameTo";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/quickfixes/RenameTo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3 -> new IllegalArgumentException(string2);
        };
    }
}

