/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelperBase;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class FindInFilesOptimizingSearchHelper
extends OptimizingSearchHelperBase {
    private Set<VirtualFile> filesToScan;
    private Set<VirtualFile> filesToScan2;
    private final Project myProject;
    private final SearchScope myScope;
    private final boolean myCaseSensitive;
    private boolean myTransactionStarted;

    FindInFilesOptimizingSearchHelper(SearchScope scope2, boolean caseSensitive, @NotNull Project project2) {
        if (project2 == null) {
            FindInFilesOptimizingSearchHelper.$$$reportNull$$$0(0);
        }
        this.myScope = scope2;
        this.myCaseSensitive = caseSensitive;
        this.myProject = project2;
        if (scope2 instanceof GlobalSearchScope) {
            this.filesToScan = new HashSet<VirtualFile>();
            this.filesToScan2 = new HashSet<VirtualFile>();
        }
    }

    @Override
    public boolean doOptimizing() {
        return this.myScope instanceof GlobalSearchScope;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.filesToScan != null) {
            this.filesToScan.clear();
            this.filesToScan2.clear();
        }
    }

    @Override
    protected void doAddSearchWordInCode(@NotNull String word) {
        if (word == null) {
            FindInFilesOptimizingSearchHelper.$$$reportNull$$$0(1);
        }
        this.myTransactionStarted = true;
        VirtualFile[] files2 = CacheManager.getInstance((Project)this.myProject).getVirtualFilesWithWord(word, (short)17, (GlobalSearchScope)this.myScope, this.myCaseSensitive);
        this.process(files2);
    }

    @Override
    protected void doAddSearchWordInText(@NotNull String word) {
        if (word == null) {
            FindInFilesOptimizingSearchHelper.$$$reportNull$$$0(2);
        }
        this.myTransactionStarted = true;
        VirtualFile[] files2 = CacheManager.getInstance((Project)this.myProject).getVirtualFilesWithWord(word, (short)16, (GlobalSearchScope)this.myScope, this.myCaseSensitive);
        this.process(files2);
    }

    @Override
    protected void doAddSearchWordInComments(@NotNull String word) {
        if (word == null) {
            FindInFilesOptimizingSearchHelper.$$$reportNull$$$0(3);
        }
        this.myTransactionStarted = true;
        VirtualFile[] files2 = CacheManager.getInstance((Project)this.myProject).getVirtualFilesWithWord(word, (short)2, (GlobalSearchScope)this.myScope, this.myCaseSensitive);
        this.process(files2);
    }

    @Override
    protected void doAddSearchWordInLiterals(@NotNull String word) {
        if (word == null) {
            FindInFilesOptimizingSearchHelper.$$$reportNull$$$0(4);
        }
        this.myTransactionStarted = true;
        VirtualFile[] files2 = CacheManager.getInstance((Project)this.myProject).getVirtualFilesWithWord(word, (short)4, (GlobalSearchScope)this.myScope, this.myCaseSensitive);
        this.process(files2);
    }

    @Override
    public void endTransaction() {
        if (!this.myTransactionStarted) {
            return;
        }
        this.myTransactionStarted = false;
        super.endTransaction();
        Set<VirtualFile> map2 = this.filesToScan;
        if (!map2.isEmpty()) {
            map2.clear();
        }
        this.filesToScan = this.filesToScan2;
        this.filesToScan2 = map2;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getFilesSetToScan() {
        assert (!this.myTransactionStarted);
        if (this.filesToScan == null) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                FindInFilesOptimizingSearchHelper.$$$reportNull$$$0(5);
            }
            return set;
        }
        Set<VirtualFile> set = this.filesToScan;
        if (set == null) {
            FindInFilesOptimizingSearchHelper.$$$reportNull$$$0(6);
        }
        return set;
    }

    private void process(VirtualFile @NotNull [] files2) {
        if (files2 == null) {
            FindInFilesOptimizingSearchHelper.$$$reportNull$$$0(7);
        }
        if (this.scanRequest == 0) {
            Collections.addAll(this.filesToScan2, files2);
        } else {
            for (VirtualFile file : files2) {
                if (!this.filesToScan.contains(file)) continue;
                this.filesToScan2.add(file);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/compiler/FindInFilesOptimizingSearchHelper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/FindInFilesOptimizingSearchHelper";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesSetToScan";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doAddSearchWordInCode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doAddSearchWordInText";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doAddSearchWordInComments";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doAddSearchWordInLiterals";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 6 -> new IllegalStateException(string2);
        };
    }
}

