/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.options.advanced.AdvancedSettingsChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsMappingListener;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.impl.VcsEP;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.commit.CommitMode;
import com.intellij.vcs.commit.CommitModeManagerKt;
import com.intellij.vcs.commit.NonModalCommitUsagesCollector;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0004\u0010\u0011\u0012\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0006\u0010\u000b\u001a\u00020\u0006J\b\u0010\f\u001a\u00020\u0006H\u0002J\b\u0010\r\u001a\u00020\nH\u0002J\b\u0010\u000e\u001a\u00020\nH\u0002J\b\u0010\u000f\u001a\u00020\nH\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/vcs/commit/CommitModeManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "commitMode", "Lcom/intellij/vcs/commit/CommitMode;", "canSetNonModal", "", "dispose", "", "getCurrentCommitMode", "getNewCommitMode", "scheduleUpdateCommitMode", "subscribeToChanges", "updateCommitMode", "CommitModeListener", "Companion", "MyStartupActivity", "SettingsListener", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nCommitModeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitModeManager.kt\ncom/intellij/vcs/commit/CommitModeManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,195:1\n12271#2,2:196\n*S KotlinDebug\n*F\n+ 1 CommitModeManager.kt\ncom/intellij/vcs/commit/CommitModeManager\n*L\n99#1:196,2\n*E\n"})
public final class CommitModeManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private CommitMode commitMode;
    @JvmField
    @Topic.AppLevel
    @NotNull
    public static final Topic<SettingsListener> SETTINGS = new Topic(SettingsListener.class, Topic.BroadcastDirection.TO_DIRECT_CHILDREN, true);
    @Topic.ProjectLevel
    @NotNull
    private static final Topic<CommitModeListener> COMMIT_MODE_TOPIC = new Topic(CommitModeListener.class, Topic.BroadcastDirection.NONE, true);

    public CommitModeManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.commitMode = CommitMode.PendingCommitMode.INSTANCE;
    }

    private final void scheduleUpdateCommitMode() {
        ApplicationManager.getApplication().invokeLater(this::updateCommitMode, ModalityState.nonModal(), this.project.getDisposed());
    }

    @RequiresEdt
    private final void updateCommitMode() {
        CommitMode newCommitMode = this.getNewCommitMode();
        if (Intrinsics.areEqual((Object)this.commitMode, (Object)newCommitMode)) {
            return;
        }
        this.commitMode = newCommitMode;
        ((CommitModeListener)this.project.getMessageBus().syncPublisher(COMMIT_MODE_TOPIC)).commitModeChanged();
    }

    private final CommitMode getNewCommitMode() {
        Object[] objectArray = ProjectLevelVcsManager.getInstance(this.project).getAllActiveVcss();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getAllActiveVcss(...)");
        Object[] activeVcses = objectArray;
        AbstractVcs singleVcs = (AbstractVcs)ArraysKt.singleOrNull((Object[])activeVcses);
        if (activeVcses.length == 0) {
            return CommitMode.PendingCommitMode.INSTANCE;
        }
        if (singleVcs != null && singleVcs.isWithCustomLocalChanges()) {
            return new CommitMode.ExternalCommitMode(singleVcs);
        }
        if (Companion.isNonModalInSettings() && this.canSetNonModal()) {
            return new CommitMode.NonModalCommitMode(CommitModeManagerKt.access$isToggleCommitUi());
        }
        return CommitMode.ModalCommitMode.INSTANCE;
    }

    @NotNull
    public final CommitMode getCurrentCommitMode() {
        return this.commitMode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canSetNonModal() {
        if (CommitModeManagerKt.access$isForceNonModalCommit().asBoolean()) {
            return true;
        }
        AbstractVcs[] abstractVcsArray = ProjectLevelVcsManager.getInstance(this.project).getAllActiveVcss();
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"getAllActiveVcss(...)");
        AbstractVcs[] activeVcses = abstractVcsArray;
        if (activeVcses.length == 0) {
            return false;
        }
        boolean bl = false;
        if (bl) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        AbstractVcs[] $this$all$iv = activeVcses;
        boolean $i$f$all = false;
        int n = 0;
        int n2 = $this$all$iv.length;
        while (n < n2) {
            AbstractVcs element$iv;
            AbstractVcs it = element$iv = $this$all$iv[n];
            boolean bl3 = false;
            if (it.getType() != VcsType.distributed) return false;
            boolean bl4 = true;
            if (!bl4) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private final void subscribeToChanges() {
        CommitModeManagerKt.access$isForceNonModalCommit().addListener(new RegistryValueListener(this){
            final /* synthetic */ CommitModeManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void afterValueChanged(@NotNull RegistryValue value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                CommitModeManager.access$updateCommitMode(this.this$0);
            }
        }, (Disposable)this);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(AdvancedSettingsChangeListener.TOPIC, (Object)new AdvancedSettingsChangeListener(this){
            final /* synthetic */ CommitModeManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void advancedSettingChanged(@NotNull String id, @NotNull Object oldValue, @NotNull Object newValue) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
                Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
                if (Intrinsics.areEqual((Object)id, (Object)"vcs.non.modal.commit.toggle.ui")) {
                    CommitModeManager.access$updateCommitMode(this.this$0);
                }
            }
        });
        connection.subscribe(SETTINGS, (Object)new SettingsListener(this){
            final /* synthetic */ CommitModeManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void settingsChanged() {
                CommitModeManager.access$updateCommitMode(this.this$0);
            }
        });
        VcsEP.EP_NAME.addChangeListener(this::scheduleUpdateCommitMode, (Disposable)this);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic<VcsMappingListener> topic = ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"VCS_CONFIGURATION_CHANGED");
        messageBusConnection.subscribe(topic, this::scheduleUpdateCommitMode);
    }

    public void dispose() {
    }

    @JvmStatic
    public static final void subscribeOnCommitModeChange(@NotNull SimpleMessageBusConnection connection, @NotNull CommitModeListener listener2) {
        Companion.subscribeOnCommitModeChange(connection, listener2);
    }

    @JvmStatic
    @NotNull
    public static final CommitModeManager getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @JvmStatic
    public static final void setCommitFromLocalChanges(@Nullable Project project2, boolean value2) {
        Companion.setCommitFromLocalChanges(project2, value2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/vcs/commit/CommitModeManager$CommitModeListener;", "Ljava/util/EventListener;", "commitModeChanged", "", "intellij.platform.vcs.impl"})
    public static interface CommitModeListener
    extends EventListener {
        @RequiresEdt
        public void commitModeChanged();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\rH\u0007J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/vcs/commit/CommitModeManager$Companion;", "", "()V", "COMMIT_MODE_TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/vcs/commit/CommitModeManager$CommitModeListener;", "SETTINGS", "Lcom/intellij/vcs/commit/CommitModeManager$SettingsListener;", "getInstance", "Lcom/intellij/vcs/commit/CommitModeManager;", "project", "Lcom/intellij/openapi/project/Project;", "isNonModalInSettings", "", "setCommitFromLocalChanges", "", "value", "subscribeOnCommitModeChange", "connection", "Lcom/intellij/util/messages/SimpleMessageBusConnection;", "listener", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nCommitModeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitModeManager.kt\ncom/intellij/vcs/commit/CommitModeManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,195:1\n30#2,3:196\n*S KotlinDebug\n*F\n+ 1 CommitModeManager.kt\ncom/intellij/vcs/commit/CommitModeManager$Companion\n*L\n137#1:196,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void subscribeOnCommitModeChange(@NotNull SimpleMessageBusConnection connection, @NotNull CommitModeListener listener2) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            connection.subscribe(COMMIT_MODE_TOPIC, (Object)listener2);
        }

        @JvmStatic
        @NotNull
        public final CommitModeManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<CommitModeManager> serviceClass$iv = CommitModeManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (CommitModeManager)object;
        }

        @JvmStatic
        public final void setCommitFromLocalChanges(@Nullable Project project2, boolean value2) {
            boolean oldValue = CommitModeManagerKt.access$getAppSettings().COMMIT_FROM_LOCAL_CHANGES;
            if (oldValue == value2) {
                return;
            }
            CommitModeManagerKt.access$getAppSettings().COMMIT_FROM_LOCAL_CHANGES = value2;
            NonModalCommitUsagesCollector.INSTANCE.logStateChanged(project2);
            ((SettingsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SETTINGS)).settingsChanged();
        }

        public final boolean isNonModalInSettings() {
            return CommitModeManagerKt.access$isForceNonModalCommit().asBoolean() || CommitModeManagerKt.access$getAppSettings().COMMIT_FROM_LOCAL_CHANGES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/vcs/commit/CommitModeManager$MyStartupActivity;", "Lcom/intellij/openapi/vcs/impl/VcsStartupActivity;", "()V", "order", "", "getOrder", "()I", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    public static final class MyStartupActivity
    implements VcsStartupActivity {
        @Override
        public int getOrder() {
            return VcsInitObject.MAPPINGS.getOrder() + 50;
        }

        @Override
        public void runActivity(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            if (project2 instanceof ProjectEx && ((ProjectEx)project2).isLight()) {
                return;
            }
            ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)project2)).execute(() -> MyStartupActivity.runActivity$lambda$0(project2));
        }

        private static final void runActivity$lambda$0(Project $project) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            CommitModeManager commitModeManager = Companion.getInstance($project);
            commitModeManager.subscribeToChanges();
            commitModeManager.updateCommitMode();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/vcs/commit/CommitModeManager$SettingsListener;", "Ljava/util/EventListener;", "settingsChanged", "", "intellij.platform.vcs.impl"})
    public static interface SettingsListener
    extends EventListener {
        public void settingsChanged();
    }
}

