/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.PairFunction;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogListener;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogImpl;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.VisiblePackChangeListener;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractVcsLogUi
implements VcsLogUiEx,
Disposable {
    private static final Logger LOG = Logger.getInstance(AbstractVcsLogUi.class);
    public static final ExtensionPointName<VcsLogHighlighterFactory> LOG_HIGHLIGHTER_FACTORY_EP = ExtensionPointName.create((String)"com.intellij.logHighlighterFactory");
    @NotNull
    private final String myId;
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final VcsLogData myLogData;
    @NotNull
    protected final VcsLogColorManager myColorManager;
    @NotNull
    protected final VcsLogImpl myLog;
    @NotNull
    protected final VisiblePackRefresher myRefresher;
    @NotNull
    protected final CheckedDisposable myDisposableFlag;
    @NotNull
    protected final Collection<VcsLogListener> myLogListeners;
    @NotNull
    protected final VisiblePackChangeListener myVisiblePackChangeListener;
    @NotNull
    protected volatile VisiblePack myVisiblePack;

    public AbstractVcsLogUi(@NotNull String id, @NotNull VcsLogData logData, @NotNull VcsLogColorManager manager, @NotNull VisiblePackRefresher refresher) {
        if (id == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(0);
        }
        if (logData == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(2);
        }
        if (refresher == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(3);
        }
        this.myDisposableFlag = Disposer.newCheckedDisposable();
        this.myLogListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myVisiblePack = VisiblePack.EMPTY;
        this.myId = id;
        this.myProject = logData.getProject();
        this.myLogData = logData;
        this.myRefresher = refresher;
        this.myColorManager = manager;
        Disposer.register((Disposable)this, (Disposable)this.myRefresher);
        Disposer.register((Disposable)this, (Disposable)this.myDisposableFlag);
        this.myLog = new VcsLogImpl(logData, this);
        this.myVisiblePackChangeListener = visiblePack -> UIUtil.invokeLaterIfNeeded(() -> {
            if (!this.myDisposableFlag.isDisposed()) {
                this.setVisiblePack(visiblePack);
            }
        });
        this.myRefresher.addVisiblePackChangeListener(this.myVisiblePackChangeListener);
    }

    @Override
    @NotNull
    public String getId() {
        String string2 = this.myId;
        if (string2 == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(4);
        }
        return string2;
    }

    public void setVisiblePack(@NotNull VisiblePack pack) {
        if (pack == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(5);
        }
        ThreadingAssertions.assertEventDispatchThread();
        boolean permGraphChanged = this.myVisiblePack.getDataPack() != pack.getDataPack();
        this.myVisiblePack = pack;
        this.onVisiblePackUpdated(permGraphChanged);
        this.fireFilterChangeEvent(this.myVisiblePack, permGraphChanged);
        this.getTable().repaint();
    }

    protected abstract void onVisiblePackUpdated(boolean var1);

    @Override
    @NotNull
    public VisiblePackRefresher getRefresher() {
        VisiblePackRefresher visiblePackRefresher = this.myRefresher;
        if (visiblePackRefresher == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(6);
        }
        return visiblePackRefresher;
    }

    @Override
    @NotNull
    public VcsLogColorManager getColorManager() {
        VcsLogColorManager vcsLogColorManager = this.myColorManager;
        if (vcsLogColorManager == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(7);
        }
        return vcsLogColorManager;
    }

    @Override
    @NotNull
    public VcsLog getVcsLog() {
        VcsLogImpl vcsLogImpl = this.myLog;
        if (vcsLogImpl == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(8);
        }
        return vcsLogImpl;
    }

    @Override
    @NotNull
    public VcsLogData getLogData() {
        VcsLogData vcsLogData = this.myLogData;
        if (vcsLogData == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(9);
        }
        return vcsLogData;
    }

    public void requestMore(@NotNull Runnable onLoaded) {
        if (onLoaded == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(10);
        }
        this.myRefresher.moreCommitsNeeded(onLoaded);
        this.getTable().setPaintBusy(true);
    }

    @Override
    @NotNull
    public VisiblePack getDataPack() {
        VisiblePack visiblePack = this.myVisiblePack;
        if (visiblePack == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(11);
        }
        return visiblePack;
    }

    @Override
    public <T> void jumpTo(@NotNull T commitId2, @NotNull PairFunction<? super VisiblePack, ? super T, Integer> rowGetter, @NotNull SettableFuture<VcsLogUiEx.JumpResult> future2, boolean silently, boolean focus) {
        if (commitId2 == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(12);
        }
        if (rowGetter == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(13);
        }
        if (future2 == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(14);
        }
        if (!silently) {
            future2.addListener(() -> {
                try {
                    VcsLogUiEx.JumpResult result2 = (VcsLogUiEx.JumpResult)((Object)((Object)future2.get()));
                    if (result2 != VcsLogUiEx.JumpResult.SUCCESS) {
                        this.handleCommitNotFound(commitId2, result2 == VcsLogUiEx.JumpResult.COMMIT_DOES_NOT_MATCH, rowGetter);
                    }
                }
                catch (InterruptedException | CancellationException | ExecutionException exception) {
                    // empty catch block
                }
            }, MoreExecutors.directExecutor());
        }
        this.tryJumpTo(commitId2, rowGetter, future2, focus);
    }

    public <T> void tryJumpTo(@NotNull T commitId2, @NotNull PairFunction<? super VisiblePack, ? super T, Integer> rowGetter, @NotNull SettableFuture<VcsLogUiEx.JumpResult> future2, boolean focus) {
        if (commitId2 == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(15);
        }
        if (rowGetter == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(16);
        }
        if (future2 == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(17);
        }
        if (future2.isCancelled()) {
            return;
        }
        GraphTableModel model2 = this.getTable().getModel();
        int result2 = (Integer)rowGetter.fun((Object)this.myVisiblePack, commitId2);
        if (result2 >= 0) {
            this.getTable().jumpToRow(result2, focus);
            future2.set((Object)VcsLogUiEx.JumpResult.SUCCESS);
        } else if (model2.canRequestMore()) {
            model2.requestToLoadMore(() -> this.tryJumpTo(commitId2, rowGetter, future2, focus));
        } else if (this.myLogData.getDataPack() != this.myVisiblePack.getDataPack()) {
            this.invokeOnChange(() -> this.tryJumpTo(commitId2, rowGetter, future2, focus));
        } else if (this.myVisiblePack.getDataPack() instanceof DataPack.ErrorDataPack || this.myVisiblePack instanceof VisiblePack.ErrorVisiblePack) {
            future2.set((Object)VcsLogUiEx.JumpResult.fromInt(result2));
        } else if (!this.myVisiblePack.isFull()) {
            this.invokeOnChange(() -> this.tryJumpTo(commitId2, rowGetter, future2, focus));
        } else {
            future2.set((Object)VcsLogUiEx.JumpResult.fromInt(result2));
        }
    }

    protected <T> void handleCommitNotFound(@NotNull T commitId2, boolean commitExists, @NotNull PairFunction<? super VisiblePack, ? super T, Integer> rowGetter) {
        if (commitId2 == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(18);
        }
        if (rowGetter == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(19);
        }
        String message2 = AbstractVcsLogUi.getCommitNotFoundMessage(commitId2, commitExists);
        VcsNotifier.getInstance(this.myProject).notifyWarning("vcs.log.commit.not.found", "", message2);
    }

    @NotNull
    @Nls
    protected static <T> String getCommitNotFoundMessage(@NotNull T commitId2, boolean exists2) {
        if (commitId2 == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(20);
        }
        String commitPresentation = AbstractVcsLogUi.getCommitPresentation(commitId2);
        String string2 = exists2 ? VcsLogBundle.message("vcs.log.commit.does.not.match", commitPresentation) : VcsLogBundle.message("vcs.log.commit.not.found", commitPresentation);
        if (string2 == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(21);
        }
        return string2;
    }

    @NotNull
    protected static <T> String getCommitPresentation(@NotNull T commitId2) {
        String commitString;
        if (commitId2 == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(22);
        }
        if (commitId2 instanceof Hash) {
            String string2 = VcsLogBundle.message("vcs.log.commit.prefix", ((Hash)commitId2).toShortString());
            if (string2 == null) {
                AbstractVcsLogUi.$$$reportNull$$$0(23);
            }
            return string2;
        }
        if (commitId2 instanceof String && VcsLogUtil.HASH_PREFIX_REGEX.matcher(commitString = (String)commitId2).matches()) {
            String string3 = VcsLogBundle.message("vcs.log.commit.or.reference.prefix", VcsLogUtil.getShortHash(commitString));
            if (string3 == null) {
                AbstractVcsLogUi.$$$reportNull$$$0(24);
            }
            return string3;
        }
        String string4 = VcsLogBundle.message("vcs.log.commit.or.reference.prefix", commitId2.toString());
        if (string4 == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(25);
        }
        return string4;
    }

    @Override
    public void addLogListener(@NotNull VcsLogListener listener2) {
        if (listener2 == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(26);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.myLogListeners.add(listener2);
    }

    @Override
    public void removeLogListener(@NotNull VcsLogListener listener2) {
        if (listener2 == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(27);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.myLogListeners.remove(listener2);
    }

    protected void fireFilterChangeEvent(@NotNull VisiblePack visiblePack, boolean refresh2) {
        if (visiblePack == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(28);
        }
        ThreadingAssertions.assertEventDispatchThread();
        for (VcsLogListener listener2 : this.myLogListeners) {
            listener2.onChange(visiblePack, refresh2);
        }
    }

    protected void invokeOnChange(@NotNull Runnable runnable) {
        if (runnable == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(29);
        }
        this.invokeOnChange(runnable, (Condition<? super VcsLogDataPack>)Conditions.alwaysTrue());
    }

    protected void invokeOnChange(@NotNull Runnable runnable, @NotNull Condition<? super VcsLogDataPack> condition) {
        if (runnable == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(30);
        }
        if (condition == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(31);
        }
        VcsLogUtil.invokeOnChange(this, runnable, condition);
    }

    public void dispose() {
        ThreadingAssertions.assertEventDispatchThread();
        LOG.debug("Disposing VcsLogUi '" + this.myId + "'");
        this.myRefresher.removeVisiblePackChangeListener(this.myVisiblePackChangeListener);
        this.getTable().removeAllHighlighters();
        this.myVisiblePack = VisiblePack.EMPTY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7, 8, 9, 11, 21, 23, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/AbstractVcsLogUi";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pack";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onLoaded";
                break;
            }
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowGetter";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePack";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/AbstractVcsLogUi";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefresher";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsLog";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogData";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataPack";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitNotFoundMessage";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setVisiblePack";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "requestMore";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "jumpTo";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tryJumpTo";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "handleCommitNotFound";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCommitNotFoundMessage";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCommitPresentation";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addLogListener";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "removeLogListener";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "fireFilterChangeEvent";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnChange";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 6, 7, 8, 9, 11, 21, 23, 24, 25 -> new IllegalStateException(string2);
        };
    }
}

