/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.diff.comparison.TrimUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.commit.message.CommitMessageInspectionProfile;
import com.intellij.vcs.commit.message.SubjectLimitInspection;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommitPresentationUtil {
    @NotNull
    private static final Pattern HASH_PATTERN = Pattern.compile("[0-9a-f]{7,40}", 2);
    @NotNull
    @NlsSafe
    private static final String GO_TO_HASH = "go-to-hash:";
    @NotNull
    @NlsSafe
    private static final String SHOW_HIDE_BRANCHES = "show-hide-branches";
    @NlsSafe
    private static final String ELLIPSIS = "...";
    private static final int BIG_CUT_SIZE = 10;
    private static final double EPSILON = 1.5;

    public static boolean isShowHideBranches(@NotNull HyperlinkEvent e) {
        if (e == null) {
            CommitPresentationUtil.$$$reportNull$$$0(0);
        }
        return SHOW_HIDE_BRANCHES.equals(e.getDescription());
    }

    public static boolean isGoToHash(@NotNull HyperlinkEvent e) {
        if (e == null) {
            CommitPresentationUtil.$$$reportNull$$$0(1);
        }
        return e.getDescription().startsWith(GO_TO_HASH);
    }

    @NotNull
    public static String getAuthorPresentation(@NotNull VcsShortCommitDetails details) {
        if (details == null) {
            CommitPresentationUtil.$$$reportNull$$$0(2);
        }
        String authorString = VcsUserUtil.getShortPresentation(details.getAuthor());
        String string2 = authorString + (VcsUserUtil.isSamePerson(details.getAuthor(), details.getCommitter()) ? "" : "*");
        if (string2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    @Nls
    private static String escapeMultipleSpaces(@NotNull @Nls String text2) {
        if (text2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(4);
        }
        @Nls StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < text2.length(); ++i) {
            if (text2.charAt(i) == ' ') {
                if (i == text2.length() - 1 || text2.charAt(i + 1) != ' ') {
                    result2.append(' ');
                    continue;
                }
                result2.append("&nbsp;");
                continue;
            }
            if (text2.charAt(i) == '\t') {
                result2.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                continue;
            }
            result2.append(text2.charAt(i));
        }
        String string2 = result2.toString();
        if (string2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(5);
        }
        return string2;
    }

    private static @NotNull Set<@NlsSafe String> findHashes(@NotNull @NlsSafe String text2) {
        if (text2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(6);
        }
        HashSet<String> result2 = new HashSet<String>();
        Matcher matcher = HASH_PATTERN.matcher(text2);
        while (matcher.find()) {
            result2.add(matcher.group());
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            CommitPresentationUtil.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @NotNull
    @NlsSafe
    private static String replaceHashes(@NotNull @NlsSafe String s, @NotNull Set<@NlsSafe String> resolvedHashes) {
        if (s == null) {
            CommitPresentationUtil.$$$reportNull$$$0(8);
        }
        if (resolvedHashes == null) {
            CommitPresentationUtil.$$$reportNull$$$0(9);
        }
        Matcher matcher = HASH_PATTERN.matcher(s);
        StringBuilder result2 = new StringBuilder();
        while (matcher.find()) {
            String hash2 = matcher.group();
            if (resolvedHashes.contains(hash2)) {
                hash2 = HtmlChunk.link((String)(GO_TO_HASH + hash2), (String)hash2).toString();
            }
            matcher.appendReplacement(result2, hash2);
        }
        matcher.appendTail(result2);
        String string2 = result2.toString();
        if (string2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(10);
        }
        return string2;
    }

    private static @NotNull Set<@NlsSafe String> findHashes(@NotNull Project project2, @NotNull @NlsSafe String message2) {
        if (project2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(11);
        }
        if (message2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(12);
        }
        HashSet<String> unresolvedHashes = new HashSet<String>();
        IssueLinkHtmlRenderer.formatTextWithLinks(project2, message2, (Convertor<? super String, String>)((Convertor)s -> {
            unresolvedHashes.addAll(CommitPresentationUtil.findHashes(s));
            return s;
        }));
        HashSet<String> hashSet = unresolvedHashes;
        if (hashSet == null) {
            CommitPresentationUtil.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    @NotNull
    @NlsSafe
    private static String formatCommitText(@NotNull Project project2, @NotNull @NlsSafe String fullMessage, @NotNull Set<@NlsSafe String> resolvedHashes) {
        if (project2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(14);
        }
        if (fullMessage == null) {
            CommitPresentationUtil.$$$reportNull$$$0(15);
        }
        if (resolvedHashes == null) {
            CommitPresentationUtil.$$$reportNull$$$0(16);
        }
        fullMessage = VcsUtil.trimCommitMessageToSaneSize(fullMessage);
        Font font = FontUtil.getCommitMessageFont();
        Convertor convertor = s -> CommitPresentationUtil.replaceHashes(s, resolvedHashes);
        Object subject = CommitPresentationUtil.getSubject(fullMessage);
        Object description2 = fullMessage.substring(((String)subject).length());
        if (((String)subject).contains("\n")) {
            return CommitPresentationUtil.formatText(project2, fullMessage, font, font.getStyle(), (Convertor<? super String, String>)convertor);
        }
        if (CommitPresentationUtil.isSubjectMarginEnabled(project2)) {
            int margin = CommitMessageInspectionProfile.getSubjectRightMargin(project2);
            if ((double)((String)subject).length() > (double)margin * 1.5) {
                int placeToCut;
                for (int i = placeToCut = margin - ELLIPSIS.length(); i >= Math.max(margin - 10, 10); --i) {
                    if (((String)subject).charAt(i) != ' ') continue;
                    placeToCut = i;
                    break;
                }
                Object tail = ((String)subject).substring(placeToCut);
                if (TrimUtil.isPunctuation((char)((String)(subject = ((String)subject).substring(0, placeToCut))).charAt(placeToCut - 1))) {
                    tail = StringUtil.trimStart((String)tail, (String)" ");
                } else {
                    subject = (String)subject + ELLIPSIS;
                    tail = ELLIPSIS + (String)tail;
                }
                description2 = "\n\n" + (String)tail + (String)description2;
            }
        }
        String string2 = "<b>" + CommitPresentationUtil.formatText(project2, (String)subject, font, 1, (Convertor<? super String, String>)convertor) + "</b>" + CommitPresentationUtil.formatText(project2, (String)description2, font, font.getStyle(), (Convertor<? super String, String>)convertor);
        if (string2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(17);
        }
        return string2;
    }

    @NotNull
    @NlsSafe
    public static String getSubject(@NotNull @NlsSafe String fullMessage) {
        int separator;
        if (fullMessage == null) {
            CommitPresentationUtil.$$$reportNull$$$0(18);
        }
        String string2 = (separator = fullMessage.indexOf("\n\n")) > 0 ? fullMessage.substring(0, separator) : fullMessage;
        if (string2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(19);
        }
        return string2;
    }

    public static boolean isSubjectMarginEnabled(@NotNull Project project2) {
        if (project2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(20);
        }
        return CommitMessageInspectionProfile.getInstance(project2).isToolEnabled(SubjectLimitInspection.class);
    }

    @NotNull
    private static String formatText(@NotNull Project project2, @NotNull @Nls String text2, @NotNull Font font, int style, @NotNull Convertor<? super String, String> convertor) {
        if (project2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(21);
        }
        if (text2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(22);
        }
        if (font == null) {
            CommitPresentationUtil.$$$reportNull$$$0(23);
        }
        if (convertor == null) {
            CommitPresentationUtil.$$$reportNull$$$0(24);
        }
        String string2 = FontUtil.getHtmlWithFonts(CommitPresentationUtil.escapeMultipleSpaces(IssueLinkHtmlRenderer.formatTextWithLinks(project2, text2, convertor)), style, font);
        if (string2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(25);
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    @Nls
    private static String getAuthorAndCommitterText(@NotNull VcsUser author, long authorTime, @NotNull VcsUser committer, long l) {
        void commitTime;
        if (author == null) {
            CommitPresentationUtil.$$$reportNull$$$0(26);
        }
        if (committer == null) {
            CommitPresentationUtil.$$$reportNull$$$0(27);
        }
        String authorText = VcsLogBundle.message("vcs.log.details.author.on.date.at.time", CommitPresentationUtil.getAuthorName(author), DateFormatUtil.formatDate((long)authorTime), DateFormatUtil.formatTime((long)authorTime));
        HtmlBuilder builder2 = new HtmlBuilder().appendRaw(authorText);
        if (!VcsUserUtil.isSamePerson(author, committer)) {
            builder2.br().append(CommitPresentationUtil.getCommitterHtml(committer, commitTime != authorTime ? Long.valueOf((long)commitTime) : null));
        } else if (authorTime != commitTime) {
            builder2.br().append(CommitPresentationUtil.getCommitterHtml(null, (long)commitTime));
        }
        String string2 = builder2.toString();
        if (string2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(28);
        }
        return string2;
    }

    @NotNull
    private static HtmlChunk getCommitterHtml(@Nullable VcsUser committer, @Nullable Long commitTime) {
        String committed;
        if (committer == null && commitTime == null) {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            if (htmlChunk == null) {
                CommitPresentationUtil.$$$reportNull$$$0(29);
            }
            return htmlChunk;
        }
        String style = "color:#" + ColorUtil.toHex((Color)JBColor.GRAY);
        HtmlChunk.Element graySpan = HtmlChunk.span((String)style);
        if (committer == null) {
            String date = DateFormatUtil.formatDate((long)commitTime);
            String time = DateFormatUtil.formatTime((long)commitTime);
            committed = VcsLogBundle.message("vcs.log.details.committer.info.date.time", date, time);
        } else {
            String by = VcsUserUtil.getShortPresentation(committer) + (String)(!committer.getEmail().isEmpty() ? "</span> " + CommitPresentationUtil.getEmailLink(committer) + "<span style=\"" + style + "\">" : "");
            if (commitTime == null) {
                committed = VcsLogBundle.message("vcs.log.details.committer.info.user", by);
            } else {
                String date = DateFormatUtil.formatDate((long)commitTime);
                String time = DateFormatUtil.formatTime((long)commitTime);
                committed = VcsLogBundle.message("vcs.log.details.committer.info.user.date.time", by, date, time);
            }
        }
        HtmlChunk.Element element = new HtmlBuilder().appendRaw(committed).wrapWith(graySpan);
        if (element == null) {
            CommitPresentationUtil.$$$reportNull$$$0(30);
        }
        return element;
    }

    @NotNull
    @NlsSafe
    private static String getAuthorName(@NotNull VcsUser user) {
        if (user == null) {
            CommitPresentationUtil.$$$reportNull$$$0(31);
        }
        String username = VcsUserUtil.getShortPresentation(user);
        Object object = user.getEmail().isEmpty() ? username : username + " " + CommitPresentationUtil.getEmailLink(user);
        if (object == null) {
            CommitPresentationUtil.$$$reportNull$$$0(32);
        }
        return object;
    }

    @NotNull
    private static HtmlChunk.Element getEmailLink(@NotNull VcsUser user) {
        if (user == null) {
            CommitPresentationUtil.$$$reportNull$$$0(33);
        }
        HtmlChunk.Element element = HtmlChunk.link((String)("mailto:" + user.getEmail()), (String)("<" + user.getEmail() + ">"));
        if (element == null) {
            CommitPresentationUtil.$$$reportNull$$$0(34);
        }
        return element;
    }

    @NotNull
    @Nls
    private static String formatCommitHashAndAuthor(@NotNull VcsCommitMetadata commit2) {
        if (commit2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(35);
        }
        return CommitPresentationUtil.formatCommitHashAndAuthor((Hash)commit2.getId(), commit2.getAuthor(), commit2.getAuthorTime(), commit2.getCommitter(), commit2.getCommitTime());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    @Nls
    public static String formatCommitHashAndAuthor(@NotNull Hash commitId2, @NotNull VcsUser author, long authorTime, @NotNull VcsUser committer, long l) {
        void commitTime;
        if (commitId2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(36);
        }
        if (author == null) {
            CommitPresentationUtil.$$$reportNull$$$0(37);
        }
        if (committer == null) {
            CommitPresentationUtil.$$$reportNull$$$0(38);
        }
        Font font = FontUtil.getCommitMetadataFont();
        String string2 = FontUtil.getHtmlWithFonts(commitId2.toShortString() + " " + CommitPresentationUtil.getAuthorAndCommitterText(author, authorTime, committer, (long)commitTime), font.getStyle(), font);
        if (string2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(39);
        }
        return string2;
    }

    @NotNull
    @Nls
    public static String getBranchesLinkText(@Nullable List<@NlsSafe String> branches, boolean expanded, int availableWidth, @NotNull FontMetrics metrics) {
        if (metrics == null) {
            CommitPresentationUtil.$$$reportNull$$$0(40);
        }
        if (branches == null) {
            String string2 = VcsLogBundle.message("vcs.log.details.in.branches.loading", new Object[0]);
            if (string2 == null) {
                CommitPresentationUtil.$$$reportNull$$$0(41);
            }
            return string2;
        }
        if (branches.isEmpty()) {
            String string3 = VcsLogBundle.message("vcs.log.details.in.branches.empty", new Object[0]);
            if (string3 == null) {
                CommitPresentationUtil.$$$reportNull$$$0(42);
            }
            return string3;
        }
        String head = VcsLogBundle.message("vcs.log.details.in.branches", branches.size()) + " ";
        if (expanded) {
            String string4 = new HtmlBuilder().append(head).append((HtmlChunk)HtmlChunk.link((String)SHOW_HIDE_BRANCHES, (String)VcsLogBundle.message("vcs.log.details.in.branches.hide", new Object[0]))).toString();
            if (string4 == null) {
                CommitPresentationUtil.$$$reportNull$$$0(43);
            }
            return string4;
        }
        String tail = "\u2026 " + HtmlChunk.link((String)SHOW_HIDE_BRANCHES, (String)VcsLogBundle.message("vcs.log.details.in.branches.show.all", new Object[0]));
        int headAndTailWidth = metrics.stringWidth(head) + metrics.stringWidth(StringUtil.removeHtmlTags((String)tail));
        if (availableWidth <= headAndTailWidth) {
            String string5 = head + tail;
            if (string5 == null) {
                CommitPresentationUtil.$$$reportNull$$$0(44);
            }
            return string5;
        }
        availableWidth -= headAndTailWidth;
        StringBuilder branchesText = new StringBuilder();
        for (int i = 0; i < branches.size(); ++i) {
            String branch = branches.get(i) + (i != branches.size() - 1 ? ", " : "");
            int branchWidth = metrics.stringWidth(branch);
            if (branchWidth < availableWidth) {
                branchesText.append(branch);
                availableWidth -= branchWidth;
                continue;
            }
            StringBuilder shortenedBranch = new StringBuilder();
            for (char c : branch.toCharArray()) {
                if (metrics.stringWidth(shortenedBranch.toString() + c) >= availableWidth) break;
                shortenedBranch.append(c);
            }
            branchesText.append((CharSequence)shortenedBranch);
            branchesText.append(tail);
            break;
        }
        String string6 = head + branchesText;
        if (string6 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(45);
        }
        return string6;
    }

    @NotNull
    public static CommitPresentation buildPresentation(@NotNull Project project2, @NotNull VcsCommitMetadata commit2, @NotNull Set<? super String> unresolvedHashes) {
        if (project2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(46);
        }
        if (commit2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(47);
        }
        if (unresolvedHashes == null) {
            CommitPresentationUtil.$$$reportNull$$$0(48);
        }
        String rawMessage = commit2.getFullMessage();
        String hashAndAuthor = CommitPresentationUtil.formatCommitHashAndAuthor(commit2);
        Set<String> unresolvedHashesForCommit = CommitPresentationUtil.findHashes(project2, rawMessage);
        if (unresolvedHashesForCommit.isEmpty()) {
            return new CommitPresentation(project2, commit2.getRoot(), rawMessage, hashAndAuthor, (MultiMap<String, CommitId>)MultiMap.empty());
        }
        unresolvedHashes.addAll(unresolvedHashesForCommit);
        return new UnresolvedPresentation(project2, commit2.getRoot(), rawMessage, hashAndAuthor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7, 10, 13, 17, 19, 25, 28, 29, 30, 32, 34, 39, 41, 42, 43, 44, 45 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 19: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/frame/CommitPresentationUtil";
                break;
            }
            case 4: 
            case 6: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedHashes";
                break;
            }
            case 11: 
            case 14: 
            case 20: 
            case 21: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullMessage";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
            case 26: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "author";
                break;
            }
            case 27: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "committer";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 35: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metrics";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unresolvedHashes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/frame/CommitPresentationUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthorPresentation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeMultipleSpaces";
                break;
            }
            case 7: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findHashes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceHashes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "formatCommitText";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubject";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "formatText";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthorAndCommitterText";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitterHtml";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthorName";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmailLink";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "formatCommitHashAndAuthor";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchesLinkText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isShowHideBranches";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isGoToHash";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAuthorPresentation";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 19: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "escapeMultipleSpaces";
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findHashes";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replaceHashes";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "formatCommitText";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSubject";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isSubjectMarginEnabled";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "formatText";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAuthorAndCommitterText";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getAuthorName";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getEmailLink";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "formatCommitHashAndAuthor";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getBranchesLinkText";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "buildPresentation";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 5, 7, 10, 13, 17, 19, 25, 28, 29, 30, 32, 34, 39, 41, 42, 43, 44, 45 -> new IllegalStateException(string2);
        };
    }

    public static class CommitPresentation {
        @NotNull
        protected final Project myProject;
        @NotNull
        @NlsSafe
        protected final String myRawMessage;
        @NotNull
        @Nls
        protected final String myHashAndAuthor;
        @NotNull
        protected final VirtualFile myRoot;
        private final @NotNull MultiMap<@NlsSafe String, CommitId> myResolvedHashes;

        public CommitPresentation(@NotNull Project project2, @NotNull VirtualFile root, @NotNull @NlsSafe String rawMessage, @NotNull @Nls String hashAndAuthor, @NotNull MultiMap<@NlsSafe String, CommitId> resolvedHashes) {
            if (project2 == null) {
                CommitPresentation.$$$reportNull$$$0(0);
            }
            if (root == null) {
                CommitPresentation.$$$reportNull$$$0(1);
            }
            if (rawMessage == null) {
                CommitPresentation.$$$reportNull$$$0(2);
            }
            if (hashAndAuthor == null) {
                CommitPresentation.$$$reportNull$$$0(3);
            }
            if (resolvedHashes == null) {
                CommitPresentation.$$$reportNull$$$0(4);
            }
            this.myProject = project2;
            this.myRoot = root;
            this.myRawMessage = rawMessage;
            this.myHashAndAuthor = hashAndAuthor;
            this.myResolvedHashes = resolvedHashes;
        }

        @NotNull
        @NlsSafe
        public String getText() {
            String string2 = CommitPresentationUtil.formatCommitText(this.myProject, this.myRawMessage, this.myResolvedHashes.keySet());
            if (string2 == null) {
                CommitPresentation.$$$reportNull$$$0(5);
            }
            return string2;
        }

        @NotNull
        @Nls
        public String getHashAndAuthor() {
            String string2 = this.myHashAndAuthor;
            if (string2 == null) {
                CommitPresentation.$$$reportNull$$$0(6);
            }
            return string2;
        }

        @Nullable
        public CommitId parseTargetCommit(@NotNull HyperlinkEvent e) {
            if (e == null) {
                CommitPresentation.$$$reportNull$$$0(7);
            }
            if (!e.getDescription().startsWith(CommitPresentationUtil.GO_TO_HASH)) {
                return null;
            }
            String hash2 = e.getDescription().substring(CommitPresentationUtil.GO_TO_HASH.length());
            Collection ids = this.myResolvedHashes.get((Object)hash2);
            if (ids.size() <= 1) {
                return (CommitId)ContainerUtil.getFirstItem((Collection)ids);
            }
            for (CommitId id : ids) {
                if (!this.myRoot.equals(id.getRoot())) continue;
                return id;
            }
            return (CommitId)ContainerUtil.getFirstItem((Collection)ids);
        }

        @NotNull
        public CommitPresentation resolve(@NotNull MultiMap<String, CommitId> resolvedHashes) {
            if (resolvedHashes == null) {
                CommitPresentation.$$$reportNull$$$0(8);
            }
            CommitPresentation commitPresentation = this;
            if (commitPresentation == null) {
                CommitPresentation.$$$reportNull$$$0(9);
            }
            return commitPresentation;
        }

        public boolean isResolved() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rawMessage";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hashAndAuthor";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedHashes";
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/frame/CommitPresentationUtil$CommitPresentation";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/frame/CommitPresentationUtil$CommitPresentation";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHashAndAuthor";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "parseTargetCommit";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 5, 6, 9 -> new IllegalStateException(string2);
            };
        }
    }

    private static class UnresolvedPresentation
    extends CommitPresentation {
        UnresolvedPresentation(@NotNull Project project2, @NotNull VirtualFile root, @NotNull @NlsSafe String rawMessage, @NotNull @Nls String hashAndAuthor) {
            if (project2 == null) {
                UnresolvedPresentation.$$$reportNull$$$0(0);
            }
            if (root == null) {
                UnresolvedPresentation.$$$reportNull$$$0(1);
            }
            if (rawMessage == null) {
                UnresolvedPresentation.$$$reportNull$$$0(2);
            }
            if (hashAndAuthor == null) {
                UnresolvedPresentation.$$$reportNull$$$0(3);
            }
            super(project2, root, rawMessage, hashAndAuthor, (MultiMap<String, CommitId>)MultiMap.empty());
        }

        @Override
        @NotNull
        public CommitPresentation resolve(@NotNull MultiMap<String, CommitId> resolvedHashes) {
            if (resolvedHashes == null) {
                UnresolvedPresentation.$$$reportNull$$$0(4);
            }
            return new CommitPresentation(this.myProject, this.myRoot, this.myRawMessage, this.myHashAndAuthor, resolvedHashes);
        }

        @Override
        public boolean isResolved() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rawMessage";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hashAndAuthor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedHashes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/frame/CommitPresentationUtil$UnresolvedPresentation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolve";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

