/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table.column;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.graph.DefaultColorGenerator;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.paint.GraphCellPainter;
import com.intellij.vcs.log.paint.SimpleGraphCellPainter;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import com.intellij.vcs.log.ui.render.GraphCommitCellRenderer;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.ui.table.column.VcsLogDefaultColumn;
import com.intellij.vcs.log.ui.table.column.VcsLogDefaultColumnKt;
import com.intellij.vcs.log.ui.table.column.VcsLogMetadataColumn;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.Collection;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/vcs/log/ui/table/column/Commit;", "Lcom/intellij/vcs/log/ui/table/column/VcsLogDefaultColumn;", "Lcom/intellij/vcs/log/ui/render/GraphCommitCell;", "Lcom/intellij/vcs/log/ui/table/column/VcsLogMetadataColumn;", "()V", "createTableCellRenderer", "Ljavax/swing/table/TableCellRenderer;", "table", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "getStubValue", "model", "Lcom/intellij/vcs/log/ui/table/GraphTableModel;", "getValue", "", "commit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "row", "", "intellij.platform.vcs.log.impl"})
public final class Commit
extends VcsLogDefaultColumn<GraphCommitCell>
implements VcsLogMetadataColumn {
    @NotNull
    public static final Commit INSTANCE = new Commit();

    private Commit() {
        String string2 = VcsLogBundle.message("vcs.log.column.subject", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        super("Default.Subject", string2, false, null);
    }

    @Override
    @NotNull
    public GraphCommitCell getValue(@NotNull GraphTableModel model2, int row2) {
        Collection<PrintElement> collection;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Object object = VisiblePack.NO_GRAPH_INFORMATION.get((UserDataHolder)model2.getVisiblePack(), (Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (((Boolean)object).booleanValue()) {
            collection = CollectionsKt.emptyList();
        } else {
            Collection<PrintElement> collection2 = model2.getVisiblePack().getVisibleGraph().getRowInfo(row2).getPrintElements();
            collection = collection2;
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"getPrintElements(...)");
        }
        Collection<PrintElement> printElements = collection;
        VcsCommitMetadata vcsCommitMetadata = model2.getCommitMetadata(row2, true);
        Intrinsics.checkNotNullExpressionValue((Object)vcsCommitMetadata, (String)"getCommitMetadata(...)");
        return new GraphCommitCell(this.getValue(model2, vcsCommitMetadata), (Collection<VcsRef>)model2.getRefsAtRow(row2), printElements);
    }

    @Override
    @NotNull
    public String getValue(@NotNull GraphTableModel model2, @NotNull VcsCommitMetadata commit2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)commit2, (String)"commit");
        String string2 = commit2.getSubject();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSubject(...)");
        return string2;
    }

    @Override
    @NotNull
    public TableCellRenderer createTableCellRenderer(@NotNull VcsLogGraphTable table) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        DefaultColorGenerator defaultColorGenerator = new DefaultColorGenerator();
        GraphCellPainter graphCellPainter2 = new SimpleGraphCellPainter(table, defaultColorGenerator){
            final /* synthetic */ VcsLogGraphTable $table;
            {
                this.$table = $table;
                super($super_call_param$1);
            }

            protected int getRowHeight() {
                return this.$table.getRowHeight();
            }
        };
        GraphCommitCellRenderer commitCellRenderer = new GraphCommitCellRenderer(table.getLogData(), graphCellPainter2, table);
        Boolean bl = table.getProperties().get(CommonUiProperties.COMPACT_REFERENCES_VIEW);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        commitCellRenderer.setCompactReferencesView(bl);
        Boolean bl2 = table.getProperties().get(CommonUiProperties.SHOW_TAG_NAMES);
        Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"get(...)");
        commitCellRenderer.setShowTagsNames(bl2);
        Boolean bl3 = table.getProperties().get(CommonUiProperties.LABELS_LEFT_ALIGNED);
        Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"get(...)");
        commitCellRenderer.setLeftAligned(bl3);
        VcsLogDefaultColumnKt.access$doOnPropertyChange(table, new Function1<VcsLogUiProperties.VcsLogUiProperty<?>, Unit>(commitCellRenderer, table){
            final /* synthetic */ GraphCommitCellRenderer $commitCellRenderer;
            final /* synthetic */ VcsLogGraphTable $table;
            {
                this.$commitCellRenderer = $commitCellRenderer;
                this.$table = $table;
                super(1);
            }

            public final void invoke(@NotNull VcsLogUiProperties.VcsLogUiProperty<?> property2) {
                Intrinsics.checkNotNullParameter(property2, (String)"property");
                if (Intrinsics.areEqual(CommonUiProperties.COMPACT_REFERENCES_VIEW, property2)) {
                    Boolean bl = this.$table.getProperties().get(CommonUiProperties.COMPACT_REFERENCES_VIEW);
                    Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
                    this.$commitCellRenderer.setCompactReferencesView(bl);
                    this.$table.repaint();
                } else if (Intrinsics.areEqual(CommonUiProperties.SHOW_TAG_NAMES, property2)) {
                    Boolean bl = this.$table.getProperties().get(CommonUiProperties.SHOW_TAG_NAMES);
                    Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
                    this.$commitCellRenderer.setShowTagsNames(bl);
                    this.$table.repaint();
                } else if (Intrinsics.areEqual(CommonUiProperties.LABELS_LEFT_ALIGNED, property2)) {
                    Boolean bl = this.$table.getProperties().get(CommonUiProperties.LABELS_LEFT_ALIGNED);
                    Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
                    this.$commitCellRenderer.setLeftAligned(bl);
                    this.$table.repaint();
                }
            }
        });
        VcsLogDefaultColumnKt.access$updateTableOnCommitDetailsLoaded(this, table);
        return commitCellRenderer;
    }

    @Override
    @NotNull
    public GraphCommitCell getStubValue(@NotNull GraphTableModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return new GraphCommitCell("", CollectionsKt.emptyList(), CollectionsKt.emptyList());
    }
}

