/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.ui.JBUI;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.webSymbols.WebSymbolNameSegment;
import com.intellij.webSymbols.impl.WebSymbolsImplUtilsKt;
import com.intellij.webSymbols.query.WebSymbolsListSymbolsQueryParams;
import com.intellij.webSymbols.query.WebSymbolsNameMatchQueryParams;
import com.intellij.webSymbols.query.WebSymbolsQueryParams;
import com.intellij.webSymbols.webTypes.json.WebTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a*\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\b\b\u0000\u0010\u0007*\u00020\b*\b\u0012\u0004\u0012\u0002H\u00070\u00062\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0014\u0010\u000b\u001a\u00020\f*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001ab\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0010\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u0002H\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00100\u00122\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u0002H\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00122\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00170\u0012H\u0000\u001a\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0010*\b\u0012\u0004\u0012\u00020\b0\u00102\b\b\u0002\u0010\u0019\u001a\u00020\u0017H\u0000\"\u001c\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001a"}, d2={"objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "filterByQueryParams", "Lkotlin/sequences/Sequence;", "T", "Lcom/intellij/webSymbols/WebSymbol;", "params", "Lcom/intellij/webSymbols/query/WebSymbolsQueryParams;", "scaleToHeight", "Ljavax/swing/Icon;", "height", "", "selectBest", "", "segmentsProvider", "Lkotlin/Function1;", "Lcom/intellij/webSymbols/WebSymbolNameSegment;", "priorityProvider", "Lcom/intellij/webSymbols/WebSymbol$Priority;", "isExtension", "", "sortSymbolsByPriority", "extensionsLast", "intellij.platform.webSymbols"})
@SourceDebugExtension(value={"SMAP\nWebSymbolsImplUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSymbolsImplUtils.kt\ncom/intellij/webSymbols/impl/WebSymbolsImplUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1855#2:92\n1856#2:94\n1603#2,9:95\n1855#2:104\n1856#2:106\n1612#2:107\n1#3:93\n1#3:105\n*S KotlinDebug\n*F\n+ 1 WebSymbolsImplUtils.kt\ncom/intellij/webSymbols/impl/WebSymbolsImplUtilsKt\n*L\n46#1:92\n46#1:94\n69#1:95,9\n69#1:104\n69#1:106\n69#1:107\n69#1:105\n*E\n"})
public final class WebSymbolsImplUtilsKt {
    private static final ObjectMapper objectMapper;

    public static final ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    @NotNull
    public static final Icon scaleToHeight(@NotNull Icon $this$scaleToHeight, int height) {
        Intrinsics.checkNotNullParameter((Object)$this$scaleToHeight, (String)"<this>");
        float scale = (float)JBUI.scale((int)height) / (float)$this$scaleToHeight.getIconHeight();
        return IconUtil.scale((Icon)$this$scaleToHeight, null, (float)scale);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<T> selectBest(@NotNull List<? extends T> $this$selectBest, @NotNull Function1<? super T, ? extends List<WebSymbolNameSegment>> segmentsProvider, @NotNull Function1<? super T, ? extends WebSymbol.Priority> priorityProvider, @NotNull Function1<? super T, Boolean> isExtension) {
        List list2;
        Intrinsics.checkNotNullParameter($this$selectBest, (String)"<this>");
        Intrinsics.checkNotNullParameter(segmentsProvider, (String)"segmentsProvider");
        Intrinsics.checkNotNullParameter(priorityProvider, (String)"priorityProvider");
        Intrinsics.checkNotNullParameter(isExtension, (String)"isExtension");
        if ($this$selectBest.size() > 1) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Object object3;
            int[] bestWeight = null;
            int[] nArray = new int[]{0, 0, 0};
            bestWeight = nArray;
            List results = new ArrayList();
            List extensions = new ArrayList();
            Iterable $this$forEach$iv = $this$selectBest;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            block0: while (iterator.hasNext()) {
                Object element$iv;
                Object item2 = element$iv = iterator.next();
                boolean bl = false;
                if (!((Boolean)isExtension.invoke(item2)).booleanValue()) {
                    int n;
                    Object v0;
                    Object object2;
                    int[] nArray2;
                    int n2;
                    int[] nArray3;
                    block9: {
                        nArray3 = new int[3];
                        Iterable iterable = (Iterable)segmentsProvider.invoke(item2);
                        n2 = 0;
                        nArray2 = nArray3;
                        Iterable iterable2 = iterable;
                        object3 = iterable2.iterator();
                        while (object3.hasNext()) {
                            object2 = object3.next();
                            WebSymbolNameSegment it = (WebSymbolNameSegment)object2;
                            boolean bl2 = false;
                            if (!(it.getProblem() != null)) continue;
                            v0 = object2;
                            break block9;
                        }
                        v0 = null;
                    }
                    Object var22_36 = v0;
                    WebSymbolNameSegment webSymbolNameSegment = var22_36;
                    nArray2[n2] = webSymbolNameSegment != null ? webSymbolNameSegment.getStart() : Integer.MAX_VALUE;
                    WebSymbol.Priority priority2 = (WebSymbol.Priority)((Object)priorityProvider.invoke(item2));
                    if (priority2 == null) {
                        priority2 = WebSymbol.Priority.NORMAL;
                    }
                    nArray3[1] = priority2.ordinal();
                    Iterable iterable = (Iterable)segmentsProvider.invoke(item2);
                    n2 = 2;
                    nArray2 = nArray3;
                    int n3 = 0;
                    for (Object object3 : iterable) {
                        void it;
                        object2 = (WebSymbolNameSegment)object3;
                        int n4 = n3;
                        boolean bl3 = false;
                        int n5 = it.getMatchScore();
                        n3 = n4 + n5;
                    }
                    nArray2[n2] = n = n3;
                    int[] weight = nArray3;
                    results.add(new Pair(item2, (Object)weight));
                    for (int i = 0; i < 3; ++i) {
                        if (bestWeight[i] >= weight[i]) continue;
                        bestWeight = weight;
                        continue block0;
                    }
                    continue;
                }
                extensions.add(item2);
            }
            $this$forEach$iv = results;
            boolean $i$f$mapNotNull = false;
            iterator = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                object3 = (Pair)element$iv$iv;
                boolean bl4 = false;
                Object item3 = object3.component1();
                int[] weight = (int[])object3.component2();
                if ((Arrays.equals(bestWeight, weight) ? item3 : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)extensions);
        } else {
            list2 = $this$selectBest;
        }
        return list2;
    }

    @NotNull
    public static final List<WebSymbol> sortSymbolsByPriority(@NotNull List<? extends WebSymbol> $this$sortSymbolsByPriority, boolean extensionsLast) {
        Intrinsics.checkNotNullParameter($this$sortSymbolsByPriority, (String)"<this>");
        Iterable iterable = $this$sortSymbolsByPriority;
        Comparator<Object> comparator2 = Comparator.comparingInt(arg_0 -> WebSymbolsImplUtilsKt.sortSymbolsByPriority$lambda$5((Function1)new Function1<WebSymbol, Integer>(extensionsLast){
            final /* synthetic */ boolean $extensionsLast;
            {
                this.$extensionsLast = $extensionsLast;
                super(1);
            }

            @NotNull
            public final Integer invoke(WebSymbol it) {
                return it.isExtension() && this.$extensionsLast ? 1 : 0;
            }
        }, arg_0)).thenComparingInt(arg_0 -> WebSymbolsImplUtilsKt.sortSymbolsByPriority$lambda$6(sortSymbolsByPriority.2.INSTANCE, arg_0)).thenComparingInt(arg_0 -> WebSymbolsImplUtilsKt.sortSymbolsByPriority$lambda$7(sortSymbolsByPriority.3.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"thenComparingInt(...)");
        return CollectionsKt.sortedWith((Iterable)iterable, comparator2);
    }

    public static /* synthetic */ List sortSymbolsByPriority$default(List list2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return WebSymbolsImplUtilsKt.sortSymbolsByPriority(list2, bl);
    }

    @NotNull
    public static final <T extends WebSymbol> Sequence<T> filterByQueryParams(@NotNull Sequence<? extends T> $this$filterByQueryParams, @NotNull WebSymbolsQueryParams params) {
        Intrinsics.checkNotNullParameter($this$filterByQueryParams, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return SequencesKt.filter($this$filterByQueryParams, (Function1)new Function1<T, Boolean>(params){
            final /* synthetic */ WebSymbolsQueryParams $params;
            {
                this.$params = $params;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull T symbol) {
                boolean bl;
                block4: {
                    WebSymbolsQueryParams webSymbolsQueryParams;
                    block5: {
                        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
                        String string2 = symbol.getOrigin().getFramework();
                        webSymbolsQueryParams = this.$params;
                        String it = string2;
                        boolean bl2 = false;
                        if (!(it == null || Intrinsics.areEqual((Object)it, (Object)webSymbolsQueryParams.getFramework()))) break block4;
                        webSymbolsQueryParams = this.$params;
                        WebSymbolsNameMatchQueryParams webSymbolsNameMatchQueryParams = webSymbolsQueryParams instanceof WebSymbolsNameMatchQueryParams ? (WebSymbolsNameMatchQueryParams)webSymbolsQueryParams : null;
                        if (webSymbolsNameMatchQueryParams != null ? webSymbolsNameMatchQueryParams.getAbstractSymbols() : false) break block5;
                        webSymbolsQueryParams = this.$params;
                        WebSymbolsListSymbolsQueryParams webSymbolsListSymbolsQueryParams = webSymbolsQueryParams instanceof WebSymbolsListSymbolsQueryParams ? (WebSymbolsListSymbolsQueryParams)webSymbolsQueryParams : null;
                        boolean bl3 = webSymbolsListSymbolsQueryParams != null ? webSymbolsListSymbolsQueryParams.getAbstractSymbols() : false;
                        if (!bl3 && symbol.isAbstract()) break block4;
                    }
                    WebSymbolsQueryParams webSymbolsQueryParams2 = (webSymbolsQueryParams = this.$params) instanceof WebSymbolsQueryParams ? webSymbolsQueryParams : null;
                    if (!(webSymbolsQueryParams2 != null ? !webSymbolsQueryParams2.getVirtualSymbols() : false) || !symbol.isVirtual()) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        });
    }

    private static final int sortSymbolsByPriority$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final int sortSymbolsByPriority$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final int sortSymbolsByPriority$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void module;
        SimpleModule simpleModule;
        SimpleModule simpleModule2 = simpleModule = new SimpleModule();
        ObjectMapper objectMapper2 = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setTypeFactory(TypeFactory.defaultInstance().withClassLoader(WebTypes.class.getClassLoader()));
        boolean bl = false;
        Interner interner = Interner.createStringInterner();
        Intrinsics.checkNotNullExpressionValue((Object)interner, (String)"createStringInterner(...)");
        Interner interner2 = interner;
        module.addDeserializer(String.class, (JsonDeserializer)new StringDeserializer((Interner<String>)interner2){
            final /* synthetic */ Interner<String> $interner;
            {
                this.$interner = $interner;
            }

            @Nullable
            public String deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
                String string2;
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
                String string3 = super.deserialize(p, ctxt);
                if (string3 != null) {
                    String string4 = string3;
                    Interner<String> interner = this.$interner;
                    String it = string4;
                    boolean bl = false;
                    string2 = (String)interner.intern((Object)it);
                } else {
                    string2 = null;
                }
                return string2;
            }
        });
        objectMapper = objectMapper2.registerModule((Module)simpleModule);
    }
}

