/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.search;

import com.intellij.codeWithMe.ClientId;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.model.psi.PsiSymbolReferenceHints;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.util.Processor;
import com.intellij.webSymbols.PsiSourcedWebSymbol;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.webSymbols.references.WebSymbolReference;
import com.intellij.webSymbols.search.PsiSourcedWebSymbolReference;
import com.intellij.webSymbols.search.PsiSourcedWebSymbolRequestResultProcessor$processTextOccurrence$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00120\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/webSymbols/search/PsiSourcedWebSymbolRequestResultProcessor;", "Lcom/intellij/psi/search/RequestResultProcessor;", "targetElement", "Lcom/intellij/psi/PsiElement;", "includeRegularReferences", "", "(Lcom/intellij/psi/PsiElement;Z)V", "myPsiReferenceService", "Lcom/intellij/psi/PsiReferenceService;", "kotlin.jvm.PlatformType", "mySymbolReferenceService", "Lcom/intellij/model/psi/PsiSymbolReferenceService;", "processTextOccurrence", "element", "offsetInElement", "", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiReference;", "intellij.platform.webSymbols"})
@SourceDebugExtension(value={"SMAP\nPsiSourcedWebSymbolRequestResultProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiSourcedWebSymbolRequestResultProcessor.kt\ncom/intellij/webSymbols/search/PsiSourcedWebSymbolRequestResultProcessor\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n43#2,3:64\n473#3:67\n1313#3:68\n1314#3:81\n800#4,11:69\n1#5:80\n*S KotlinDebug\n*F\n+ 1 PsiSourcedWebSymbolRequestResultProcessor.kt\ncom/intellij/webSymbols/search/PsiSourcedWebSymbolRequestResultProcessor\n*L\n20#1:64,3\n31#1:67\n33#1:68\n33#1:81\n35#1:69,11\n*E\n"})
public final class PsiSourcedWebSymbolRequestResultProcessor
extends RequestResultProcessor {
    @NotNull
    private final PsiElement targetElement;
    private final boolean includeRegularReferences;
    @NotNull
    private final PsiSymbolReferenceService mySymbolReferenceService;
    private final PsiReferenceService myPsiReferenceService;

    public PsiSourcedWebSymbolRequestResultProcessor(@NotNull PsiElement targetElement, boolean includeRegularReferences) {
        Intrinsics.checkNotNullParameter((Object)targetElement, (String)"targetElement");
        super(new Object[0]);
        this.targetElement = targetElement;
        this.includeRegularReferences = includeRegularReferences;
        boolean $i$f$service = false;
        Class<PsiSymbolReferenceService> serviceClass$iv = PsiSymbolReferenceService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        this.mySymbolReferenceService = (PsiSymbolReferenceService)object;
        this.myPsiReferenceService = PsiReferenceService.getService();
    }

    /*
     * WARNING - void declaration
     */
    public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<? super PsiReference> consumer2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        if (!this.targetElement.isValid()) {
            return false;
        }
        if (element instanceof PsiExternalReferenceHost) {
            void $this$forEach$iv;
            Sequence $this$filterIsInstance$iv;
            Collection collection = this.mySymbolReferenceService.getReferences(element, PsiSymbolReferenceHints.offsetHint((int)offsetInElement));
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getReferences(...)");
            Sequence sequence = CollectionsKt.asSequence((Iterable)collection);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)processTextOccurrence$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            $this$filterIsInstance$iv = SequencesKt.filter((Sequence)sequence2, (Function1)((Function1)new Function1<WebSymbolReference, Boolean>(offsetInElement){
                final /* synthetic */ int $offsetInElement;
                {
                    this.$offsetInElement = $offsetInElement;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull WebSymbolReference it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.getRangeInElement().containsOffset(this.$offsetInElement);
                }
            }));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiSourcedWebSymbol equivalentSymbol;
                Object v2;
                WebSymbolReference ref;
                block7: {
                    void $this$filterIsInstanceTo$iv$iv;
                    ref = (WebSymbolReference)element$iv;
                    boolean bl = false;
                    ProgressManager.checkCanceled();
                    Iterable $this$filterIsInstance$iv2 = ref.resolveReference();
                    boolean $i$f$filterIsInstance2 = false;
                    Iterable iterable = $this$filterIsInstance$iv2;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof PsiSourcedWebSymbol)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List psiSourcedWebSymbols = (List)destination$iv$iv;
                    if (psiSourcedWebSymbols.isEmpty()) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)PsiSymbolService.getInstance().asSymbol(this.targetElement), (String)"asSymbol(...)");
                    Iterable iterable2 = psiSourcedWebSymbols;
                    for (Object t : iterable2) {
                        Symbol targetSymbol;
                        PsiSourcedWebSymbol it = (PsiSourcedWebSymbol)t;
                        boolean bl2 = false;
                        if (!it.isEquivalentTo(targetSymbol)) continue;
                        v2 = t;
                        break block7;
                    }
                    v2 = null;
                }
                if ((PsiSourcedWebSymbol)v2 == null) continue;
                WebSymbol webSymbol = equivalentSymbol;
                PsiExternalReferenceHost psiExternalReferenceHost = (PsiExternalReferenceHost)element;
                TextRange textRange = ref.getRangeInElement();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getRangeInElement(...)");
                if (consumer2.process((Object)new PsiSourcedWebSymbolReference(webSymbol, this.targetElement, psiExternalReferenceHost, textRange))) continue;
                return false;
            }
        }
        if (this.includeRegularReferences) {
            List list2 = this.myPsiReferenceService.getReferences(element, new PsiReferenceService.Hints(this.targetElement, Integer.valueOf(offsetInElement)));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getReferences(...)");
            List references = list2;
            int n = references.size();
            for (int i = 0; i < n; ++i) {
                PsiReference ref = (PsiReference)references.get(i);
                ProgressManager.checkCanceled();
                if (!ReferenceRange.containsOffsetInElement((PsiReference)ref, (int)offsetInElement) || !ref.isReferenceTo(this.targetElement) || consumer2.process((Object)ref)) continue;
                return false;
            }
        }
        return true;
    }
}

