/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.webTypes.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.intellij.webSymbols.webTypes.json.Pattern;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"node-packages", "script-url-patterns", "file-extensions", "file-name-patterns", "ide-libraries", "project-tool-executables"})
public class EnablementRules {
    @JsonProperty(value="node-packages")
    @JsonPropertyDescription(value="Node.js package names, which enable framework support within the folder containing the package.json.")
    private List<String> nodePackages = new ArrayList<String>();
    @JsonProperty(value="script-url-patterns")
    @JsonPropertyDescription(value="RegExps to match script URLs, which enable framework support within a particular HTML.")
    private List<Pattern> scriptUrlPatterns = new ArrayList<Pattern>();
    @JsonProperty(value="file-extensions")
    @JsonPropertyDescription(value="Extensions of files, which should have the framework support enabled. Use this to support custom file extensions like '.vue' or '.svelte'. Never specify generic extensions like '.html', '.js' or '.ts'. If you need your contributions to be present in every file don't specify the framework at all")
    private List<String> fileExtensions = new ArrayList<String>();
    @JsonProperty(value="file-name-patterns")
    @JsonPropertyDescription(value="RegExp patterns to match file names, which should have the framework support enabled. Use carefully as broken pattern may even freeze IDE.")
    private List<Pattern> fileNamePatterns = new ArrayList<Pattern>();
    @JsonProperty(value="ide-libraries")
    @JsonPropertyDescription(value="Global JavaScript libraries names enabled within the IDE, which enable framework support in the whole project")
    private List<String> ideLibraries = new ArrayList<String>();
    @JsonProperty(value="project-tool-executables")
    @JsonPropertyDescription(value="List of tool executables (without extension), which presence should be checked in the project. In case of Node projects, such tools will be searched in node_modules/.bin/")
    private List<String> projectToolExecutables = new ArrayList<String>();

    @JsonProperty(value="node-packages")
    public List<String> getNodePackages() {
        return this.nodePackages;
    }

    @JsonProperty(value="node-packages")
    public void setNodePackages(List<String> nodePackages) {
        this.nodePackages = nodePackages;
    }

    @JsonProperty(value="script-url-patterns")
    public List<Pattern> getScriptUrlPatterns() {
        return this.scriptUrlPatterns;
    }

    @JsonProperty(value="script-url-patterns")
    public void setScriptUrlPatterns(List<Pattern> scriptUrlPatterns) {
        this.scriptUrlPatterns = scriptUrlPatterns;
    }

    @JsonProperty(value="file-extensions")
    public List<String> getFileExtensions() {
        return this.fileExtensions;
    }

    @JsonProperty(value="file-extensions")
    public void setFileExtensions(List<String> fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    @JsonProperty(value="file-name-patterns")
    public List<Pattern> getFileNamePatterns() {
        return this.fileNamePatterns;
    }

    @JsonProperty(value="file-name-patterns")
    public void setFileNamePatterns(List<Pattern> fileNamePatterns) {
        this.fileNamePatterns = fileNamePatterns;
    }

    @JsonProperty(value="ide-libraries")
    public List<String> getIdeLibraries() {
        return this.ideLibraries;
    }

    @JsonProperty(value="ide-libraries")
    public void setIdeLibraries(List<String> ideLibraries) {
        this.ideLibraries = ideLibraries;
    }

    @JsonProperty(value="project-tool-executables")
    public List<String> getProjectToolExecutables() {
        return this.projectToolExecutables;
    }

    @JsonProperty(value="project-tool-executables")
    public void setProjectToolExecutables(List<String> projectToolExecutables) {
        this.projectToolExecutables = projectToolExecutables;
    }
}

