/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.validations;

import com.jetbrains.jsonSchema.extension.JsonSchemaValidation;
import com.jetbrains.jsonSchema.extension.JsonValidationHost;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.IfThenElse;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.List;

public final class IfThenElseValidation
implements JsonSchemaValidation {
    public static final IfThenElseValidation INSTANCE = new IfThenElseValidation();

    @Override
    public void validate(JsonValueAdapter propValue, JsonSchemaObject schema, JsonSchemaType schemaType, JsonValidationHost consumer2, JsonComplianceCheckerOptions options) {
        List<IfThenElse> ifThenElseList = schema.getIfThenElse();
        assert (ifThenElseList != null);
        for (IfThenElse ifThenElse : ifThenElseList) {
            MatchResult result2 = consumer2.resolve(ifThenElse.getIf());
            if (result2.mySchemas.isEmpty() && result2.myExcludingSchemas.isEmpty()) {
                return;
            }
            JsonValidationHost checker = consumer2.checkByMatchResult(propValue, result2, options.withForcedStrict());
            if (checker == null) continue;
            if (checker.isValid()) {
                JsonSchemaObject then2 = ifThenElse.getThen();
                if (then2 == null) continue;
                consumer2.checkObjectBySchemaRecordErrors(then2, propValue);
                continue;
            }
            JsonSchemaObject schemaElse = ifThenElse.getElse();
            if (schemaElse == null) continue;
            consumer2.checkObjectBySchemaRecordErrors(schemaElse, propValue);
        }
    }
}

