/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.Alphabet;
import com.thaiopensource.relaxng.impl.BinaryPattern;
import com.thaiopensource.relaxng.impl.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternFunction;
import com.thaiopensource.relaxng.impl.PatternVisitor;
import com.thaiopensource.relaxng.impl.RestrictionViolationException;
import com.thaiopensource.relaxng.impl.SchemaPatternBuilder;

class ChoicePattern
extends BinaryPattern {
    ChoicePattern(Pattern pattern2, Pattern pattern3) {
        super(pattern2.isNullable() || pattern3.isNullable(), Pattern.combineHashCode(11, pattern2.hashCode(), pattern3.hashCode()), pattern2, pattern3);
    }

    Pattern expand(SchemaPatternBuilder schemaPatternBuilder) {
        Pattern pattern2 = this.p1.expand(schemaPatternBuilder);
        Pattern pattern3 = this.p2.expand(schemaPatternBuilder);
        if (pattern2 != this.p1 || pattern3 != this.p2) {
            return schemaPatternBuilder.makeChoice(pattern2, pattern3);
        }
        return this;
    }

    boolean containsChoice(Pattern pattern2) {
        return this.p1.containsChoice(pattern2) || this.p2.containsChoice(pattern2);
    }

    void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitChoice(this.p1, this.p2);
    }

    Object apply(PatternFunction patternFunction) {
        return patternFunction.caseChoice(this);
    }

    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        if (duplicateAttributeDetector != null) {
            duplicateAttributeDetector.startChoice();
        }
        this.p1.checkRestrictions(n, duplicateAttributeDetector, alphabet);
        if (duplicateAttributeDetector != null) {
            duplicateAttributeDetector.alternative();
        }
        this.p2.checkRestrictions(n, duplicateAttributeDetector, alphabet);
        if (duplicateAttributeDetector != null) {
            duplicateAttributeDetector.endChoice();
        }
    }
}

