/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.SourceMapData;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u0013\u0010\u0016\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H\u00c6\u0003JS\u0010\u0019\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0012\b\u0002\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u001e\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006 "}, d2={"Lorg/jetbrains/debugger/sourcemap/SourceMapDataImpl;", "Lorg/jetbrains/debugger/sourcemap/SourceMapData;", "file", "", "sources", "", "sourcesContent", "hasNameMappings", "", "mappings", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;ZLjava/util/List;)V", "getFile", "()Ljava/lang/String;", "getHasNameMappings", "()Z", "getMappings", "()Ljava/util/List;", "getSources", "getSourcesContent", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "toString", "intellij.platform.scriptDebugger.backend"})
public final class SourceMapDataImpl
implements SourceMapData {
    @Nullable
    private final String file;
    @NotNull
    private final List<String> sources;
    @Nullable
    private final List<String> sourcesContent;
    private final boolean hasNameMappings;
    @NotNull
    private final List<MappingEntry> mappings;

    public SourceMapDataImpl(@Nullable String file, @NotNull List<String> sources, @Nullable List<String> sourcesContent, boolean hasNameMappings, @NotNull List<? extends MappingEntry> mappings) {
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        this.file = file;
        this.sources = sources;
        this.sourcesContent = sourcesContent;
        this.hasNameMappings = hasNameMappings;
        this.mappings = mappings;
    }

    @Override
    @Nullable
    public String getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public List<String> getSources() {
        return this.sources;
    }

    @Override
    @Nullable
    public List<String> getSourcesContent() {
        return this.sourcesContent;
    }

    @Override
    public boolean getHasNameMappings() {
        return this.hasNameMappings;
    }

    @Override
    @NotNull
    public List<MappingEntry> getMappings() {
        return this.mappings;
    }

    @Nullable
    public final String component1() {
        return this.file;
    }

    @NotNull
    public final List<String> component2() {
        return this.sources;
    }

    @Nullable
    public final List<String> component3() {
        return this.sourcesContent;
    }

    public final boolean component4() {
        return this.hasNameMappings;
    }

    @NotNull
    public final List<MappingEntry> component5() {
        return this.mappings;
    }

    @NotNull
    public final SourceMapDataImpl copy(@Nullable String file, @NotNull List<String> sources, @Nullable List<String> sourcesContent, boolean hasNameMappings, @NotNull List<? extends MappingEntry> mappings) {
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        return new SourceMapDataImpl(file, sources, sourcesContent, hasNameMappings, mappings);
    }

    public static /* synthetic */ SourceMapDataImpl copy$default(SourceMapDataImpl sourceMapDataImpl, String string2, List list2, List list3, boolean bl, List list4, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = sourceMapDataImpl.file;
        }
        if ((n & 2) != 0) {
            list2 = sourceMapDataImpl.sources;
        }
        if ((n & 4) != 0) {
            list3 = sourceMapDataImpl.sourcesContent;
        }
        if ((n & 8) != 0) {
            bl = sourceMapDataImpl.hasNameMappings;
        }
        if ((n & 0x10) != 0) {
            list4 = sourceMapDataImpl.mappings;
        }
        return sourceMapDataImpl.copy(string2, list2, list3, bl, list4);
    }

    @NotNull
    public String toString() {
        return "SourceMapDataImpl(file=" + this.file + ", sources=" + this.sources + ", sourcesContent=" + this.sourcesContent + ", hasNameMappings=" + this.hasNameMappings + ", mappings=" + this.mappings + ")";
    }

    public int hashCode() {
        int result2 = this.file == null ? 0 : this.file.hashCode();
        result2 = result2 * 31 + ((Object)this.sources).hashCode();
        result2 = result2 * 31 + (this.sourcesContent == null ? 0 : ((Object)this.sourcesContent).hashCode());
        int n = this.hasNameMappings ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result2 = result2 * 31 + n;
        result2 = result2 * 31 + ((Object)this.mappings).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SourceMapDataImpl)) {
            return false;
        }
        SourceMapDataImpl sourceMapDataImpl = (SourceMapDataImpl)other;
        if (!Intrinsics.areEqual((Object)this.file, (Object)sourceMapDataImpl.file)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.sources, sourceMapDataImpl.sources)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.sourcesContent, sourceMapDataImpl.sourcesContent)) {
            return false;
        }
        if (this.hasNameMappings != sourceMapDataImpl.hasNameMappings) {
            return false;
        }
        return Intrinsics.areEqual(this.mappings, sourceMapDataImpl.mappings);
    }
}

