/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.cloud;

import com.intellij.ide.BrowserUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.cloud.QodanaCloudDefaultUrls;
import org.jetbrains.qodana.cloud.QodanaCloudStateService;
import org.jetbrains.qodana.cloud.UserState;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001a\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0000\u00a8\u0006\b"}, d2={"currentQodanaCloudFrontendUrl", "Lcom/intellij/util/Url;", "openBrowserWithCurrentQodanaCloudFrontend", "", "projectFrontendUrlForCurrentQodanaCloud", "projectId", "", "reportId", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaCloudDefaultUrls.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaCloudDefaultUrls.kt\norg/jetbrains/qodana/cloud/QodanaCloudDefaultUrlsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class QodanaCloudDefaultUrlsKt {
    @NotNull
    public static final Url currentQodanaCloudFrontendUrl() {
        Url url;
        UserState userState = (UserState)QodanaCloudStateService.Companion.getInstance().getUserState().getValue();
        UserState userState2 = userState;
        if (userState2 instanceof UserState.Authorized) {
            url = ((UserState.Authorized)userState).getEnvironment().getFrontendUrl();
        } else if (userState2 instanceof UserState.Authorizing) {
            url = ((UserState.Authorizing)userState).getEnvironment().getFrontendUrl();
        } else if (userState2 instanceof UserState.NotAuthorized) {
            url = Urls.newFromEncoded((String)QodanaCloudDefaultUrls.INSTANCE.getWebsiteUrl());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return url;
    }

    public static final void openBrowserWithCurrentQodanaCloudFrontend() {
        BrowserUtil.browse((String)QodanaCloudDefaultUrlsKt.currentQodanaCloudFrontendUrl().toString());
    }

    @NotNull
    public static final Url projectFrontendUrlForCurrentQodanaCloud(@NotNull String projectId, @Nullable String reportId2) {
        Url url;
        Url url2;
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Url url3 = QodanaCloudDefaultUrlsKt.currentQodanaCloudFrontendUrl().resolve("projects/" + projectId);
        Intrinsics.checkNotNullExpressionValue((Object)url3, (String)"resolve(...)");
        Url urlWithProject = url3;
        String string = reportId2;
        if (string != null) {
            String it = string;
            boolean bl = false;
            url2 = urlWithProject.resolve("reports/" + reportId2);
        } else {
            url2 = url = null;
        }
        if (url2 == null) {
            url = urlWithProject;
        }
        return url;
    }
}

