/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.cloud.authorization;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirer;
import com.intellij.collaboration.auth.services.OAuthRequest;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.cloud.api.QodanaCloudEnvironment;
import org.jetbrains.qodana.cloud.authorization.QodanaCloudOAuthCredentialsAcquirer;
import org.jetbrains.qodana.cloud.authorization.QodanaCloudOAuthService;
import org.jetbrains.qodana.cloud.authorization.credentials.QodanaCloudCredentials;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/qodana/cloud/authorization/QodanaCloudOAuthRequest;", "Lcom/intellij/collaboration/auth/services/OAuthRequest;", "Lorg/jetbrains/qodana/cloud/authorization/credentials/QodanaCloudCredentials;", "port", "", "environment", "Lorg/jetbrains/qodana/cloud/api/QodanaCloudEnvironment;", "authUrlWithParameters", "Lcom/intellij/util/Url;", "authReferrer", "(ILorg/jetbrains/qodana/cloud/api/QodanaCloudEnvironment;Lcom/intellij/util/Url;Lcom/intellij/util/Url;)V", "getAuthReferrer", "()Lcom/intellij/util/Url;", "getAuthUrlWithParameters", "authorizationCodeUrl", "getAuthorizationCodeUrl", "credentialsAcquirer", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer;", "getCredentialsAcquirer", "()Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer;", "getEnvironment", "()Lorg/jetbrains/qodana/cloud/api/QodanaCloudEnvironment;", "getPort", "()I", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaCloudOAuthRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaCloudOAuthRequest.kt\norg/jetbrains/qodana/cloud/authorization/QodanaCloudOAuthRequest\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,25:1\n43#2,3:26\n*S KotlinDebug\n*F\n+ 1 QodanaCloudOAuthRequest.kt\norg/jetbrains/qodana/cloud/authorization/QodanaCloudOAuthRequest\n*L\n21#1:26,3\n*E\n"})
public final class QodanaCloudOAuthRequest
implements OAuthRequest<QodanaCloudCredentials> {
    private final int port;
    @NotNull
    private final QodanaCloudEnvironment environment;
    @NotNull
    private final Url authUrlWithParameters;
    @NotNull
    private final Url authReferrer;

    public QodanaCloudOAuthRequest(int port, @NotNull QodanaCloudEnvironment environment2, @NotNull Url authUrlWithParameters, @NotNull Url authReferrer) {
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)authUrlWithParameters, (String)"authUrlWithParameters");
        Intrinsics.checkNotNullParameter((Object)authReferrer, (String)"authReferrer");
        this.port = port;
        this.environment = environment2;
        this.authUrlWithParameters = authUrlWithParameters;
        this.authReferrer = authReferrer;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final QodanaCloudEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public Url getAuthUrlWithParameters() {
        return this.authUrlWithParameters;
    }

    @NotNull
    public final Url getAuthReferrer() {
        return this.authReferrer;
    }

    @NotNull
    public Url getAuthorizationCodeUrl() {
        boolean $i$f$service = false;
        Class<QodanaCloudOAuthService> serviceClass$iv = QodanaCloudOAuthService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return Urls.newFromEncoded((String)("http://localhost:" + this.port + "/api/" + ((QodanaCloudOAuthService)object).getName() + "/authorization_code/"));
    }

    @NotNull
    public OAuthCredentialsAcquirer<QodanaCloudCredentials> getCredentialsAcquirer() {
        return new QodanaCloudOAuthCredentialsAcquirer(this.environment);
    }
}

