/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.ui.problemsView.viewModel.impl;

import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.highlight.HighlightedReportState;
import org.jetbrains.qodana.highlight.HighlightedReportStateKt;
import org.jetbrains.qodana.highlight.QodanaHighlightedReportService;
import org.jetbrains.qodana.report.ReportDescriptor;
import org.jetbrains.qodana.stats.QodanaPluginStatsCounterCollector;
import org.jetbrains.qodana.stats.QodanaPluginStatsCounterCollectorKt;
import org.jetbrains.qodana.ui.problemsView.viewModel.QodanaProblemsViewModel;
import org.jetbrains.qodana.ui.problemsView.viewModel.UtilsKt;
import org.jetbrains.qodana.ui.problemsView.viewModel.impl.ReportInteractor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\bH\u0002J\b\u0010\r\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/qodana/ui/problemsView/viewModel/impl/UiStateLoadingReportImpl;", "Lorg/jetbrains/qodana/ui/problemsView/viewModel/QodanaProblemsViewModel$UiState$LoadingReport;", "project", "Lcom/intellij/openapi/project/Project;", "reportInteractor", "Lorg/jetbrains/qodana/ui/problemsView/viewModel/impl/ReportInteractor;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/qodana/ui/problemsView/viewModel/impl/ReportInteractor;)V", "cancel", "", "closeReport", "getView", "Ljavax/swing/JComponent;", "logCancelReportLoadingStats", "refreshReport", "intellij.qodana"})
public final class UiStateLoadingReportImpl
implements QodanaProblemsViewModel.UiState.LoadingReport {
    @NotNull
    private final Project project;
    @NotNull
    private final ReportInteractor reportInteractor;

    public UiStateLoadingReportImpl(@NotNull Project project2, @NotNull ReportInteractor reportInteractor) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)reportInteractor, (String)"reportInteractor");
        this.project = project2;
        this.reportInteractor = reportInteractor;
    }

    @Override
    public void cancel() {
        this.reportInteractor.close();
        this.logCancelReportLoadingStats();
    }

    @Override
    public void refreshReport() {
        this.reportInteractor.refresh();
    }

    @Override
    public void closeReport() {
        this.reportInteractor.close();
    }

    @Override
    @NotNull
    public JComponent getView() {
        String string = QodanaBundle.message("qodana.panel.loading.results", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return UtilsKt.wrapWithWeight((JPanel)UtilsKt.loadingIconView$default(string, (Function0)new Function0<Unit>(this){
            final /* synthetic */ UiStateLoadingReportImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.cancel();
            }
        }, null, 4, null), 0.33);
    }

    private final void logCancelReportLoadingStats() {
        HighlightedReportState highlightedReportState = (HighlightedReportState)QodanaHighlightedReportService.Companion.getInstance(this.project).getHighlightedReportState().getValue();
        ReportDescriptor reportDescriptor = HighlightedReportStateKt.getReportDescriptorIfSelectedOrLoading(highlightedReportState);
        if (reportDescriptor == null) {
            return;
        }
        ReportDescriptor reportDescriptor2 = reportDescriptor;
        QodanaPluginStatsCounterCollector.UPDATE_HIGHLIGHTED_REPORT.log(this.project, (Object)false, (Object)QodanaPluginStatsCounterCollectorKt.toStatsReportType(reportDescriptor2), (Object)QodanaPluginStatsCounterCollector.SourceHighlight.QODANA_PANEL_CANCEL_LOADING);
    }
}

