/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.detector.utils.filter;

import ai.grazie.detector.utils.filter.TextFilter;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lai/grazie/detector/utils/filter/EnglishCapitalizedWordsTextFilter;", "Lai/grazie/detector/utils/filter/TextFilter;", "()V", "bigLetters", "Lkotlin/text/Regex;", "endPunctuation", "", "", "letter", "filter", "", "text", "nlp-detect"})
public final class EnglishCapitalizedWordsTextFilter
implements TextFilter {
    @NotNull
    public static final EnglishCapitalizedWordsTextFilter INSTANCE = new EnglishCapitalizedWordsTextFilter();
    @NotNull
    private static final Regex bigLetters = new Regex("[A-Z]");
    @NotNull
    private static final Regex letter = new Regex("[A-Za-z]");
    @NotNull
    private static final Set<Character> endPunctuation;

    private EnglishCapitalizedWordsTextFilter() {
    }

    @Override
    @NotNull
    public CharSequence filter(@NotNull CharSequence text2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        boolean isStartPhrase = false;
        isStartPhrase = true;
        boolean isStartWord = false;
        isStartWord = true;
        boolean skipWhileLetters = false;
        StringBuilder $this$filter_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (CharsKt.isWhitespace((char)c)) {
                skipWhileLetters = false;
                isStartWord = true;
                $this$filter_u24lambda_u240.append(c);
                continue;
            }
            if (endPunctuation.contains(Character.valueOf(c))) {
                skipWhileLetters = false;
                isStartPhrase = true;
                $this$filter_u24lambda_u240.append(c);
                continue;
            }
            if (skipWhileLetters && letter.matches((CharSequence)String.valueOf(c))) {
                isStartPhrase = false;
                isStartWord = false;
                continue;
            }
            if (!skipWhileLetters && !isStartPhrase && isStartWord && bigLetters.matches((CharSequence)String.valueOf(c))) {
                skipWhileLetters = true;
                isStartPhrase = false;
                isStartWord = false;
                continue;
            }
            $this$filter_u24lambda_u240.append(c);
            isStartPhrase = false;
            isStartWord = false;
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('.'), Character.valueOf('!'), Character.valueOf('?')};
        endPunctuation = SetsKt.setOf((Object[])objectArray);
    }
}

